/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.MiscUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RoundRobinPipeEntity
extends ItemPipeEntity {
    protected Direction nextDirection = Direction.DOWN;

    public RoundRobinPipeEntity(BlockPos pos, BlockState state) {
        this(ClassicPipes.BASIC_PIPE_ENTITY, pos, state);
    }

    public RoundRobinPipeEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    protected void updateRoundRobin(List<Direction> validDirections) {
        if (!validDirections.isEmpty()) {
            do {
                this.nextDirection = MiscUtil.nextDirection(this.nextDirection);
            } while (!validDirections.contains(this.nextDirection));
        }
    }

    protected List<Direction> getValidDirections(BlockState state, ItemInPipe item) {
        ArrayList<Direction> validDirections = new ArrayList<Direction>();
        Direction direction = MiscUtil.nextDirection(item.getFromDirection());
        for (int i = 0; i < 5; ++i) {
            if (this.isPipeConnected(state, direction)) {
                validDirections.add(direction);
            }
            direction = MiscUtil.nextDirection(direction);
        }
        return validDirections;
    }

    @Override
    public void routeItem(BlockState state, ItemInPipe item) {
        List<Direction> validDirections = this.getValidDirections(state, item);
        if (validDirections.size() == 1) {
            item.setTargetDirection(validDirections.getFirst());
            item.setEjecting(false);
        } else if (validDirections.isEmpty() || this.nextDirection == null) {
            item.setTargetDirection(item.getFromDirection().getOpposite());
            item.setEjecting(true);
        } else {
            int count;
            if (!validDirections.contains(this.nextDirection)) {
                this.updateRoundRobin(validDirections);
            }
            if ((count = item.getStack().getCount()) == 1) {
                item.setTargetDirection(this.nextDirection);
                item.setEjecting(false);
                this.updateRoundRobin(validDirections);
            } else {
                HashMap<Direction, Integer> routeMap = new HashMap<Direction, Integer>();
                validDirections.forEach(direction -> routeMap.put((Direction)direction, 0));
                for (int i = 0; i < count; ++i) {
                    routeMap.put(this.nextDirection, (Integer)routeMap.get(this.nextDirection) + 1);
                    this.updateRoundRobin(validDirections);
                }
                boolean inputRouted = false;
                for (Direction direction2 : validDirections) {
                    int routeCount = (Integer)routeMap.get(direction2);
                    if (routeCount <= 0) continue;
                    if (!inputRouted) {
                        inputRouted = true;
                        item.setStack(item.getStack().copyWithCount(routeCount));
                        item.setTargetDirection(direction2);
                        item.setEjecting(false);
                        continue;
                    }
                    this.queued.add(new ItemInPipe(item.getStack().copyWithCount(routeCount), item.getSpeed(), item.getProgress(), item.getFromDirection(), direction2, false, item.getAge()));
                }
            }
        }
    }

    @Override
    public short getTargetSpeed() {
        return 64;
    }

    @Override
    public short getAcceleration() {
        return 1;
    }

    @Override
    protected void loadAdditional(CompoundTag valueInput, HolderLookup.Provider registries) {
        super.loadAdditional(valueInput, registries);
        this.nextDirection = Direction.from3DDataValue((int)valueInput.getByte("next_direction"));
    }

    @Override
    protected void saveAdditional(CompoundTag valueOutput, HolderLookup.Provider registries) {
        super.saveAdditional(valueOutput, registries);
        valueOutput.putByte("next_direction", (byte)this.nextDirection.get3DDataValue());
    }
}

