/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.inventory.container;

import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.blockentity.ProviderPipeEntity;
import jagm.classicpipes.blockentity.StockingPipeEntity;
import jagm.classicpipes.inventory.container.Filter;
import jagm.classicpipes.item.LabelItem;
import jagm.classicpipes.item.TagLabelItem;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FilterContainer
implements Filter {
    private final NonNullList<ItemStack> filter;
    private final PipeEntity pipe;
    private final int size;
    private boolean matchComponents;

    public FilterContainer(PipeEntity pipe, int size, boolean matchComponents) {
        this.pipe = pipe;
        this.filter = NonNullList.create();
        this.size = size;
        this.matchComponents = matchComponents;
        this.clearContent();
    }

    public int getMaxStackSize() {
        return 999;
    }

    public int getContainerSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.filter.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.filter.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        this.filter.set(slot, (Object)ItemStack.EMPTY);
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.removeItem(slot, 1);
    }

    public void setItem(int slot, ItemStack stack) {
        this.filter.set(slot, (Object)stack);
    }

    public void setChanged() {
        if (this.pipe != null) {
            this.pipe.setChanged();
            PipeEntity pipeEntity = this.pipe;
            if (pipeEntity instanceof ProviderPipeEntity) {
                ProviderPipeEntity providerPipe = (ProviderPipeEntity)pipeEntity;
                providerPipe.updateCache();
            } else {
                pipeEntity = this.pipe;
                if (pipeEntity instanceof StockingPipeEntity) {
                    StockingPipeEntity stockingPipe = (StockingPipeEntity)pipeEntity;
                    stockingPipe.updateCache();
                }
            }
        }
    }

    public boolean stillValid(Player player) {
        if (this.pipe != null) {
            return Container.stillValidBlockEntity((BlockEntity)this.pipe, (Player)player);
        }
        return true;
    }

    public void clearContent() {
        this.filter.clear();
        this.filter.addAll((Collection)NonNullList.withSize((int)this.size, (Object)ItemStack.EMPTY));
    }

    @Override
    public void setMatchComponents(boolean matchComponents) {
        this.matchComponents = matchComponents;
        this.setChanged();
    }

    @Override
    public boolean shouldMatchComponents() {
        return this.matchComponents;
    }

    @Override
    public PipeEntity getPipe() {
        return this.pipe;
    }

    public Filter.MatchingResult matches(ItemStack stack) {
        for (ItemStack filterStack : this.filter) {
            LabelItem labelItem;
            Item item = filterStack.getItem();
            if (item instanceof LabelItem && (labelItem = (LabelItem)item).itemMatches(filterStack, stack)) {
                return labelItem instanceof TagLabelItem ? Filter.MatchingResult.TAG : Filter.MatchingResult.MOD;
            }
            if (!filterStack.is(stack.getItem()) || this.shouldMatchComponents() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)filterStack)) continue;
            return Filter.MatchingResult.ITEM;
        }
        return Filter.MatchingResult.FALSE;
    }
}

