/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.network;

import jagm.classicpipes.blockentity.RecipePipeEntity;
import jagm.classicpipes.network.SelfHandler;
import jagm.classicpipes.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public record ServerBoundSlotDirectionPayload(BlockPos pos, int slot, Direction direction) implements SelfHandler
{
    public static final CustomPacketPayload.Type<ServerBoundSlotDirectionPayload> TYPE = new CustomPacketPayload.Type(MiscUtil.resourceLocation("slot_direction"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerBoundSlotDirectionPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ServerBoundSlotDirectionPayload::pos, (StreamCodec)ByteBufCodecs.INT, ServerBoundSlotDirectionPayload::slot, (StreamCodec)ByteBufCodecs.BYTE, payload -> (byte)payload.direction().get3DDataValue(), (pos, slot, directionByte) -> new ServerBoundSlotDirectionPayload((BlockPos)pos, (int)slot, Direction.from3DDataValue((int)directionByte.byteValue())));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void handle(Player player) {
        BlockEntity blockEntity = player.level().getBlockEntity(this.pos());
        if (blockEntity instanceof RecipePipeEntity) {
            RecipePipeEntity craftingPipe = (RecipePipeEntity)blockEntity;
            craftingPipe.setSlotDirection(this.slot(), this.direction());
        }
    }
}

