/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.PipeBlock;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.blockentity.RequestPipeEntity;
import jagm.classicpipes.blockentity.RoutingPipeEntity;
import jagm.classicpipes.inventory.menu.RequestMenu;
import jagm.classicpipes.network.ClientBoundItemListPayload;
import jagm.classicpipes.network.ClientBoundTwoBoolsPayload;
import jagm.classicpipes.services.Services;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class NetworkedPipeBlock
extends PipeBlock {
    public static final EnumProperty<ConnectionState> NORTH = EnumProperty.m_61598_((String)"north", ConnectionState.class, (Enum[])ConnectionState.values());
    public static final EnumProperty<ConnectionState> EAST = EnumProperty.m_61598_((String)"east", ConnectionState.class, (Enum[])ConnectionState.values());
    public static final EnumProperty<ConnectionState> SOUTH = EnumProperty.m_61598_((String)"south", ConnectionState.class, (Enum[])ConnectionState.values());
    public static final EnumProperty<ConnectionState> WEST = EnumProperty.m_61598_((String)"west", ConnectionState.class, (Enum[])ConnectionState.values());
    public static final EnumProperty<ConnectionState> UP = EnumProperty.m_61598_((String)"up", ConnectionState.class, (Enum[])ConnectionState.values());
    public static final EnumProperty<ConnectionState> DOWN = EnumProperty.m_61598_((String)"down", ConnectionState.class, (Enum[])ConnectionState.values());
    public static final Map<Direction, EnumProperty<ConnectionState>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(Direction.NORTH, NORTH, Direction.EAST, EAST, Direction.SOUTH, SOUTH, Direction.WEST, WEST, Direction.UP, UP, Direction.DOWN, DOWN)));

    public NetworkedPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(NORTH, (Comparable)((Object)ConnectionState.NONE))).m_61124_(EAST, (Comparable)((Object)ConnectionState.NONE))).m_61124_(SOUTH, (Comparable)((Object)ConnectionState.NONE))).m_61124_(WEST, (Comparable)((Object)ConnectionState.NONE))).m_61124_(UP, (Comparable)((Object)ConnectionState.NONE))).m_61124_(DOWN, (Comparable)((Object)ConnectionState.NONE)));
    }

    @Override
    public boolean isPipeConnected(BlockState state, Direction direction) {
        return !((ConnectionState)((Object)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction)))).equals((Object)ConnectionState.NONE);
    }

    @Override
    public BlockState setPipeConnected(BlockState state, Direction direction, boolean connected) {
        return (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)((Object)(connected ? (this.isLinked(state, direction) ? ConnectionState.LINKED : ConnectionState.UNLINKED) : ConnectionState.NONE)));
    }

    public boolean isLinked(BlockState state, Direction direction) {
        return ((ConnectionState)((Object)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(direction)))).equals((Object)ConnectionState.LINKED);
    }

    public BlockState setLinked(BlockState state, Direction direction, boolean linked) {
        return (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)((Object)(linked ? ConnectionState.LINKED : ConnectionState.UNLINKED)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RoutingPipeEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == ClassicPipes.ROUTING_PIPE_ENTITY ? PipeEntity::tick : null;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState superState = super.m_5573_(context);
        if (superState != null) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)superState.m_263224_(NORTH, (Comparable)((Object)(this.canConnect(context.m_43725_(), context.m_8083_(), Direction.NORTH) ? ConnectionState.UNLINKED : ConnectionState.NONE)))).m_263224_(EAST, (Comparable)((Object)(this.canConnect(context.m_43725_(), context.m_8083_(), Direction.EAST) ? ConnectionState.UNLINKED : ConnectionState.NONE)))).m_263224_(SOUTH, (Comparable)((Object)(this.canConnect(context.m_43725_(), context.m_8083_(), Direction.SOUTH) ? ConnectionState.UNLINKED : ConnectionState.NONE)))).m_263224_(WEST, (Comparable)((Object)(this.canConnect(context.m_43725_(), context.m_8083_(), Direction.WEST) ? ConnectionState.UNLINKED : ConnectionState.NONE)))).m_263224_(UP, (Comparable)((Object)(this.canConnect(context.m_43725_(), context.m_8083_(), Direction.UP) ? ConnectionState.UNLINKED : ConnectionState.NONE)))).m_263224_(DOWN, (Comparable)((Object)(this.canConnect(context.m_43725_(), context.m_8083_(), Direction.DOWN) ? ConnectionState.UNLINKED : ConnectionState.NONE)));
        }
        return this.m_49966_();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pipePos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        ItemStack handStack = player.m_21120_(hand);
        if (handStack.m_41720_().equals(ClassicPipes.PIPE_SLICER)) {
            if (player instanceof ServerPlayer) {
                NetworkedPipeEntity networkedPipe;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BlockEntity blockEntity2 = level.m_7702_(pipePos);
                if (blockEntity2 instanceof NetworkedPipeEntity && (networkedPipe = (NetworkedPipeEntity)blockEntity2).hasNetwork()) {
                    final ClientBoundItemListPayload payload = networkedPipe.getNetwork().requestItemList(pipePos);
                    Services.LOADER_SERVICE.openMenu(serverPlayer, new MenuProvider(){

                        public Component m_5446_() {
                            return RequestPipeEntity.TITLE;
                        }

                        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                            return new RequestMenu(id, inventory, payload);
                        }
                    }, payload, ClientBoundItemListPayload.HANDLER);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)ClassicPipes.PIPE_SLICER));
                }
            }
        } else if (level instanceof ServerLevel && (blockEntity = level.m_7702_(pipePos)) instanceof RoutingPipeEntity) {
            RoutingPipeEntity routingPipe = (RoutingPipeEntity)blockEntity;
            Services.LOADER_SERVICE.openMenu((ServerPlayer)player, routingPipe, new ClientBoundTwoBoolsPayload(routingPipe.shouldMatchComponents(), routingPipe.isDefaultRoute()), ClientBoundTwoBoolsPayload.HANDLER);
        }
        return InteractionResult.SUCCESS;
    }

    public static enum ConnectionState implements StringRepresentable
    {
        NONE,
        UNLINKED,
        LINKED;


        public String m_7912_() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NONE -> "none";
                case UNLINKED -> "unlinked";
                case LINKED -> "linked";
            };
        }
    }
}

