/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.CopperFluidPipeBlock;
import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;

public class CopperFluidPipeEntity
extends FluidPipeEntity {
    private static final byte DEFAULT_COOLDOWN = 4;
    private byte cooldown = (byte)4;

    public CopperFluidPipeEntity(BlockPos pos, BlockState state) {
        this(ClassicPipes.COPPER_FLUID_PIPE_ENTITY, pos, state);
    }

    public CopperFluidPipeEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        super.tickServer(level, pos, state);
        if (((Boolean)state.m_61143_((Property)CopperFluidPipeBlock.ENABLED)).booleanValue() && state.m_61143_(CopperFluidPipeBlock.FACING) != FacingOrNone.NONE) {
            byte by = this.cooldown;
            this.cooldown = (byte)(by - 1);
            if (by <= 0) {
                Direction direction = ((FacingOrNone)((Object)state.m_61143_(CopperFluidPipeBlock.FACING))).getDirection();
                if (Services.LOADER_SERVICE.handleFluidExtraction(this, state, level, pos.m_121945_(direction), direction.m_122424_(), this.extractAmount(), this.filterPredicate())) {
                    level.m_7260_(pos, state, state, 2);
                    this.m_6596_();
                }
                this.cooldown = (byte)4;
            }
        }
    }

    protected int extractAmount() {
        return 125;
    }

    protected Predicate<Fluid> filterPredicate() {
        return fluid -> true;
    }

    @Override
    public void m_142466_(CompoundTag valueInput) {
        super.m_142466_(valueInput);
        this.cooldown = valueInput.m_128445_("cooldown");
    }

    @Override
    protected void m_183515_(CompoundTag valueOutput) {
        super.m_183515_(valueOutput);
        valueOutput.m_128344_("cooldown", this.cooldown);
    }
}

