/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import jagm.classicpipes.block.FluidPipeBlock;
import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.client.renderer.FluidRenderInfo;
import jagm.classicpipes.services.Services;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class FluidPipeRenderer
implements BlockEntityRenderer<FluidPipeEntity> {
    private final BlockEntityRendererProvider.Context context;

    public FluidPipeRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(FluidPipeEntity pipe, float partialTicks, PoseStack poses, MultiBufferSource bufferSource, int light, int overlay) {
        poses.m_85836_();
        Matrix4f matrix = poses.m_85850_().m_252922_();
        FluidRenderInfo info = Services.LOADER_SERVICE.getFluidRenderInfo(pipe.getFluid().m_76145_(), (BlockAndTintGetter)pipe.m_58904_(), pipe.m_58899_());
        TextureAtlasSprite fluidSprite = info.sprite();
        if (fluidSprite == null) {
            fluidSprite = Minecraft.m_91087_().m_91289_().m_110907_().m_110882_(Blocks.f_49990_.m_49966_());
        }
        VertexConsumer vertexBuffer = bufferSource.m_6299_(RenderType.m_110497_((ResourceLocation)fluidSprite.m_247685_()));
        float width = pipe.lastRenderWidth + (pipe.targetRenderWidth - pipe.lastRenderWidth) * partialTicks;
        if (width > 0.01f) {
            float start = 0.5f - width / 2.0f;
            float end = 0.5f + width / 2.0f;
            boolean renderMiddle = false;
            block8: for (Direction direction : Direction.values()) {
                if (pipe.skipRenderingSide[direction.m_122411_()] || !((Boolean)pipe.m_58900_().m_61143_((Property)FluidPipeBlock.PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
                renderMiddle = true;
                boolean[] renderSides = new boolean[6];
                Arrays.fill(renderSides, true);
                renderSides[direction.m_122424_().m_122411_()] = false;
                switch (direction) {
                    case UP: {
                        this.renderFluidCuboid(vertexBuffer, matrix, start, end, start, end, 1.0f, end, fluidSprite, info.tint(), light, renderSides);
                        continue block8;
                    }
                    case DOWN: {
                        this.renderFluidCuboid(vertexBuffer, matrix, start, 0.0f, start, end, start, end, fluidSprite, info.tint(), light, renderSides);
                        continue block8;
                    }
                    case EAST: {
                        this.renderFluidCuboid(vertexBuffer, matrix, end, start, start, 1.0f, end, end, fluidSprite, info.tint(), light, renderSides);
                        continue block8;
                    }
                    case WEST: {
                        this.renderFluidCuboid(vertexBuffer, matrix, 0.0f, start, start, start, end, end, fluidSprite, info.tint(), light, renderSides);
                        continue block8;
                    }
                    case SOUTH: {
                        this.renderFluidCuboid(vertexBuffer, matrix, start, start, end, end, end, 1.0f, fluidSprite, info.tint(), light, renderSides);
                        continue block8;
                    }
                    case NORTH: {
                        this.renderFluidCuboid(vertexBuffer, matrix, start, start, 0.0f, end, end, start, fluidSprite, info.tint(), light, renderSides);
                    }
                }
            }
            if (renderMiddle) {
                this.renderFluidCuboid(vertexBuffer, matrix, start, start, start, end, end, end, fluidSprite, info.tint(), light, pipe.skipRenderingSide);
            }
        }
        poses.m_85849_();
    }

    public void renderFluidCuboid(VertexConsumer vertexBuffer, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, TextureAtlasSprite fluidSprite, int tint, int light, boolean[] renderSide) {
        float u1 = fluidSprite.m_118367_((double)(x1 * 16.0f));
        float u2 = fluidSprite.m_118367_((double)(x2 * 16.0f));
        float v1 = fluidSprite.m_118393_((double)(z1 * 16.0f));
        float v2 = fluidSprite.m_118393_((double)(z2 * 16.0f));
        if (renderSide[Direction.DOWN.m_122411_()]) {
            vertexBuffer.m_252986_(matrix, x1, y1, z2).m_193479_(tint).m_7421_(u1, v2).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x1, y1, z1).m_193479_(tint).m_7421_(u1, v1).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x2, y1, z1).m_193479_(tint).m_7421_(u2, v1).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x2, y1, z2).m_193479_(tint).m_7421_(u2, v2).m_85969_(light).m_5752_();
        }
        if (renderSide[Direction.UP.m_122411_()]) {
            vertexBuffer.m_252986_(matrix, x1, y2, z1).m_193479_(tint).m_7421_(u1, v2).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x1, y2, z2).m_193479_(tint).m_7421_(u1, v1).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x2, y2, z2).m_193479_(tint).m_7421_(u2, v1).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x2, y2, z1).m_193479_(tint).m_7421_(u2, v2).m_85969_(light).m_5752_();
        }
        u1 = fluidSprite.m_118367_((double)(y1 * 16.0f));
        u2 = fluidSprite.m_118367_((double)(y2 * 16.0f));
        v1 = fluidSprite.m_118393_((double)(z1 * 16.0f));
        v2 = fluidSprite.m_118393_((double)(z2 * 16.0f));
        if (renderSide[Direction.WEST.m_122411_()]) {
            vertexBuffer.m_252986_(matrix, x1, y2, z2).m_193479_(tint).m_7421_(u1, v2).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x1, y2, z1).m_193479_(tint).m_7421_(u1, v1).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x1, y1, z1).m_193479_(tint).m_7421_(u2, v1).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x1, y1, z2).m_193479_(tint).m_7421_(u2, v2).m_85969_(light).m_5752_();
        }
        if (renderSide[Direction.EAST.m_122411_()]) {
            vertexBuffer.m_252986_(matrix, x2, y2, z1).m_193479_(tint).m_7421_(u1, v2).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x2, y2, z2).m_193479_(tint).m_7421_(u1, v1).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x2, y1, z2).m_193479_(tint).m_7421_(u2, v1).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x2, y1, z1).m_193479_(tint).m_7421_(u2, v2).m_85969_(light).m_5752_();
        }
        u1 = fluidSprite.m_118367_((double)(y1 * 16.0f));
        u2 = fluidSprite.m_118367_((double)(y2 * 16.0f));
        v1 = fluidSprite.m_118393_((double)(x1 * 16.0f));
        v2 = fluidSprite.m_118393_((double)(x2 * 16.0f));
        if (renderSide[Direction.NORTH.m_122411_()]) {
            vertexBuffer.m_252986_(matrix, x1, y2, z1).m_193479_(tint).m_7421_(u1, v2).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x2, y2, z1).m_193479_(tint).m_7421_(u1, v1).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x2, y1, z1).m_193479_(tint).m_7421_(u2, v1).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x1, y1, z1).m_193479_(tint).m_7421_(u2, v2).m_85969_(light).m_5752_();
        }
        if (renderSide[Direction.SOUTH.m_122411_()]) {
            vertexBuffer.m_252986_(matrix, x2, y2, z2).m_193479_(tint).m_7421_(u1, v2).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x1, y2, z2).m_193479_(tint).m_7421_(u1, v1).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x1, y1, z2).m_193479_(tint).m_7421_(u2, v1).m_85969_(light).m_5752_();
            vertexBuffer.m_252986_(matrix, x2, y1, z2).m_193479_(tint).m_7421_(u2, v2).m_85969_(light).m_5752_();
        }
    }
}

