/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.network;

import jagm.classicpipes.network.SelfHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public record ClientBoundRecipePipePayload(Direction[] slotDirections, List<Direction> availableDirections, BlockPos pos, boolean blockingMode) {
    public static final SelfHandler<ClientBoundRecipePipePayload> HANDLER = new Handler();

    private byte[] getDirectionBytes() {
        byte[] directionBytes = new byte[this.slotDirections().length];
        for (int i = 0; i < this.slotDirections().length; ++i) {
            directionBytes[i] = (byte)this.slotDirections()[i].m_122411_();
        }
        return directionBytes;
    }

    private static ClientBoundRecipePipePayload makePayload(byte[] directionBytes, List<Direction> availableDirections, BlockPos pos, boolean blockingMode) {
        Direction[] directions = new Direction[directionBytes.length];
        for (int i = 0; i < directionBytes.length; ++i) {
            directions[i] = Direction.m_122376_((int)directionBytes[i]);
        }
        return new ClientBoundRecipePipePayload(directions, availableDirections, pos, blockingMode);
    }

    private static class Handler
    extends SelfHandler<ClientBoundRecipePipePayload> {
        private Handler() {
        }

        @Override
        public FriendlyByteBuf encode(ClientBoundRecipePipePayload payload, FriendlyByteBuf buffer) {
            buffer.m_130087_(payload.getDirectionBytes());
            buffer.m_236828_(payload.availableDirections(), (buf, direction) -> buf.writeByte(direction.m_122411_()));
            buffer.m_130064_(payload.pos());
            buffer.writeBoolean(payload.blockingMode());
            return buffer;
        }

        @Override
        public ClientBoundRecipePipePayload decode(FriendlyByteBuf buffer) {
            byte[] directionBytes = buffer.m_130052_();
            List availableDirections = (List)buffer.m_236838_(ArrayList::new, buf -> Direction.m_122376_((int)buf.readByte()));
            BlockPos pos = buffer.m_130135_();
            boolean blockingMode = buffer.readBoolean();
            return ClientBoundRecipePipePayload.makePayload(directionBytes, availableDirections, pos, blockingMode);
        }

        @Override
        public void handle(ClientBoundRecipePipePayload payload, Player player) {
        }
    }
}

