/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.network;

import jagm.classicpipes.inventory.menu.StockingPipeMenu;
import jagm.classicpipes.network.PayloadWrapper;
import jagm.classicpipes.network.SelfHandler;
import jagm.classicpipes.util.MiscUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record ServerBoundActiveStockingPayload(boolean activeStocking) implements PayloadWrapper<ServerBoundActiveStockingPayload>
{
    public static final ResourceLocation TYPE = MiscUtil.resourceLocation("active_stocking");
    public static final Handler HANDLER = new Handler();

    @Override
    public SelfHandler<ServerBoundActiveStockingPayload> getHandler() {
        return HANDLER;
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    public static class Handler
    extends SelfHandler<ServerBoundActiveStockingPayload> {
        @Override
        public FriendlyByteBuf encode(ServerBoundActiveStockingPayload payload, FriendlyByteBuf buffer) {
            buffer.writeBoolean(payload.activeStocking());
            return buffer;
        }

        @Override
        public ServerBoundActiveStockingPayload decode(FriendlyByteBuf buffer) {
            return new ServerBoundActiveStockingPayload(buffer.readBoolean());
        }

        @Override
        public void handle(ServerBoundActiveStockingPayload payload, Player player) {
            AbstractContainerMenu abstractContainerMenu;
            if (player != null && (abstractContainerMenu = player.f_36096_) instanceof StockingPipeMenu) {
                StockingPipeMenu menu = (StockingPipeMenu)abstractContainerMenu;
                menu.setActiveStocking(payload.activeStocking());
            }
        }
    }
}

