/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.services;

import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.client.network.ForgeClientNetworkHandler;
import jagm.classicpipes.client.renderer.FluidRenderInfo;
import jagm.classicpipes.network.ForgeServerNetworkHandler;
import jagm.classicpipes.network.PayloadWrapper;
import jagm.classicpipes.network.SelfHandler;
import jagm.classicpipes.services.LoaderService;
import jagm.classicpipes.util.FluidInPipe;
import jagm.classicpipes.util.ItemInPipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.function.TriFunction;

public class ForgeService
implements LoaderService {
    @Override
    public <B extends BlockEntity> BlockEntityType<B> createBlockEntityType(BiFunction<BlockPos, BlockState, B> blockEntitySupplier, Block ... validBlocks) {
        return BlockEntityType.Builder.m_155273_(blockEntitySupplier::apply, (Block[])validBlocks).m_58966_(null);
    }

    @Override
    public <M extends AbstractContainerMenu, D> MenuType<M> createMenuType(TriFunction<Integer, Inventory, D, M> menuSupplier, SelfHandler<D> handler) {
        return IForgeMenuType.create((id, inventory, buffer) -> (AbstractContainerMenu)menuSupplier.apply((Object)id, (Object)inventory, handler.decode(buffer)));
    }

    @Override
    public <M extends AbstractContainerMenu> MenuType<M> createSimpleMenuType(BiFunction<Integer, Inventory, M> menuSupplier) {
        return new MenuType(menuSupplier::apply, FeatureFlags.f_244332_);
    }

    @Override
    public <D> void openMenu(ServerPlayer player, MenuProvider menuProvider, D payload, SelfHandler<D> handler) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)menuProvider, buffer -> handler.encode(payload, (FriendlyByteBuf)buffer));
    }

    @Override
    public <T extends PayloadWrapper<T>> void sendToServer(T payload) {
        ForgeClientNetworkHandler.sendToServer(payload);
    }

    @Override
    public <T extends PayloadWrapper<T>> void sendToClient(ServerPlayer player, T payload) {
        ForgeServerNetworkHandler.sendToClient(player, payload);
    }

    @Override
    public boolean canAccessContainer(Level level, BlockPos containerPos, Direction face) {
        Optional itemHandlerOptional;
        BlockEntity blockEntity = level.m_7702_(containerPos);
        if (blockEntity instanceof ItemPipeEntity) {
            return false;
        }
        if (blockEntity != null && (itemHandlerOptional = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, face).resolve()).isPresent()) {
            return ((IItemHandler)itemHandlerOptional.get()).getSlots() > 0;
        }
        return false;
    }

    @Override
    public boolean handleItemInsertion(ItemPipeEntity pipe, ServerLevel level, BlockPos pipePos, BlockState pipeState, ItemInPipe item) {
        Optional itemHandlerOptional;
        BlockPos containerPos = pipePos.m_121945_(item.getTargetDirection());
        BlockEntity blockEntity = level.m_7702_(containerPos);
        if (blockEntity instanceof ItemPipeEntity) {
            ItemPipeEntity nextPipe = (ItemPipeEntity)blockEntity;
            item.resetProgress(item.getTargetDirection().m_122424_());
            nextPipe.insertPipeItem((Level)level, item);
            level.m_7260_(containerPos, nextPipe.m_58900_(), nextPipe.m_58900_(), 2);
            return true;
        }
        Direction face = item.getTargetDirection().m_122424_();
        if (blockEntity != null && (itemHandlerOptional = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, face).resolve()).isPresent()) {
            IItemHandler itemHandler = (IItemHandler)itemHandlerOptional.get();
            ItemStack stack = item.getStack();
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                if (!(stack = itemHandler.insertItem(slot, stack, false)).m_41619_()) continue;
                return true;
            }
            item.setStack(stack);
        }
        item.resetProgress(item.getTargetDirection());
        pipe.routeItem(pipeState, item);
        return false;
    }

    @Override
    public boolean handleItemExtraction(ItemPipeEntity pipe, BlockState pipeState, ServerLevel level, BlockPos containerPos, Direction face, int amount, Predicate<ItemStack> predicate) {
        Optional itemHandlerOptional;
        BlockEntity blockEntity = level.m_7702_(containerPos);
        if (blockEntity instanceof ItemPipeEntity) {
            return false;
        }
        if (blockEntity != null && (itemHandlerOptional = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, face).resolve()).isPresent()) {
            IItemHandler itemHandler = (IItemHandler)itemHandlerOptional.get();
            for (int slot = itemHandler.getSlots() - 1; slot >= 0; --slot) {
                ItemStack stack;
                if (!predicate.test(itemHandler.getStackInSlot(slot)) || (stack = itemHandler.extractItem(slot, amount, false)).m_41619_()) continue;
                pipe.setItem(face.m_122424_(), stack);
                return true;
            }
        }
        return false;
    }

    @Override
    public List<ItemStack> getContainerItems(ServerLevel level, BlockPos pos, Direction face) {
        Optional itemHandlerOptional;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null && (itemHandlerOptional = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, face).resolve()).isPresent()) {
            IItemHandler itemHandler = (IItemHandler)itemHandlerOptional.get();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack slotStack = itemHandler.getStackInSlot(slot);
                if (slotStack.m_41619_()) continue;
                boolean matched = false;
                for (ItemStack stack : stacks) {
                    if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)slotStack)) continue;
                    stack.m_41764_(stack.m_41613_() + slotStack.m_41613_());
                    matched = true;
                    break;
                }
                if (matched) continue;
                stacks.add(slotStack.m_41777_());
            }
            return stacks;
        }
        return List.of();
    }

    @Override
    public boolean extractSpecificItem(ItemPipeEntity pipe, ServerLevel level, BlockPos containerPos, Direction face, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(containerPos);
        if (blockEntity != null) {
            ItemStack target = stack.m_41777_();
            Optional itemHandlerOptional = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, face).resolve();
            if (itemHandlerOptional.isPresent()) {
                IItemHandler itemHandler = (IItemHandler)itemHandlerOptional.get();
                for (int slot = itemHandler.getSlots() - 1; slot >= 0; --slot) {
                    ItemStack extracted;
                    if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemHandler.getStackInSlot(slot)) || (extracted = itemHandler.extractItem(slot, target.m_41613_(), false)).m_41619_()) continue;
                    target.m_41774_(extracted.m_41613_());
                    pipe.setItem(face.m_122424_(), extracted);
                    if (!target.m_41619_()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getModName(String modId) {
        return ModList.get().getModContainerById(modId).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(modId);
    }

    @Override
    public boolean handleFluidInsertion(FluidPipeEntity pipe, ServerLevel level, BlockPos pipePos, BlockState pipeState, BlockEntity containerEntity, BlockPos containerPos, Fluid fluid, FluidInPipe fluidPacket) {
        Direction face = fluidPacket.getTargetDirection().m_122424_();
        Optional fluidHandlerOptional = containerEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, face).resolve();
        if (fluidHandlerOptional.isPresent()) {
            IFluidHandler fluidHandler = (IFluidHandler)fluidHandlerOptional.get();
            int amountFilled = fluidHandler.fill(new FluidStack(fluid, fluidPacket.getAmount()), IFluidHandler.FluidAction.EXECUTE);
            if (amountFilled >= fluidPacket.getAmount()) {
                return true;
            }
            fluidPacket.setAmount(fluidPacket.getAmount() - amountFilled);
        }
        return false;
    }

    @Override
    public boolean canAccessFluidContainer(Level level, BlockPos containerPos, Direction face) {
        Optional fluidHandlerOptional;
        BlockEntity blockEntity = level.m_7702_(containerPos);
        if (blockEntity instanceof FluidPipeEntity) {
            return false;
        }
        if (blockEntity != null && (fluidHandlerOptional = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, face).resolve()).isPresent()) {
            IFluidHandler fluidHandler = (IFluidHandler)fluidHandlerOptional.get();
            return fluidHandler.getTanks() > 0;
        }
        return false;
    }

    @Override
    public boolean handleFluidExtraction(FluidPipeEntity pipe, BlockState pipeState, ServerLevel level, BlockPos containerPos, Direction face, int amount, Predicate<Fluid> predicate) {
        Optional fluidHandlerOptional;
        BlockEntity blockEntity = level.m_7702_(containerPos);
        if (blockEntity instanceof FluidPipeEntity || pipe.totalAmount() >= 1000) {
            return false;
        }
        if (blockEntity != null && (fluidHandlerOptional = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, face).resolve()).isPresent()) {
            Fluid fluid;
            IFluidHandler fluidHandler = (IFluidHandler)fluidHandlerOptional.get();
            int amountToDrain = Math.min(amount, pipe.remainingCapacity());
            Fluid fluid2 = fluid = pipe.isEmpty() ? fluidHandler.drain(amountToDrain, IFluidHandler.FluidAction.SIMULATE).getFluid() : pipe.getFluid();
            if (predicate.test(fluid)) {
                FluidStack drainedStack;
                FluidStack fluidStack = drainedStack = pipe.isEmpty() ? fluidHandler.drain(amountToDrain, IFluidHandler.FluidAction.EXECUTE) : fluidHandler.drain(new FluidStack(pipe.getFluid(), amountToDrain), IFluidHandler.FluidAction.EXECUTE);
                if (!drainedStack.isEmpty()) {
                    pipe.setFluid(drainedStack.getFluid());
                    pipe.insertFluidPacket((Level)level, new FluidInPipe(drainedStack.getAmount(), pipe.getTargetSpeed(), 0, face.m_122424_(), face.m_122424_(), 0));
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public FluidRenderInfo getFluidRenderInfo(FluidState fluidState, BlockAndTintGetter level, BlockPos pos) {
        IClientFluidTypeExtensions fluidInfo = IClientFluidTypeExtensions.of((FluidState)fluidState);
        int tint = fluidInfo.getTintColor(fluidState, level, pos);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidInfo.getStillTexture(fluidState, level, pos));
        return new FluidRenderInfo(tint, sprite);
    }

    @Override
    public FluidRenderInfo getFluidRenderInfo(FluidState fluidState) {
        IClientFluidTypeExtensions fluidInfo = IClientFluidTypeExtensions.of((FluidState)fluidState);
        int tint = fluidInfo.getTintColor();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidInfo.getStillTexture());
        return new FluidRenderInfo(tint, sprite);
    }

    @Override
    public Fluid getFluidFromStack(ItemStack stack) {
        Fluid fluid = null;
        Optional fluidHandlerOptional = stack.getCapability(ForgeCapabilities.FLUID_HANDLER).resolve();
        if (fluidHandlerOptional.isPresent()) {
            fluid = ((IFluidHandler)fluidHandlerOptional.get()).getFluidInTank(0).getFluid();
        } else {
            Item item = stack.m_41720_();
            if (item instanceof BucketItem) {
                BucketItem bucket = (BucketItem)item;
                fluid = bucket.getFluid();
            }
        }
        return fluid != null && fluid.m_6212_(Fluids.f_76191_) ? null : fluid;
    }

    @Override
    public Component getFluidName(Fluid fluid) {
        return fluid.getFluidType().getDescription();
    }

    @Override
    public DispenseItemBehavior getDispenserBehaviour(ItemStack stack) {
        return (DispenseItemBehavior)DispenserBlock.f_52661_.get(stack.m_41720_());
    }
}

