/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.MatchingPipe;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.blockentity.ProviderPipe;
import jagm.classicpipes.blockentity.RecipePipeEntity;
import jagm.classicpipes.blockentity.RoutingPipeEntity;
import jagm.classicpipes.blockentity.StockingPipeEntity;
import jagm.classicpipes.inventory.menu.RequestMenu;
import jagm.classicpipes.network.ClientBoundItemListPayload;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.RequestState;
import jagm.classicpipes.util.RequestedItem;
import jagm.classicpipes.util.SortingMode;
import jagm.classicpipes.util.Tuple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class PipeNetwork {
    private static final byte DEFAULT_COOLDOWN = 40;
    private final BlockPos pos;
    private final Set<RoutingPipeEntity> routingPipes = new HashSet<RoutingPipeEntity>();
    private final Set<NetworkedPipeEntity> defaultRoutes = new HashSet<NetworkedPipeEntity>();
    private final Set<ProviderPipe> providerPipes = new LinkedHashSet<ProviderPipe>();
    private final Set<StockingPipeEntity> stockingPipes = new HashSet<StockingPipeEntity>();
    private final Set<MatchingPipe> matchingPipes = new HashSet<MatchingPipe>();
    private final Set<RecipePipeEntity> recipePipes = new HashSet<RecipePipeEntity>();
    private SortingMode sortingMode;
    private boolean cacheChanged;
    private byte cacheCooldown;
    private final List<RequestedItem> requestedItems;

    public PipeNetwork(BlockPos pos, SortingMode sortingMode) {
        this.sortingMode = sortingMode;
        this.pos = pos;
        this.cacheChanged = false;
        this.cacheCooldown = 0;
        this.requestedItems = new ArrayList<RequestedItem>();
    }

    public PipeNetwork(BlockPos pos) {
        this(pos, SortingMode.AMOUNT_DESCENDING);
    }

    private Tuple<Integer, Boolean> amountCraftable(ItemStack stack, int requiredAmount, BlockPos requestPos, RequestState requestState, List<ItemStack> itemsInThisBranch) {
        int amount = 0;
        boolean hasRecipe = false;
        int missingStacksSize = requestState.missingStacksSize();
        for (RecipePipeEntity recipePipe : this.recipePipes) {
            Object ingredientStack32;
            ItemStack resultStack = recipePipe.getResult();
            if (!ItemStack.m_150942_((ItemStack)resultStack, (ItemStack)stack)) continue;
            hasRecipe = true;
            requestState.reduceMissingStacks(missingStacksSize);
            List<ItemStack> ingredients = recipePipe.getIngredientsCollated();
            int requiredCrafts = requiredAmount / resultStack.m_41613_() + (requiredAmount % resultStack.m_41613_() != 0 ? 1 : 0);
            boolean loopFound = false;
            for (ItemStack itemStack : ingredients) {
                for (ItemStack branchStack : itemsInThisBranch) {
                    if (!ItemStack.m_150942_((ItemStack)branchStack, (ItemStack)itemStack)) continue;
                    missingStacksSize = requestState.missingStacksSize();
                    requestState.addMissingStack(itemStack.m_255036_(itemStack.m_41613_() * requiredCrafts));
                    loopFound = true;
                    break;
                }
                if (!loopFound) continue;
                break;
            }
            if (loopFound) continue;
            int possibleCrafts = requiredCrafts;
            for (Object ingredientStack32 : ingredients) {
                ArrayList<ItemStack> newBranchItems = new ArrayList<ItemStack>(itemsInThisBranch);
                newBranchItems.add((ItemStack)ingredientStack32);
                RequestState backupState = requestState.copy();
                int requiredIngredientAmount = ingredientStack32.m_41613_() * requiredCrafts;
                int ingredientAmount = this.availableAmount(ingredientStack32.m_255036_(requiredIngredientAmount), recipePipe.m_58899_(), requestState, newBranchItems);
                possibleCrafts = Math.min(possibleCrafts, ingredientAmount / ingredientStack32.m_41613_());
                requestState.restore(backupState);
            }
            if (possibleCrafts <= 0) continue;
            int n = requestState.missingStacksSize();
            ingredientStack32 = ingredients.iterator();
            while (ingredientStack32.hasNext()) {
                ItemStack ingredientStack4 = (ItemStack)ingredientStack32.next();
                ArrayList<ItemStack> newBranchItems = new ArrayList<ItemStack>(itemsInThisBranch);
                newBranchItems.add(ingredientStack4);
                int possibleIngredientAmount = ingredientStack4.m_41613_() * possibleCrafts;
                this.availableAmount(ingredientStack4.m_255036_(possibleIngredientAmount), recipePipe.m_58899_(), requestState, newBranchItems);
            }
            requestState.reduceMissingStacks(n);
            int amountToDeliver = Math.min(resultStack.m_41613_() * possibleCrafts, requiredAmount);
            amount += amountToDeliver;
            requestState.scheduleItemRouting(requestPos, resultStack.m_255036_(amountToDeliver));
            missingStacksSize = requestState.missingStacksSize();
            requestState.addCraftedItem(resultStack);
            if ((requiredAmount -= resultStack.m_41613_() * possibleCrafts) > 0) continue;
            if (requiredAmount >= 0) break;
            requestState.addSpareStack(stack.m_255036_(-requiredAmount));
            break;
        }
        return new Tuple<Integer, Boolean>(amount, hasRecipe);
    }

    private int amountInNetwork(ItemStack stack, BlockPos requestPos, RequestState requestState) {
        int amount = 0;
        for (ItemStack spareStack : requestState.getSpareStacks()) {
            if (!ItemStack.m_150942_((ItemStack)spareStack, (ItemStack)stack)) continue;
            int spareAmount = Math.min(spareStack.m_41613_(), stack.m_41613_());
            if (spareAmount <= 0) break;
            amount += spareAmount;
            spareStack.m_41774_(spareAmount);
            requestState.scheduleItemRouting(requestPos, stack.m_255036_(spareAmount));
            break;
        }
        requestState.getSpareStacks().removeIf(ItemStack::m_41619_);
        if (amount < stack.m_41613_()) {
            for (ProviderPipe providerPipe : this.providerPipes) {
                for (ItemStack cacheStack : providerPipe.getCache()) {
                    if (!ItemStack.m_150942_((ItemStack)cacheStack, (ItemStack)stack)) continue;
                    int amountProvidable = Math.min(stack.m_41613_() - amount, cacheStack.m_41613_() - requestState.amountAlreadyWithdrawing(providerPipe, stack));
                    if (amountProvidable <= 0) break;
                    amount += amountProvidable;
                    requestState.scheduleItemWithdrawal(providerPipe, stack.m_255036_(amountProvidable));
                    requestState.scheduleItemRouting(requestPos, stack.m_255036_(amountProvidable));
                    break;
                }
                if (amount < stack.m_41613_()) continue;
                break;
            }
        }
        return amount;
    }

    private int availableAmount(ItemStack stack, BlockPos requestPos, RequestState requestState, List<ItemStack> itemsInThisBranch) {
        int amount = this.amountInNetwork(stack, requestPos, requestState);
        if (amount < stack.m_41613_()) {
            Tuple<Integer, Boolean> tuple = this.amountCraftable(stack, stack.m_41613_() - amount, requestPos, requestState, itemsInThisBranch);
            amount += tuple.a().intValue();
            if (!tuple.b().booleanValue()) {
                requestState.addMissingStack(stack.m_255036_(stack.m_41613_() - amount));
            }
        }
        return amount;
    }

    public void request(ServerLevel level, ItemStack stack, BlockPos requestPos, Player player, boolean partialRequests) {
        RequestState requestState = new RequestState();
        int amount = this.availableAmount(stack, requestPos, requestState, new ArrayList<ItemStack>());
        if (amount < stack.m_41613_()) {
            if (partialRequests) {
                this.request(level, stack.m_255036_(amount), requestPos, player, false);
            } else if (player != null) {
                player.m_5661_((Component)Component.m_237110_((String)"chat.classicpipes.missing_item.a", (Object[])new Object[]{stack.m_41613_(), stack.m_41720_().m_41466_()}).m_130940_(ChatFormatting.RED), false);
                for (ItemStack missingStack : requestState.collateMissingStacks()) {
                    player.m_5661_((Component)Component.m_237110_((String)"chat.classicpipes.missing_item.b", (Object[])new Object[]{missingStack.m_41613_(), missingStack.m_41720_().m_41466_()}).m_130940_(ChatFormatting.YELLOW), false);
                }
            }
        } else {
            String playerName = player != null ? player.m_7755_().getString() : "";
            int requestedItemsSize = this.requestedItems.size();
            for (Map.Entry<BlockPos, List<ItemStack>> entry : requestState.getItemsToRoute().entrySet()) {
                for (ItemStack routeStack : entry.getValue()) {
                    this.requestedItems.add(new RequestedItem(routeStack, entry.getKey(), playerName));
                }
            }
            boolean success = true;
            for (Map.Entry<ProviderPipe, List<ItemStack>> entry : requestState.getItemsToWithdraw().entrySet()) {
                for (ItemStack withdrawStack : entry.getValue()) {
                    boolean withdrawalSuccessful = false;
                    for (ItemStack cacheStack : entry.getKey().getCache()) {
                        if (!ItemStack.m_150942_((ItemStack)cacheStack, (ItemStack)withdrawStack)) continue;
                        int amountToExtract = Math.min(cacheStack.m_41613_(), withdrawStack.m_41613_());
                        withdrawalSuccessful = entry.getKey().extractItem(level, cacheStack.m_255036_(amountToExtract));
                        break;
                    }
                    if (withdrawalSuccessful) continue;
                    success = false;
                    while (this.requestedItems.size() > requestedItemsSize) {
                        this.requestedItems.remove(this.requestedItems.size() - 1);
                    }
                    if (player == null) break;
                    player.m_5661_((Component)Component.m_237110_((String)"chat.classicpipes.could_not_extract", (Object[])new Object[]{stack.m_41613_(), stack.m_41720_().m_41466_(), entry.getKey().getProviderPipePos().m_123344_()}).m_130940_(ChatFormatting.RED), false);
                    break;
                }
                if (success) continue;
                break;
            }
            if (success && player != null) {
                player.m_36222_(ClassicPipes.ITEMS_REQUESTED_STAT, stack.m_41613_());
                ClassicPipes.REQUEST_ITEM_TRIGGER.trigger((ServerPlayer)player, stack, requestState.getUniqueCrafts());
                player.m_5661_((Component)Component.m_237110_((String)"chat.classicpipes.requested", (Object[])new Object[]{stack.m_41613_(), stack.m_41720_().m_41466_()}).m_130940_(ChatFormatting.GREEN), false);
            }
        }
    }

    public void tick(ServerLevel level) {
        int updatablePipesCount = this.providerPipes.size() + this.matchingPipes.size() + this.stockingPipes.size();
        int pipeToUpdate = level.m_213780_().m_188503_(Math.max(100, updatablePipesCount));
        if (pipeToUpdate < this.providerPipes.size()) {
            i = 0;
            for (ProviderPipe providerPipe : this.providerPipes) {
                if (i == pipeToUpdate) {
                    Direction facing = providerPipe.getFacing();
                    if (facing == null) break;
                    providerPipe.updateCache();
                    break;
                }
                ++i;
            }
        } else if (pipeToUpdate < this.providerPipes.size() + this.matchingPipes.size()) {
            i = 0;
            for (MatchingPipe matchingPipe : this.matchingPipes) {
                if (i == pipeToUpdate) {
                    matchingPipe.updateCache();
                    break;
                }
                ++i;
            }
        } else if (pipeToUpdate < updatablePipesCount) {
            i = 0;
            for (Object stockingPipe : this.stockingPipes) {
                if (i == pipeToUpdate) {
                    stockingPipe.updateCache();
                    break;
                }
                ++i;
            }
        }
        if (this.cacheChanged && this.cacheCooldown <= 0) {
            List playerList = level.m_8795_(player -> {
                RequestMenu menu;
                AbstractContainerMenu patt14801$temp = player.f_36096_;
                return patt14801$temp instanceof RequestMenu && (menu = (RequestMenu)patt14801$temp).getNetworkPos().equals((Object)this.getPos());
            });
            if (!playerList.isEmpty()) {
                ClientBoundItemListPayload toSend = this.requestItemList(this.pos);
                for (ServerPlayer player2 : playerList) {
                    Services.LOADER_SERVICE.sendToClient(player2, toSend);
                }
            }
            for (Object stockingPipe : this.stockingPipes) {
                if (!stockingPipe.isActiveStocking()) continue;
                stockingPipe.tryRequests(level);
            }
            this.cacheChanged = false;
            this.cacheCooldown = (byte)40;
        } else if (this.cacheCooldown > 0) {
            this.cacheCooldown = (byte)(this.cacheCooldown - 1);
        }
        this.getRequestedItems().removeIf(requestedItem -> {
            if (requestedItem.timedOut()) {
                requestedItem.sendMessage(level, (Component)Component.m_237110_((String)"chat.classicpipes.timed_out", (Object[])new Object[]{requestedItem.getAmountRemaining(), requestedItem.getStack().m_41720_().m_41466_()}).m_130940_(ChatFormatting.RED));
                for (RecipePipeEntity craftingPipe : this.recipePipes) {
                    if (!requestedItem.matches(craftingPipe.getResult())) continue;
                    craftingPipe.dropHeldItems(level, craftingPipe.m_58899_());
                }
                return true;
            }
            return false;
        });
    }

    public void resetRequests(ServerLevel level) {
        this.requestedItems.clear();
        for (RecipePipeEntity craftingPipe : this.recipePipes) {
            craftingPipe.dropHeldItems(level, craftingPipe.m_58899_());
        }
    }

    public Set<RoutingPipeEntity> getRoutingPipes() {
        return this.routingPipes;
    }

    public Set<NetworkedPipeEntity> getDefaultRoutes() {
        return this.defaultRoutes;
    }

    public Set<StockingPipeEntity> getStockingPipes() {
        return this.stockingPipes;
    }

    public Set<MatchingPipe> getMatchingPipes() {
        return this.matchingPipes;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void addPipe(NetworkedPipeEntity pipe) {
        if (pipe.isDefaultRoute()) {
            this.defaultRoutes.add(pipe);
        }
        if (pipe instanceof RoutingPipeEntity) {
            RoutingPipeEntity routingPipe = (RoutingPipeEntity)pipe;
            this.routingPipes.add(routingPipe);
        }
        if (pipe instanceof ProviderPipe) {
            ProviderPipe providerPipe = (ProviderPipe)((Object)pipe);
            this.providerPipes.add(providerPipe);
        }
        if (pipe instanceof StockingPipeEntity) {
            StockingPipeEntity stockingPipe = (StockingPipeEntity)pipe;
            this.stockingPipes.add(stockingPipe);
        }
        if (pipe instanceof MatchingPipe) {
            MatchingPipe matchingPipe = (MatchingPipe)((Object)pipe);
            this.matchingPipes.add(matchingPipe);
        }
        if (pipe instanceof RecipePipeEntity) {
            RecipePipeEntity recipePipe = (RecipePipeEntity)pipe;
            this.recipePipes.add(recipePipe);
        }
    }

    public void removePipe(ServerLevel level, NetworkedPipeEntity pipe) {
        if (pipe.isDefaultRoute()) {
            this.defaultRoutes.remove((Object)pipe);
        }
        if (pipe instanceof RoutingPipeEntity) {
            RoutingPipeEntity routingPipe = (RoutingPipeEntity)pipe;
            this.routingPipes.remove((Object)routingPipe);
        }
        if (pipe instanceof ProviderPipe) {
            ProviderPipe providerPipe = (ProviderPipe)((Object)pipe);
            this.providerPipes.remove(providerPipe);
        }
        if (pipe instanceof StockingPipeEntity) {
            StockingPipeEntity stockingPipe = (StockingPipeEntity)pipe;
            this.stockingPipes.remove((Object)stockingPipe);
        }
        if (pipe instanceof MatchingPipe) {
            MatchingPipe matchingPipe = (MatchingPipe)((Object)pipe);
            this.matchingPipes.remove(matchingPipe);
        }
        if (pipe instanceof RecipePipeEntity) {
            RecipePipeEntity recipePipe = (RecipePipeEntity)pipe;
            this.recipePipes.remove((Object)recipePipe);
        }
        this.requestedItems.removeIf(requestedItem -> {
            if (requestedItem.getDestination().equals((Object)pipe.m_58899_())) {
                requestedItem.sendMessage(level, (Component)Component.m_237110_((String)"chat.classicpipes.destination_removed", (Object[])new Object[]{requestedItem.getAmountRemaining(), requestedItem.getStack().m_41720_().m_41466_(), pipe.m_58899_().m_123344_()}).m_130940_(ChatFormatting.RED));
                return true;
            }
            return false;
        });
    }

    public ClientBoundItemListPayload requestItemList(BlockPos requestPos) {
        ArrayList<ItemStack> existingItems = new ArrayList<ItemStack>();
        for (ProviderPipe providerPipe : this.providerPipes) {
            for (ItemStack stack : providerPipe.getCache()) {
                boolean alreadyThere = false;
                for (ItemStack inStack : existingItems) {
                    if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)inStack)) continue;
                    inStack.m_41769_(stack.m_41613_());
                    if (inStack.m_41613_() < 0) {
                        inStack.m_41764_(Integer.MAX_VALUE);
                    }
                    alreadyThere = true;
                    break;
                }
                if (alreadyThere) continue;
                existingItems.add(stack.m_41777_());
            }
        }
        ArrayList<ItemStack> craftableItems = new ArrayList<ItemStack>();
        for (RecipePipeEntity recipePipe : this.recipePipes) {
            ItemStack result = recipePipe.getResult();
            if (result.m_41619_()) continue;
            boolean matched = false;
            for (ItemStack alreadyCraftable : craftableItems) {
                if (!ItemStack.m_150942_((ItemStack)alreadyCraftable, (ItemStack)result)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            craftableItems.add(result.m_255036_(1));
        }
        return new ClientBoundItemListPayload(existingItems, craftableItems, this.pos, requestPos, this.sortingMode);
    }

    public void cacheUpdated() {
        this.cacheChanged = true;
    }

    public void setSortingMode(SortingMode sortingMode) {
        this.sortingMode = sortingMode;
    }

    public SortingMode getSortingMode() {
        return this.sortingMode;
    }

    public List<RequestedItem> getRequestedItems() {
        return this.requestedItems;
    }

    public void removeRequestedItem(RequestedItem requestedItem) {
        this.requestedItems.remove(requestedItem);
    }

    public void addRequestedItem(RequestedItem requestedItem) {
        this.requestedItems.add(requestedItem);
    }
}

