/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FluidInPipe;
import jagm.classicpipes.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;

public class FluidPipeEntity
extends PipeEntity {
    public static final int CAPACITY = 1000;
    public static final int MIN_PACKET_SIZE = 20;
    protected class_3611 fluid;
    protected final List<FluidInPipe> contents = new ArrayList<FluidInPipe>();
    protected final List<FluidInPipe> queued = new ArrayList<FluidInPipe>();
    private final Map<FluidInPipe, Long> tickAdded = new HashMap<FluidInPipe, Long>();

    public FluidPipeEntity(class_2338 pos, class_2680 state) {
        this(ClassicPipes.FLUID_PIPE_ENTITY, pos, state);
    }

    public FluidPipeEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.fluid = class_3612.field_15910;
    }

    @Override
    public void tickServer(class_3218 level, class_2338 pos, class_2680 state) {
        boolean sendBlockUpdate = false;
        if (!this.contents.isEmpty()) {
            ListIterator<FluidInPipe> iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                FluidInPipe fluidPacket = iterator.next();
                if (this.tickAdded.containsKey(fluidPacket)) {
                    if (this.tickAdded.get(fluidPacket).longValue() == level.method_8510()) continue;
                    this.tickAdded.remove(fluidPacket);
                }
                fluidPacket.move(this.getTargetSpeed(), this.getAcceleration());
                if (fluidPacket.getAge() > 24000) {
                    iterator.remove();
                    sendBlockUpdate = true;
                    continue;
                }
                if (fluidPacket.getProgress() < 2048) continue;
                boolean remove = false;
                class_2338 containerPos = pos.method_10093(fluidPacket.getTargetDirection());
                class_2586 blockEntity = level.method_8321(containerPos);
                if (blockEntity instanceof FluidPipeEntity) {
                    FluidPipeEntity nextPipe = (FluidPipeEntity)blockEntity;
                    if (nextPipe.emptyOrMatches(this.fluid)) {
                        nextPipe.setFluid(this.fluid);
                        remove = true;
                        int amountToPass = Math.min(fluidPacket.getAmount(), nextPipe.remainingCapacity());
                        if (amountToPass == fluidPacket.getAmount()) {
                            fluidPacket.resetProgress(fluidPacket.getTargetDirection().method_10153());
                            nextPipe.insertFluidPacket((class_1937)level, fluidPacket);
                        } else {
                            remove = false;
                            if (amountToPass >= 20) {
                                FluidInPipe newPacket = fluidPacket.copyWithAmount(amountToPass);
                                newPacket.resetProgress(fluidPacket.getTargetDirection().method_10153());
                                nextPipe.insertFluidPacket((class_1937)level, newPacket);
                                fluidPacket.setAmount(fluidPacket.getAmount() - amountToPass);
                            }
                        }
                        level.method_8413(containerPos, nextPipe.method_11010(), nextPipe.method_11010(), 2);
                    }
                } else if (blockEntity != null) {
                    remove = Services.LOADER_SERVICE.handleFluidInsertion(this, level, pos, state, blockEntity, containerPos, this.fluid, fluidPacket);
                }
                if (remove) {
                    iterator.remove();
                } else {
                    fluidPacket.resetProgress(fluidPacket.getTargetDirection());
                    this.routePacket(state, fluidPacket);
                }
                sendBlockUpdate = true;
            }
            this.addQueuedPackets((class_1937)level, false);
        }
        if (sendBlockUpdate) {
            level.method_8413(pos, state, state, 2);
        }
    }

    @Override
    public void tickClient(class_1937 level, class_2338 pos) {
        if (!this.contents.isEmpty()) {
            ListIterator<FluidInPipe> iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                FluidPipeEntity nextPipe;
                class_2338 nextPos;
                class_2586 class_25862;
                FluidInPipe fluidPacket = iterator.next();
                if (this.tickAdded.containsKey(fluidPacket)) {
                    if (this.tickAdded.get(fluidPacket).longValue() == level.method_8510()) continue;
                    this.tickAdded.remove(fluidPacket);
                }
                fluidPacket.move(this.getTargetSpeed(), this.getAcceleration());
                if (fluidPacket.getProgress() < 2048 || !((class_25862 = level.method_8321(nextPos = pos.method_10093(fluidPacket.getTargetDirection()))) instanceof FluidPipeEntity) || !(nextPipe = (FluidPipeEntity)class_25862).emptyOrMatches(this.fluid)) continue;
                fluidPacket.resetProgress(fluidPacket.getTargetDirection().method_10153());
                nextPipe.setFluid(this.fluid);
                nextPipe.insertFluidPacket(level, fluidPacket);
                iterator.remove();
            }
        }
    }

    @Override
    public void update(class_3218 level, class_2680 state, class_2338 pos, class_2350 direction, boolean wasConnected) {
        if (!this.contents.isEmpty()) {
            ListIterator<FluidInPipe> iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                FluidInPipe fluidPacket = iterator.next();
                if (!wasConnected || fluidPacket.getTargetDirection() == direction && fluidPacket.getFromDirection() != direction && fluidPacket.getProgress() < 1024) {
                    this.routePacket(state, fluidPacket);
                    continue;
                }
                if ((fluidPacket.getFromDirection() != direction || fluidPacket.getProgress() >= 1024) && (fluidPacket.getTargetDirection() != direction || fluidPacket.getProgress() < 1024)) continue;
                iterator.remove();
            }
            this.addQueuedPackets((class_1937)level, false);
        }
        this.method_5431();
        level.method_8413(pos, state, state, 2);
    }

    @Override
    public int getComparatorOutput() {
        if (this.contents.isEmpty()) {
            return 0;
        }
        return Math.max(1, Math.round(15.0f * (float)this.totalAmount() / 1000.0f));
    }

    @Override
    public short getTargetSpeed() {
        class_3610 fluidState = this.fluid.method_15785();
        if (fluidState.method_15767(ClassicPipes.THIN_FLUIDS)) {
            return 256;
        }
        if (fluidState.method_15767(ClassicPipes.THICK_FLUIDS) && this.field_11863 != null && !this.field_11863.method_8597().comp_644()) {
            return 64;
        }
        return 128;
    }

    @Override
    public short getAcceleration() {
        return 1;
    }

    protected void method_11014(class_11368 valueInput) {
        this.contents.clear();
        this.tickAdded.clear();
        super.method_11014(valueInput);
        class_11368.class_11369 fluidPacketList = valueInput.method_71437("fluid_packets", FluidInPipe.CODEC);
        fluidPacketList.forEach(this.contents::add);
        this.setFluid((class_3611)valueInput.method_71426("fluid", class_7923.field_41173.method_39673()).orElse(class_3612.field_15910));
    }

    protected void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        class_11372.class_11373 fluidPacketList = valueOutput.method_71467("fluid_packets", FluidInPipe.CODEC);
        for (FluidInPipe fluidPacket : this.contents) {
            if (fluidPacket.getAmount() <= 0) continue;
            fluidPacketList.method_71484((Object)fluidPacket);
        }
        valueOutput.method_71468("fluid", class_7923.field_41173.method_39673(), (Object)this.fluid);
    }

    public void addQueuedPackets(class_1937 level, boolean waitForNextTick) {
        for (FluidInPipe fluidPacket : this.queued) {
            this.contents.add(fluidPacket);
            if (!waitForNextTick) continue;
            this.tickAdded.put(fluidPacket, level.method_8510());
        }
        this.method_5431();
        this.queued.clear();
    }

    public boolean emptyOrMatches(class_3611 fluid) {
        return this.contents.isEmpty() || this.fluid == fluid;
    }

    public int totalAmount() {
        int total = 0;
        for (FluidInPipe fluidPacket : this.contents) {
            total += fluidPacket.getAmount();
        }
        return total;
    }

    public int remainingCapacity() {
        return 1000 - this.totalAmount();
    }

    public void setFluid(class_3611 fluid) {
        this.fluid = fluid;
    }

    public void insertFluidPacket(class_1937 level, FluidInPipe fluidPacket) {
        this.queued.add(fluidPacket);
        this.routePacket(fluidPacket);
        this.addQueuedPackets(level, true);
    }

    protected List<class_2350> getValidDirections(class_2680 state, FluidInPipe fluidPacket) {
        ArrayList<class_2350> validDirections = new ArrayList<class_2350>();
        class_2350 direction = MiscUtil.nextDirection(fluidPacket.getFromDirection());
        for (int i = 0; i < 5; ++i) {
            if (this.isPipeConnected(state, direction)) {
                validDirections.add(direction);
            }
            direction = MiscUtil.nextDirection(direction);
        }
        return validDirections;
    }

    public void routePacket(class_2680 state, FluidInPipe fluidPacket) {
        List<class_2350> validDirections = this.getValidDirections(state, fluidPacket);
        int numDirections = validDirections.size();
        if (numDirections == 0) {
            fluidPacket.setTargetDirection(fluidPacket.getFromDirection());
        } else if (numDirections == 1) {
            fluidPacket.setTargetDirection(validDirections.getFirst());
        } else if (fluidPacket.getAmount() > 20) {
            int splitAmount = fluidPacket.getAmount() / numDirections;
            int leftoverAmount = fluidPacket.getAmount() % numDirections;
            Collections.shuffle(validDirections);
            for (int i = 0; i < numDirections; ++i) {
                if (i == 0) {
                    fluidPacket.setAmount(splitAmount + leftoverAmount);
                    fluidPacket.setTargetDirection(validDirections.get(i));
                    continue;
                }
                FluidInPipe newPacket = fluidPacket.copyWithAmount(splitAmount);
                newPacket.setTargetDirection(validDirections.get(i));
                this.queued.add(newPacket);
            }
        } else if (this.method_10997() != null) {
            fluidPacket.setTargetDirection(validDirections.get(this.method_10997().method_8409().method_43048(validDirections.size())));
        }
    }

    public void routePacket(FluidInPipe fluidPacket) {
        this.routePacket(this.method_11010(), fluidPacket);
    }

    public class_3611 getFluid() {
        return this.fluid;
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public List<FluidInPipe> getContents() {
        return this.contents;
    }
}

