/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.NetworkedPipeBlock;
import jagm.classicpipes.blockentity.MatchingPipe;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;

public abstract class ItemPipeEntity
extends PipeEntity {
    protected final List<ItemInPipe> contents = new ArrayList<ItemInPipe>();
    protected final List<ItemInPipe> queued = new ArrayList<ItemInPipe>();
    public final Map<class_2350, Tuple<class_2338, Integer>> networkDistances = new HashMap<class_2350, Tuple<class_2338, Integer>>();
    private boolean networkingInitialised = false;
    private final Map<ItemInPipe, Long> tickAdded = new HashMap<ItemInPipe, Long>();

    public ItemPipeEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void tickServer(class_3218 level, class_2338 pos, class_2680 state) {
        boolean sendBlockUpdate = false;
        if (!this.networkingInitialised) {
            this.initialiseNetworking(level, state, pos);
            this.networkingInitialised = true;
            sendBlockUpdate = true;
        }
        if (!this.isEmpty()) {
            ListIterator<ItemInPipe> iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                ItemInPipe item = iterator.next();
                if (this.tickAdded.containsKey(item)) {
                    if (this.tickAdded.get(item).longValue() == level.method_8510()) continue;
                    this.tickAdded.remove(item);
                }
                item.move(this.getTargetSpeed(), this.getAcceleration());
                if (item.getAge() > 24000) {
                    iterator.remove();
                    sendBlockUpdate = true;
                    continue;
                }
                if (item.getProgress() >= 1024 && item.isEjecting()) {
                    iterator.remove();
                    this.eject(level, pos, item);
                    sendBlockUpdate = true;
                    continue;
                }
                if (item.getProgress() < 2048) continue;
                if (Services.LOADER_SERVICE.handleItemInsertion(this, level, pos, state, item)) {
                    iterator.remove();
                } else {
                    ItemPipeEntity itemPipeEntity = this;
                    if (itemPipeEntity instanceof MatchingPipe) {
                        MatchingPipe matchingPipe = (MatchingPipe)((Object)itemPipeEntity);
                        matchingPipe.markCannotFit(item.getStack());
                    }
                }
                sendBlockUpdate = true;
            }
            this.addQueuedItems((class_1937)level, false);
        }
        if (sendBlockUpdate) {
            level.method_8413(pos, state, state, 2);
        }
    }

    @Override
    public void tickClient(class_1937 level, class_2338 pos) {
        if (!this.isEmpty()) {
            ListIterator<ItemInPipe> iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                class_2338 nextPos;
                class_2586 class_25862;
                ItemInPipe item = iterator.next();
                if (this.tickAdded.containsKey(item)) {
                    if (this.tickAdded.get(item).longValue() == level.method_8510()) continue;
                    this.tickAdded.remove(item);
                }
                item.move(this.getTargetSpeed(), this.getAcceleration());
                if (item.getProgress() < 2048 || !((class_25862 = level.method_8321(nextPos = pos.method_10093(item.getTargetDirection()))) instanceof ItemPipeEntity)) continue;
                ItemPipeEntity nextPipe = (ItemPipeEntity)class_25862;
                item.resetProgress(item.getTargetDirection().method_10153());
                nextPipe.insertPipeItem(level, item);
                iterator.remove();
            }
        }
    }

    public void insertPipeItem(class_1937 level, ItemInPipe item) {
        this.queued.add(item);
        this.routeItem(item);
        this.addQueuedItems(level, true);
    }

    public void addQueuedItems(class_1937 level, boolean waitForNextTick) {
        for (ItemInPipe item : this.queued) {
            this.contents.add(item);
            if (!waitForNextTick) continue;
            this.tickAdded.put(item, level.method_8510());
        }
        this.method_5431();
        this.queued.clear();
    }

    public abstract void routeItem(class_2680 var1, ItemInPipe var2);

    public final void routeItem(ItemInPipe item) {
        this.routeItem(this.method_11010(), item);
    }

    protected boolean canJoinNetwork() {
        return true;
    }

    @Override
    public void update(class_3218 level, class_2680 state, class_2338 pos, class_2350 direction, boolean wasConnected) {
        if (!this.isEmpty()) {
            ListIterator<ItemInPipe> iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                ItemInPipe item = iterator.next();
                if (!wasConnected || item.getTargetDirection() == direction && item.getFromDirection() != direction && item.getProgress() < 1024) {
                    this.routeItem(state, item);
                    continue;
                }
                if ((item.getFromDirection() != direction || item.getProgress() >= 1024) && (item.getTargetDirection() != direction || item.getProgress() < 1024)) continue;
                iterator.remove();
                item.drop(level, pos);
            }
            this.addQueuedItems((class_1937)level, false);
        }
        if (wasConnected) {
            this.networkDistances.remove(direction);
        }
        boolean flaggedChange = false;
        for (class_2350 otherDirection : class_2350.values()) {
            if (this.isPipeConnected(state, otherDirection)) continue;
            this.networkDistances.remove(otherDirection);
            ItemPipeEntity itemPipeEntity = this;
            if (!(itemPipeEntity instanceof NetworkedPipeEntity)) continue;
            NetworkedPipeEntity networkedPipe = (NetworkedPipeEntity)itemPipeEntity;
            if (flaggedChange) continue;
            networkedPipe.networkChanged(level, pos, false);
            flaggedChange = true;
        }
        for (class_2350 otherDirection : class_2350.values()) {
            class_2586 class_25862;
            class_2338 nextPos = pos.method_10093(otherDirection);
            if (!this.isPipeConnected(state, otherDirection) || !((class_25862 = level.method_8321(nextPos)) instanceof ItemPipeEntity)) continue;
            ItemPipeEntity nextPipe = (ItemPipeEntity)class_25862;
            this.updateNetworking(level, state, pos, nextPipe, nextPos, otherDirection, new HashSet<Tuple<class_2338, class_2350>>(), true);
        }
        this.method_5431();
        level.method_8413(pos, state, state, 2);
    }

    protected void initialiseNetworking(class_3218 level, class_2680 state, class_2338 pos) {
        Set<Tuple<class_2338, class_2350>> visited = new HashSet<Tuple<class_2338, class_2350>>();
        for (class_2350 direction : class_2350.values()) {
            class_2586 class_25862;
            class_2338 nextPos = pos.method_10093(direction);
            if (this.isPipeConnected(state, direction) && (class_25862 = level.method_8321(nextPos)) instanceof ItemPipeEntity) {
                ItemPipeEntity nextPipe = (ItemPipeEntity)class_25862;
                visited = this.updateNetworking(level, state, pos, nextPipe, nextPos, direction, visited, false);
                continue;
            }
            this.networkDistances.remove(direction);
        }
        this.method_5431();
    }

    private Set<Tuple<class_2338, class_2350>> updateNetworking(class_3218 level, class_2680 state, class_2338 pos, ItemPipeEntity nextPipe, class_2338 nextPos, class_2350 nextDirection, Set<Tuple<class_2338, class_2350>> visited, boolean triggerNetworkChanges) {
        class_2248 wasLinked22;
        NetworkedPipeEntity networkedPipe;
        Tuple<class_2338, Integer> tuple;
        for (Tuple<class_2338, class_2350> tuple2 : visited) {
            if (!tuple2.a().equals((Object)pos) || !tuple2.b().equals((Object)nextDirection)) continue;
            return visited;
        }
        visited.add(new Tuple<class_2338, class_2350>(pos, nextDirection));
        if (this instanceof NetworkedPipeEntity && nextPipe.canJoinNetwork()) {
            nextPipe.networkDistances.put(nextDirection.method_10153(), new Tuple<class_2338, Integer>(pos, 1));
        } else {
            boolean hasNetworkConnection = false;
            if (this.countConnections(state) < 3) {
                for (class_2350 direction : this.networkDistances.keySet()) {
                    if (direction.equals((Object)nextDirection) || !nextPipe.canJoinNetwork()) continue;
                    tuple = this.networkDistances.get(direction);
                    nextPipe.networkDistances.put(nextDirection.method_10153(), new Tuple<class_2338, Integer>(tuple.a(), tuple.b() + 1));
                    hasNetworkConnection = true;
                }
            }
            if (!hasNetworkConnection) {
                nextPipe.networkDistances.remove(nextDirection.method_10153());
            }
        }
        if (nextPipe instanceof NetworkedPipeEntity && this.canJoinNetwork()) {
            this.networkDistances.put(nextDirection, new Tuple<class_2338, Integer>(nextPos, 1));
        } else {
            boolean hasNetworkConnection = false;
            if (nextPipe.countConnections(nextPipe.method_11010()) < 3) {
                for (class_2350 direction : nextPipe.networkDistances.keySet()) {
                    if (direction.equals((Object)nextDirection.method_10153()) || !this.canJoinNetwork()) continue;
                    tuple = nextPipe.networkDistances.get(direction);
                    this.networkDistances.put(nextDirection, new Tuple<class_2338, Integer>(tuple.a(), tuple.b() + 1));
                    hasNetworkConnection = true;
                }
            }
            if (!hasNetworkConnection) {
                this.networkDistances.remove(nextDirection);
            }
            for (class_2350 direction : class_2350.values()) {
                class_2586 class_25862;
                if (direction.equals((Object)nextDirection.method_10153())) continue;
                class_2338 anotherPos = nextPos.method_10093(direction);
                if (nextPipe.isPipeConnected(nextPipe.method_11010(), direction) && (class_25862 = level.method_8321(anotherPos)) instanceof ItemPipeEntity) {
                    ItemPipeEntity anotherPipe = (ItemPipeEntity)class_25862;
                    visited = nextPipe.updateNetworking(level, nextPipe.method_11010(), nextPos, anotherPipe, anotherPos, direction, visited, triggerNetworkChanges);
                    continue;
                }
                nextPipe.networkDistances.remove(direction);
            }
        }
        ItemPipeEntity direction = this;
        if (direction instanceof NetworkedPipeEntity) {
            networkedPipe = (NetworkedPipeEntity)direction;
            direction = state.method_26204();
            if (direction instanceof NetworkedPipeBlock) {
                boolean isLinked;
                NetworkedPipeBlock networkedPipeBlock = (NetworkedPipeBlock)((Object)direction);
                boolean wasLinked22 = networkedPipeBlock.isLinked(state, nextDirection);
                if (wasLinked22 != (isLinked = this.networkDistances.containsKey(nextDirection)) && triggerNetworkChanges) {
                    networkedPipe.networkChanged(level, pos, isLinked);
                }
                level.method_8652(pos, networkedPipeBlock.setLinked(state, nextDirection, isLinked), 3);
            }
        }
        if (nextPipe instanceof NetworkedPipeEntity && (wasLinked22 = (networkedPipe = (NetworkedPipeEntity)nextPipe).method_11010().method_26204()) instanceof NetworkedPipeBlock) {
            boolean isLinked;
            NetworkedPipeBlock networkedPipeBlock = (NetworkedPipeBlock)wasLinked22;
            boolean wasLinked3 = networkedPipeBlock.isLinked(networkedPipe.method_11010(), nextDirection.method_10153());
            if (wasLinked3 != (isLinked = networkedPipe.networkDistances.containsKey(nextDirection.method_10153())) && triggerNetworkChanges) {
                networkedPipe.networkChanged(level, nextPos, isLinked);
            }
            level.method_8652(nextPos, networkedPipeBlock.setLinked(networkedPipe.method_11010(), nextDirection.method_10153(), isLinked), 3);
        }
        this.method_5431();
        level.method_8413(pos, state, state, 2);
        nextPipe.method_5431();
        level.method_8413(nextPos, nextPipe.method_11010(), nextPipe.method_11010(), 2);
        return visited;
    }

    public void eject(class_3218 level, class_2338 pos, ItemInPipe item) {
        if (!item.getStack().method_7960()) {
            class_243 offset = new class_243(item.getTargetDirection() == class_2350.field_11039 ? 0.125 : (double)(item.getTargetDirection() == class_2350.field_11034 ? 0.875f : 0.5f), item.getTargetDirection() == class_2350.field_11033 ? 0.0 : (double)(item.getTargetDirection() == class_2350.field_11036 ? 0.75f : 0.375f), item.getTargetDirection() == class_2350.field_11043 ? 0.125 : (double)(item.getTargetDirection() == class_2350.field_11035 ? 0.875f : 0.5f));
            class_1542 ejectedItem = new class_1542((class_1937)level, (double)pos.method_10263() + offset.field_1352, (double)pos.method_10264() + offset.field_1351, (double)pos.method_10260() + offset.field_1350, item.getStack());
            float v = (float)item.getSpeed() / 2048.0f;
            ejectedItem.method_18800(item.getTargetDirection() == class_2350.field_11039 ? (double)(-v) : (double)(item.getTargetDirection() == class_2350.field_11034 ? v : 0.0f), item.getTargetDirection() == class_2350.field_11033 ? (double)(-v) : (double)(item.getTargetDirection() == class_2350.field_11036 ? v : 0.0f), item.getTargetDirection() == class_2350.field_11043 ? (double)(-v) : (double)(item.getTargetDirection() == class_2350.field_11035 ? v : 0.0f));
            ejectedItem.method_6988();
            level.method_8649((class_1297)ejectedItem);
            level.method_45447((class_1297)ejectedItem, pos, ClassicPipes.PIPE_EJECT_SOUND, class_3419.field_15245);
        }
    }

    public void dropItems(class_3218 serverLevel, class_2338 pos) {
        for (ItemInPipe item : this.contents) {
            item.drop(serverLevel, pos);
        }
    }

    public List<ItemInPipe> getContents() {
        return this.contents;
    }

    public void setItem(class_2350 side, class_1799 stack) {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (!stack.method_7960()) {
                ItemInPipe item = new ItemInPipe(stack, side, side.method_10153());
                this.insertPipeItem((class_1937)serverLevel, item);
                serverLevel.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
            }
        }
        this.method_5431();
    }

    protected void method_11014(class_11368 valueInput) {
        this.clearContent();
        this.networkDistances.clear();
        this.tickAdded.clear();
        super.method_11014(valueInput);
        class_11368.class_11369 itemsList = valueInput.method_71437("items", ItemInPipe.CODEC);
        itemsList.forEach(this.contents::add);
        for (class_2350 direction : class_2350.values()) {
            class_2338 pos = valueInput.method_71426(direction.method_10151() + "_pos", class_2338.field_25064).orElse(class_2338.field_10980);
            valueInput.method_71439(direction.method_10151() + "_distance").ifPresent(distance -> this.networkDistances.put(direction, new Tuple<class_2338, Integer>(pos, (Integer)distance)));
        }
    }

    protected void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        class_11372.class_11373 itemsList = valueOutput.method_71467("items", ItemInPipe.CODEC);
        for (ItemInPipe item : this.contents) {
            if (item.getStack().method_7960()) continue;
            itemsList.method_71484((Object)item);
        }
        for (class_2350 direction : this.networkDistances.keySet()) {
            Tuple<class_2338, Integer> tuple = this.networkDistances.get(direction);
            valueOutput.method_71468(direction.method_10151() + "_pos", class_2338.field_25064, (Object)tuple.a());
            valueOutput.method_71465(direction.method_10151() + "_distance", tuple.b().intValue());
        }
    }

    public void clearContent() {
        this.contents.clear();
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public boolean stillValid(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    @Override
    public int getComparatorOutput() {
        return Math.min(15, this.getContents().size());
    }
}

