/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.renderer;

import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.client.renderer.ItemInPipeRenderState;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.joml.Quaternionfc;

public class PipeRenderer<T extends ItemPipeEntity>
implements class_827<T, PipeRenderState> {
    protected final class_5614.class_5615 context;

    public PipeRenderer(class_5614.class_5615 context) {
        this.context = context;
    }

    public PipeRenderState createRenderState() {
        return new PipeRenderState();
    }

    public void extractRenderState(T pipe, PipeRenderState pipeState, float partialTicks, class_243 cameraPos, class_11683.class_11792 breakProgress) {
        super.method_74331(pipe, (class_11954)pipeState, partialTicks, cameraPos, breakProgress);
        ArrayList<ItemInPipeRenderState> itemRenderStates = new ArrayList<ItemInPipeRenderState>();
        for (ItemInPipe item : ((ItemPipeEntity)((Object)pipe)).getContents()) {
            class_10444 stackState = new class_10444();
            this.context.comp_4536().method_65598(stackState, item.getStack(), class_811.field_4319, pipe.method_10997(), null, 0);
            itemRenderStates.add(new ItemInPipeRenderState(stackState, item.getRenderPosition(partialTicks), item.getProgress() < 1024 ? item.getFromDirection() : item.getTargetDirection()));
        }
        if (pipe instanceof NetworkedPipeEntity) {
            NetworkedPipeEntity networkedPipe = (NetworkedPipeEntity)((Object)pipe);
            pipeState.initialise(itemRenderStates, ((ItemPipeEntity)((Object)pipe)).networkDistances, this.context.comp_4540(), networkedPipe.isController(), networkedPipe.syncedNetworkPos);
        } else {
            pipeState.initialise(itemRenderStates, ((ItemPipeEntity)((Object)pipe)).networkDistances, this.context.comp_4540());
        }
    }

    public void submit(PipeRenderState pipeState, class_4587 poses, class_11659 queue, class_12075 cameraState) {
        if (!pipeState.contents().isEmpty()) {
            for (ItemInPipeRenderState itemState : pipeState.contents()) {
                poses.method_22903();
                poses.method_61958(itemState.renderPos());
                poses.method_22905(0.4375f, 0.4375f, 0.4375f);
                if (itemState.direction().equals((Object)class_2350.field_11034) || itemState.direction().equals((Object)class_2350.field_11039)) {
                    poses.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
                } else if (itemState.direction().equals((Object)class_2350.field_11036) || itemState.direction().equals((Object)class_2350.field_11033)) {
                    poses.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
                }
                itemState.stackState().method_65604(poses, queue, pipeState.field_62676, class_4608.field_21444, 0);
                poses.method_22909();
            }
        }
    }

    public static class PipeRenderState
    extends class_11954 {
        private List<ItemInPipeRenderState> contents;
        private Map<class_2350, Tuple<class_2338, Integer>> networkDistances;
        private class_327 font;
        private boolean controller;
        private class_2338 syncedNetworkPos;
        private List<class_10444> heldItems;
        private List<Float> angles;

        public void initialise(List<ItemInPipeRenderState> contents, Map<class_2350, Tuple<class_2338, Integer>> networkDistances, class_327 font, boolean controller, class_2338 syncedNetworkPos) {
            this.contents = contents;
            this.networkDistances = networkDistances;
            this.font = font;
            this.controller = controller;
            this.syncedNetworkPos = syncedNetworkPos;
        }

        public void initialise(List<ItemInPipeRenderState> contents, Map<class_2350, Tuple<class_2338, Integer>> networkDistances, class_327 font) {
            this.initialise(contents, networkDistances, font, false, null);
        }

        public void setHeldItems(List<class_10444> heldItems, List<Float> angles) {
            this.heldItems = heldItems;
            this.angles = angles;
        }

        public List<ItemInPipeRenderState> contents() {
            return this.contents;
        }

        public Map<class_2350, Tuple<class_2338, Integer>> networkDistances() {
            return this.networkDistances;
        }

        public class_327 font() {
            return this.font;
        }

        public boolean controller() {
            return this.controller;
        }

        public class_2338 syncedNetworkPos() {
            return this.syncedNetworkPos;
        }

        public List<class_10444> heldItems() {
            return this.heldItems;
        }

        public List<Float> angles() {
            return this.angles;
        }
    }
}

