/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes;

import jagm.classicpipes.block.AdvancedCopperFluidPipeBlock;
import jagm.classicpipes.block.AdvancedCopperPipeBlock;
import jagm.classicpipes.block.BonePipeBlock;
import jagm.classicpipes.block.BrickFluidPipeBlock;
import jagm.classicpipes.block.BrickPipeBlock;
import jagm.classicpipes.block.CopperFluidPipeBlock;
import jagm.classicpipes.block.CopperPipeBlock;
import jagm.classicpipes.block.DiamondFluidPipeBlock;
import jagm.classicpipes.block.DiamondPipeBlock;
import jagm.classicpipes.block.FlintPipeBlock;
import jagm.classicpipes.block.GoldenPipeBlock;
import jagm.classicpipes.block.IronFluidPipeBlock;
import jagm.classicpipes.block.IronPipeBlock;
import jagm.classicpipes.block.LapisFluidPipeBlock;
import jagm.classicpipes.block.LapisPipeBlock;
import jagm.classicpipes.block.MatchingPipeBlock;
import jagm.classicpipes.block.NetworkedPipeBlock;
import jagm.classicpipes.block.ObsidianFluidPipeBlock;
import jagm.classicpipes.block.ObsidianPipeBlock;
import jagm.classicpipes.block.ProviderPipeBlock;
import jagm.classicpipes.block.RecipePipeBlock;
import jagm.classicpipes.block.RequestPipeBlock;
import jagm.classicpipes.block.StockingPipeBlock;
import jagm.classicpipes.block.StoragePipeBlock;
import jagm.classicpipes.block.WoodenFluidPipeBlock;
import jagm.classicpipes.block.WoodenPipeBlock;
import jagm.classicpipes.blockentity.AdvancedCopperFluidPipeEntity;
import jagm.classicpipes.blockentity.AdvancedCopperPipeEntity;
import jagm.classicpipes.blockentity.BonePipeEntity;
import jagm.classicpipes.blockentity.CopperFluidPipeEntity;
import jagm.classicpipes.blockentity.CopperPipeEntity;
import jagm.classicpipes.blockentity.DiamondFluidPipeEntity;
import jagm.classicpipes.blockentity.DiamondPipeEntity;
import jagm.classicpipes.blockentity.FlintPipeEntity;
import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.blockentity.GoldenPipeEntity;
import jagm.classicpipes.blockentity.IronFluidPipeEntity;
import jagm.classicpipes.blockentity.IronPipeEntity;
import jagm.classicpipes.blockentity.LapisFluidPipeEntity;
import jagm.classicpipes.blockentity.LapisPipeEntity;
import jagm.classicpipes.blockentity.MatchingPipeEntity;
import jagm.classicpipes.blockentity.ObsidianFluidPipeEntity;
import jagm.classicpipes.blockentity.ObsidianPipeEntity;
import jagm.classicpipes.blockentity.ProviderPipeEntity;
import jagm.classicpipes.blockentity.RecipePipeEntity;
import jagm.classicpipes.blockentity.RequestPipeEntity;
import jagm.classicpipes.blockentity.RoundRobinPipeEntity;
import jagm.classicpipes.blockentity.RoutingPipeEntity;
import jagm.classicpipes.blockentity.StockingPipeEntity;
import jagm.classicpipes.blockentity.StoragePipeEntity;
import jagm.classicpipes.inventory.menu.AdvancedCopperFluidPipeMenu;
import jagm.classicpipes.inventory.menu.AdvancedCopperPipeMenu;
import jagm.classicpipes.inventory.menu.DiamondFluidPipeMenu;
import jagm.classicpipes.inventory.menu.DiamondPipeMenu;
import jagm.classicpipes.inventory.menu.MatchingPipeMenu;
import jagm.classicpipes.inventory.menu.ProviderPipeMenu;
import jagm.classicpipes.inventory.menu.RecipePipeMenu;
import jagm.classicpipes.inventory.menu.RequestMenu;
import jagm.classicpipes.inventory.menu.RoutingPipeMenu;
import jagm.classicpipes.inventory.menu.StockingPipeMenu;
import jagm.classicpipes.inventory.menu.StoragePipeMenu;
import jagm.classicpipes.item.LoreBlockItem;
import jagm.classicpipes.item.LoreItem;
import jagm.classicpipes.item.ModLabelItem;
import jagm.classicpipes.item.TagLabelItem;
import jagm.classicpipes.network.ClientBoundBoolPayload;
import jagm.classicpipes.network.ClientBoundItemListPayload;
import jagm.classicpipes.network.ClientBoundRecipePipePayload;
import jagm.classicpipes.network.ClientBoundThreeBoolsPayload;
import jagm.classicpipes.network.ClientBoundTwoBoolsPayload;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.RequestItemTrigger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassicPipes {
    public static final String MOD_ID = "classicpipes";
    public static final String MOD_NAME = "Classic Pipes";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Classic Pipes");
    public static final Map<String, Item> ITEMS = new LinkedHashMap<String, Item>();
    public static final Map<String, Block> BLOCKS = new LinkedHashMap<String, Block>();
    public static final Map<String, SoundEvent> SOUNDS = new LinkedHashMap<String, SoundEvent>();
    public static final List<Block> TRANSPARENT_BLOCKS = new ArrayList<Block>();
    public static final Block OAK_PIPE = ClassicPipes.createWoodenPipe("oak_pipe", MapColor.f_283825_);
    public static final Block SPRUCE_PIPE = ClassicPipes.createWoodenPipe("spruce_pipe", MapColor.f_283819_);
    public static final Block BIRCH_PIPE = ClassicPipes.createWoodenPipe("birch_pipe", MapColor.f_283761_);
    public static final Block JUNGLE_PIPE = ClassicPipes.createWoodenPipe("jungle_pipe", MapColor.f_283762_);
    public static final Block ACACIA_PIPE = ClassicPipes.createWoodenPipe("acacia_pipe", MapColor.f_283750_);
    public static final Block DARK_OAK_PIPE = ClassicPipes.createWoodenPipe("dark_oak_pipe", MapColor.f_283748_);
    public static final Block MANGROVE_PIPE = ClassicPipes.createWoodenPipe("mangrove_pipe", MapColor.f_283913_);
    public static final Block CHERRY_PIPE = ClassicPipes.createWoodenPipe("cherry_pipe", MapColor.f_283919_);
    public static final Block BAMBOO_PIPE = ClassicPipes.createWoodenPipe("bamboo_pipe", MapColor.f_283832_);
    public static final Block CRIMSON_PIPE = ClassicPipes.createWoodenPipe("crimson_pipe", MapColor.f_283804_);
    public static final Block WARPED_PIPE = ClassicPipes.createWoodenPipe("warped_pipe", MapColor.f_283749_);
    public static final Block COPPER_PIPE = ClassicPipes.createPipe("copper_pipe", CopperPipeBlock::new, SoundType.f_154663_, MapColor.f_283750_, 0.25f, ClassicPipes.translateDesc("copper_pipe"));
    public static final Block ADVANCED_COPPER_PIPE = ClassicPipes.createPipe("advanced_copper_pipe", AdvancedCopperPipeBlock::new, SoundType.f_154663_, MapColor.f_283750_, 0.25f, ClassicPipes.translateDesc("advanced_copper_pipe"));
    public static final Block IRON_PIPE = ClassicPipes.createPipe("iron_pipe", IronPipeBlock::new, SoundType.f_154663_, MapColor.f_283906_, 0.25f, ClassicPipes.translateDesc("iron_pipe"));
    public static final Block LAPIS_PIPE = ClassicPipes.createPipe("lapis_pipe", LapisPipeBlock::new, SoundType.f_154663_, MapColor.f_283933_, 0.25f, ClassicPipes.translateDesc("lapis_pipe"));
    public static final Block GOLDEN_PIPE = ClassicPipes.createPipe("golden_pipe", GoldenPipeBlock::new, SoundType.f_154663_, MapColor.f_283757_, 0.25f, ClassicPipes.translateDesc("golden_pipe"));
    public static final Block DIAMOND_PIPE = ClassicPipes.createPipe("diamond_pipe", DiamondPipeBlock::new, SoundType.f_154663_, MapColor.f_283821_, 0.25f, ClassicPipes.translateDesc("diamond_pipe"));
    public static final Block FLINT_PIPE = ClassicPipes.createPipe("flint_pipe", FlintPipeBlock::new, SoundType.f_271215_, MapColor.f_283818_, 0.25f, ClassicPipes.translateDesc("flint_pipe"));
    public static final Block BRICK_PIPE = ClassicPipes.createPipe("brick_pipe", BrickPipeBlock::new, SoundType.f_271215_, MapColor.f_283913_, 0.25f, ClassicPipes.translateDesc("brick_pipe"));
    public static final Block OBSIDIAN_PIPE = ClassicPipes.createPipe("obsidian_pipe", ObsidianPipeBlock::new, SoundType.f_271215_, MapColor.f_283927_, 0.25f, ClassicPipes.translateDesc("obsidian_pipe"));
    public static final Block BONE_PIPE = ClassicPipes.createPipe("bone_pipe", BonePipeBlock::new, SoundType.f_56724_, MapColor.f_283761_, 0.25f, ClassicPipes.translateDesc("bone_pipe"));
    public static final Block ROUTING_PIPE = ClassicPipes.createPipe("routing_pipe", NetworkedPipeBlock::new, SoundType.f_154663_, MapColor.f_283927_, 0.25f, ClassicPipes.translateDesc("routing_pipe.a"), ClassicPipes.translateDesc("routing_pipe.b"));
    public static final Block PROVIDER_PIPE = ClassicPipes.createPipe("provider_pipe", ProviderPipeBlock::new, SoundType.f_154663_, MapColor.f_283927_, 0.25f, ClassicPipes.translateDesc("provider_pipe"));
    public static final Block REQUEST_PIPE = ClassicPipes.createPipe("request_pipe", RequestPipeBlock::new, SoundType.f_154663_, MapColor.f_283927_, 0.25f, ClassicPipes.translateDesc("request_pipe"));
    public static final Block STOCKING_PIPE = ClassicPipes.createPipe("stocking_pipe", StockingPipeBlock::new, SoundType.f_154663_, MapColor.f_283927_, 0.25f, ClassicPipes.translateDesc("stocking_pipe"));
    public static final Block MATCHING_PIPE = ClassicPipes.createPipe("matching_pipe", MatchingPipeBlock::new, SoundType.f_154663_, MapColor.f_283927_, 0.25f, ClassicPipes.translateDesc("matching_pipe"));
    public static final Block STORAGE_PIPE = ClassicPipes.createPipe("storage_pipe", StoragePipeBlock::new, SoundType.f_154663_, MapColor.f_283927_, 0.25f, ClassicPipes.translateDesc("storage_pipe.a"), ClassicPipes.translateDesc("storage_pipe.b"));
    public static final Block RECIPE_PIPE = ClassicPipes.createPipe("recipe_pipe", RecipePipeBlock::new, SoundType.f_154663_, MapColor.f_283927_, 0.25f, ClassicPipes.translateDesc("recipe_pipe.a"), ClassicPipes.translateDesc("recipe_pipe.b"));
    public static final Block OAK_FLUID_PIPE = ClassicPipes.createWoodenFluidPipe("oak_fluid_pipe", MapColor.f_283825_);
    public static final Block SPRUCE_FLUID_PIPE = ClassicPipes.createWoodenFluidPipe("spruce_fluid_pipe", MapColor.f_283819_);
    public static final Block BIRCH_FLUID_PIPE = ClassicPipes.createWoodenFluidPipe("birch_fluid_pipe", MapColor.f_283761_);
    public static final Block JUNGLE_FLUID_PIPE = ClassicPipes.createWoodenFluidPipe("jungle_fluid_pipe", MapColor.f_283762_);
    public static final Block ACACIA_FLUID_PIPE = ClassicPipes.createWoodenFluidPipe("acacia_fluid_pipe", MapColor.f_283750_);
    public static final Block DARK_OAK_FLUID_PIPE = ClassicPipes.createWoodenFluidPipe("dark_oak_fluid_pipe", MapColor.f_283748_);
    public static final Block MANGROVE_FLUID_PIPE = ClassicPipes.createWoodenFluidPipe("mangrove_fluid_pipe", MapColor.f_283913_);
    public static final Block CHERRY_FLUID_PIPE = ClassicPipes.createWoodenFluidPipe("cherry_fluid_pipe", MapColor.f_283919_);
    public static final Block BAMBOO_FLUID_PIPE = ClassicPipes.createWoodenFluidPipe("bamboo_fluid_pipe", MapColor.f_283832_);
    public static final Block CRIMSON_FLUID_PIPE = ClassicPipes.createWoodenFluidPipe("crimson_fluid_pipe", MapColor.f_283804_);
    public static final Block WARPED_FLUID_PIPE = ClassicPipes.createWoodenFluidPipe("warped_fluid_pipe", MapColor.f_283749_);
    public static final Block COPPER_FLUID_PIPE = ClassicPipes.createPipe("copper_fluid_pipe", CopperFluidPipeBlock::new, SoundType.f_154663_, MapColor.f_283750_, 0.25f, ClassicPipes.translateDesc("copper_fluid_pipe"));
    public static final Block ADVANCED_COPPER_FLUID_PIPE = ClassicPipes.createPipe("advanced_copper_fluid_pipe", AdvancedCopperFluidPipeBlock::new, SoundType.f_154663_, MapColor.f_283750_, 0.25f, ClassicPipes.translateDesc("advanced_copper_fluid_pipe"));
    public static final Block IRON_FLUID_PIPE = ClassicPipes.createPipe("iron_fluid_pipe", IronFluidPipeBlock::new, SoundType.f_154663_, MapColor.f_283906_, 0.25f, ClassicPipes.translateDesc("iron_fluid_pipe"));
    public static final Block LAPIS_FLUID_PIPE = ClassicPipes.createPipe("lapis_fluid_pipe", LapisFluidPipeBlock::new, SoundType.f_154663_, MapColor.f_283933_, 0.25f, ClassicPipes.translateDesc("lapis_fluid_pipe"));
    public static final Block DIAMOND_FLUID_PIPE = ClassicPipes.createPipe("diamond_fluid_pipe", DiamondFluidPipeBlock::new, SoundType.f_154663_, MapColor.f_283821_, 0.25f, ClassicPipes.translateDesc("diamond_fluid_pipe"));
    public static final Block BRICK_FLUID_PIPE = ClassicPipes.createPipe("brick_fluid_pipe", BrickFluidPipeBlock::new, SoundType.f_271215_, MapColor.f_283913_, 0.25f, ClassicPipes.translateDesc("brick_fluid_pipe"));
    public static final Block OBSIDIAN_FLUID_PIPE = ClassicPipes.createPipe("obsidian_fluid_pipe", ObsidianFluidPipeBlock::new, SoundType.f_271215_, MapColor.f_283927_, 0.25f, ClassicPipes.translateDesc("obsidian_fluid_pipe"));
    public static final BlockEntityType<RoundRobinPipeEntity> BASIC_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(RoundRobinPipeEntity::new, OAK_PIPE, SPRUCE_PIPE, BIRCH_PIPE, JUNGLE_PIPE, ACACIA_PIPE, DARK_OAK_PIPE, MANGROVE_PIPE, CHERRY_PIPE, BAMBOO_PIPE, CRIMSON_PIPE, WARPED_PIPE, BRICK_PIPE);
    public static final BlockEntityType<GoldenPipeEntity> GOLDEN_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(GoldenPipeEntity::new, GOLDEN_PIPE);
    public static final BlockEntityType<CopperPipeEntity> COPPER_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(CopperPipeEntity::new, COPPER_PIPE);
    public static final BlockEntityType<IronPipeEntity> IRON_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(IronPipeEntity::new, IRON_PIPE);
    public static final BlockEntityType<DiamondPipeEntity> DIAMOND_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(DiamondPipeEntity::new, DIAMOND_PIPE);
    public static final BlockEntityType<FlintPipeEntity> FLINT_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(FlintPipeEntity::new, FLINT_PIPE);
    public static final BlockEntityType<LapisPipeEntity> LAPIS_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(LapisPipeEntity::new, LAPIS_PIPE);
    public static final BlockEntityType<ObsidianPipeEntity> OBSIDIAN_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(ObsidianPipeEntity::new, OBSIDIAN_PIPE);
    public static final BlockEntityType<BonePipeEntity> BONE_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(BonePipeEntity::new, BONE_PIPE);
    public static final BlockEntityType<RoutingPipeEntity> ROUTING_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(RoutingPipeEntity::new, ROUTING_PIPE);
    public static final BlockEntityType<ProviderPipeEntity> PROVIDER_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(ProviderPipeEntity::new, PROVIDER_PIPE);
    public static final BlockEntityType<RequestPipeEntity> REQUEST_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(RequestPipeEntity::new, REQUEST_PIPE);
    public static final BlockEntityType<StockingPipeEntity> STOCKING_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(StockingPipeEntity::new, STOCKING_PIPE);
    public static final BlockEntityType<MatchingPipeEntity> MATCHING_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(MatchingPipeEntity::new, MATCHING_PIPE);
    public static final BlockEntityType<StoragePipeEntity> STORAGE_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(StoragePipeEntity::new, STORAGE_PIPE);
    public static final BlockEntityType<RecipePipeEntity> RECIPE_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(RecipePipeEntity::new, RECIPE_PIPE);
    public static final BlockEntityType<FluidPipeEntity> FLUID_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(FluidPipeEntity::new, OAK_FLUID_PIPE, SPRUCE_FLUID_PIPE, BIRCH_FLUID_PIPE, JUNGLE_FLUID_PIPE, ACACIA_FLUID_PIPE, DARK_OAK_FLUID_PIPE, MANGROVE_FLUID_PIPE, CHERRY_FLUID_PIPE, BAMBOO_FLUID_PIPE, CRIMSON_FLUID_PIPE, WARPED_FLUID_PIPE, BRICK_FLUID_PIPE);
    public static final BlockEntityType<CopperFluidPipeEntity> COPPER_FLUID_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(CopperFluidPipeEntity::new, COPPER_FLUID_PIPE);
    public static final BlockEntityType<IronFluidPipeEntity> IRON_FLUID_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(IronFluidPipeEntity::new, IRON_FLUID_PIPE);
    public static final BlockEntityType<LapisFluidPipeEntity> LAPIS_FLUID_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(LapisFluidPipeEntity::new, LAPIS_FLUID_PIPE);
    public static final BlockEntityType<DiamondFluidPipeEntity> DIAMOND_FLUID_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(DiamondFluidPipeEntity::new, DIAMOND_FLUID_PIPE);
    public static final BlockEntityType<ObsidianFluidPipeEntity> OBSIDIAN_FLUID_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(ObsidianFluidPipeEntity::new, OBSIDIAN_FLUID_PIPE);
    public static final BlockEntityType<AdvancedCopperPipeEntity> ADVANCED_COPPER_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(AdvancedCopperPipeEntity::new, ADVANCED_COPPER_PIPE);
    public static final BlockEntityType<AdvancedCopperFluidPipeEntity> ADVANCED_COPPER_FLUID_PIPE_ENTITY = Services.LOADER_SERVICE.createBlockEntityType(AdvancedCopperFluidPipeEntity::new, ADVANCED_COPPER_FLUID_PIPE);
    public static final Item PIPE_SLICER = ClassicPipes.createItem("pipe_slicer", props -> new LoreItem((Item.Properties)props, ClassicPipes.translateDesc("pipe_slicer")), 1);
    public static final Item TAG_LABEL = ClassicPipes.createItem("tag_label", TagLabelItem::new, 1);
    public static final Item MOD_LABEL = ClassicPipes.createItem("mod_label", ModLabelItem::new, 1);
    public static final RequestItemTrigger REQUEST_ITEM_TRIGGER = new RequestItemTrigger();
    public static final TagKey<Fluid> THIN_FLUIDS = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)MiscUtil.resourceLocation("thin"));
    public static final TagKey<Fluid> THICK_FLUIDS = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)MiscUtil.resourceLocation("thick"));
    public static final SoundEvent PIPE_EJECT_SOUND = ClassicPipes.createSoundEvent("pipe_eject");
    public static final SoundEvent PIPE_ADJUST_SOUND = ClassicPipes.createSoundEvent("pipe_adjust");
    public static final SoundEvent OBSIDIAN_PIPE_DESTROY_ITEM = ClassicPipes.createSoundEvent("obsidian_pipe_destroy_item");
    public static final SoundEvent OBSIDIAN_FLUID_PIPE_GURGLE = ClassicPipes.createSoundEvent("obsidian_fluid_pipe_gurgle");
    public static final CreativeModeTab PIPES_TAB = CreativeModeTab.m_257815_((CreativeModeTab.Row)CreativeModeTab.Row.BOTTOM, (int)0).m_257941_((Component)Component.m_237115_((String)"itemGroup.classicpipes.pipes")).m_257737_(() -> new ItemStack((ItemLike)COPPER_PIPE)).m_257652_();
    public static final ResourceKey<CreativeModeTab> PIPES_TAB_KEY = MiscUtil.makeKey(BuiltInRegistries.f_279662_.m_123023_(), "pipes");
    public static final MenuType<DiamondPipeMenu> DIAMOND_PIPE_MENU = Services.LOADER_SERVICE.createMenuType(DiamondPipeMenu::new, ClientBoundBoolPayload.HANDLER);
    public static final MenuType<RoutingPipeMenu> ROUTING_PIPE_MENU = Services.LOADER_SERVICE.createMenuType(RoutingPipeMenu::new, ClientBoundTwoBoolsPayload.HANDLER);
    public static final MenuType<ProviderPipeMenu> PROVIDER_PIPE_MENU = Services.LOADER_SERVICE.createMenuType(ProviderPipeMenu::new, ClientBoundTwoBoolsPayload.HANDLER);
    public static final MenuType<RequestMenu> REQUEST_MENU = Services.LOADER_SERVICE.createMenuType(RequestMenu::new, ClientBoundItemListPayload.HANDLER);
    public static final MenuType<StockingPipeMenu> STOCKING_PIPE_MENU = Services.LOADER_SERVICE.createMenuType(StockingPipeMenu::new, ClientBoundTwoBoolsPayload.HANDLER);
    public static final MenuType<MatchingPipeMenu> MATCHING_PIPE_MENU = Services.LOADER_SERVICE.createMenuType(MatchingPipeMenu::new, ClientBoundBoolPayload.HANDLER);
    public static final MenuType<StoragePipeMenu> STORAGE_PIPE_MENU = Services.LOADER_SERVICE.createMenuType(StoragePipeMenu::new, ClientBoundThreeBoolsPayload.HANDLER);
    public static final MenuType<RecipePipeMenu> RECIPE_PIPE_MENU = Services.LOADER_SERVICE.createMenuType(RecipePipeMenu::new, ClientBoundRecipePipePayload.HANDLER);
    public static final MenuType<DiamondFluidPipeMenu> DIAMOND_FLUID_PIPE_MENU = Services.LOADER_SERVICE.createSimpleMenuType(DiamondFluidPipeMenu::new);
    public static final MenuType<AdvancedCopperPipeMenu> ADVANCED_COPPER_PIPE_MENU = Services.LOADER_SERVICE.createMenuType(AdvancedCopperPipeMenu::new, ClientBoundBoolPayload.HANDLER);
    public static final MenuType<AdvancedCopperFluidPipeMenu> ADVANCED_COPPER_FLUID_PIPE_MENU = Services.LOADER_SERVICE.createSimpleMenuType(AdvancedCopperFluidPipeMenu::new);

    private static Item createItem(String name, Function<Item.Properties, Item> factory, int stackSize) {
        Item.Properties props = new Item.Properties();
        if (stackSize < 64) {
            props.m_41487_(stackSize);
        }
        Item item = factory.apply(props);
        ITEMS.put(name, item);
        return item;
    }

    private static Block createBlock(String name, Function<BlockBehaviour.Properties, Block> factory, BlockBehaviour.Properties props, Component ... lore) {
        Block block = factory.apply(props);
        BLOCKS.put(name, block);
        ClassicPipes.createItem(name, itemProps -> new LoreBlockItem(block, (Item.Properties)itemProps, lore), 64);
        return block;
    }

    private static Block createPipe(String name, Function<BlockBehaviour.Properties, Block> factory, SoundType sound, MapColor mapColor, float hardness, Component ... lore) {
        Block pipe = ClassicPipes.createBlock(name, factory, BlockBehaviour.Properties.m_284310_().m_60918_(sound).m_284180_(mapColor).m_155954_(hardness).m_60955_(), lore);
        TRANSPARENT_BLOCKS.add(pipe);
        return pipe;
    }

    private static Block createWoodenPipe(String name, MapColor mapColor) {
        return ClassicPipes.createPipe(name, WoodenPipeBlock::new, SoundType.f_56756_, mapColor, 0.0f, ClassicPipes.translateDesc("wooden_pipe"));
    }

    private static Block createWoodenFluidPipe(String name, MapColor mapColor) {
        return ClassicPipes.createPipe(name, WoodenFluidPipeBlock::new, SoundType.f_56756_, mapColor, 0.0f, ClassicPipes.translateDesc("wooden_fluid_pipe"));
    }

    private static SoundEvent createSoundEvent(String name) {
        SoundEvent soundEvent = SoundEvent.m_262824_((ResourceLocation)MiscUtil.resourceLocation(name));
        SOUNDS.put(name, soundEvent);
        return soundEvent;
    }

    private static Component translateDesc(String desc) {
        return Component.m_237115_((String)("item.classicpipes." + desc + ".desc")).m_130940_(ChatFormatting.GRAY);
    }
}

