/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FluidInPipe;
import jagm.classicpipes.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class FluidPipeEntity
extends PipeEntity {
    public static final int CAPACITY = 1000;
    public static final int MIN_PACKET_SIZE = 20;
    protected Fluid fluid;
    protected final List<FluidInPipe> contents = new ArrayList<FluidInPipe>();
    protected final List<FluidInPipe> queued = new ArrayList<FluidInPipe>();
    private final Map<FluidInPipe, Long> tickAdded = new HashMap<FluidInPipe, Long>();

    public FluidPipeEntity(BlockPos pos, BlockState state) {
        this(ClassicPipes.FLUID_PIPE_ENTITY, pos, state);
    }

    public FluidPipeEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluid = Fluids.f_76193_;
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        boolean sendBlockUpdate = false;
        if (!this.contents.isEmpty()) {
            ListIterator<FluidInPipe> iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                FluidInPipe fluidPacket = iterator.next();
                if (this.tickAdded.containsKey(fluidPacket)) {
                    if (this.tickAdded.get(fluidPacket).longValue() == level.m_46467_()) continue;
                    this.tickAdded.remove(fluidPacket);
                }
                fluidPacket.move(this.getTargetSpeed(), this.getAcceleration());
                if (fluidPacket.getAge() > 24000) {
                    iterator.remove();
                    sendBlockUpdate = true;
                    continue;
                }
                if (fluidPacket.getProgress() < 2048) continue;
                boolean remove = false;
                BlockPos containerPos = pos.m_121945_(fluidPacket.getTargetDirection());
                BlockEntity blockEntity = level.m_7702_(containerPos);
                if (blockEntity instanceof FluidPipeEntity) {
                    FluidPipeEntity nextPipe = (FluidPipeEntity)blockEntity;
                    if (nextPipe.emptyOrMatches(this.fluid)) {
                        nextPipe.setFluid(this.fluid);
                        remove = true;
                        int amountToPass = Math.min(fluidPacket.getAmount(), nextPipe.remainingCapacity());
                        if (amountToPass == fluidPacket.getAmount()) {
                            fluidPacket.resetProgress(fluidPacket.getTargetDirection().m_122424_());
                            nextPipe.insertFluidPacket((Level)level, fluidPacket);
                        } else {
                            remove = false;
                            if (amountToPass >= 20) {
                                FluidInPipe newPacket = fluidPacket.copyWithAmount(amountToPass);
                                newPacket.resetProgress(fluidPacket.getTargetDirection().m_122424_());
                                nextPipe.insertFluidPacket((Level)level, newPacket);
                                fluidPacket.setAmount(fluidPacket.getAmount() - amountToPass);
                            }
                        }
                        level.m_7260_(containerPos, nextPipe.m_58900_(), nextPipe.m_58900_(), 2);
                    }
                } else if (blockEntity != null) {
                    remove = Services.LOADER_SERVICE.handleFluidInsertion(this, level, pos, state, blockEntity, containerPos, this.fluid, fluidPacket);
                }
                if (remove) {
                    iterator.remove();
                } else {
                    fluidPacket.resetProgress(fluidPacket.getTargetDirection());
                    this.routePacket(state, fluidPacket);
                }
                sendBlockUpdate = true;
            }
            this.addQueuedPackets((Level)level, false);
        }
        if (sendBlockUpdate) {
            level.m_7260_(pos, state, state, 2);
        }
    }

    @Override
    public void tickClient(Level level, BlockPos pos) {
        if (!this.contents.isEmpty()) {
            ListIterator<FluidInPipe> iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                FluidPipeEntity nextPipe;
                BlockPos nextPos;
                BlockEntity blockEntity;
                FluidInPipe fluidPacket = iterator.next();
                if (this.tickAdded.containsKey(fluidPacket)) {
                    if (this.tickAdded.get(fluidPacket).longValue() == level.m_46467_()) continue;
                    this.tickAdded.remove(fluidPacket);
                }
                fluidPacket.move(this.getTargetSpeed(), this.getAcceleration());
                if (fluidPacket.getProgress() < 2048 || !((blockEntity = level.m_7702_(nextPos = pos.m_121945_(fluidPacket.getTargetDirection()))) instanceof FluidPipeEntity) || !(nextPipe = (FluidPipeEntity)blockEntity).emptyOrMatches(this.fluid)) continue;
                fluidPacket.resetProgress(fluidPacket.getTargetDirection().m_122424_());
                nextPipe.setFluid(this.fluid);
                nextPipe.insertFluidPacket(level, fluidPacket);
                iterator.remove();
            }
        }
    }

    @Override
    public void update(ServerLevel level, BlockState state, BlockPos pos, Direction direction, boolean wasConnected) {
        if (!this.contents.isEmpty()) {
            ListIterator<FluidInPipe> iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                FluidInPipe fluidPacket = iterator.next();
                if (!wasConnected || fluidPacket.getTargetDirection() == direction && fluidPacket.getFromDirection() != direction && fluidPacket.getProgress() < 1024) {
                    this.routePacket(state, fluidPacket);
                    continue;
                }
                if ((fluidPacket.getFromDirection() != direction || fluidPacket.getProgress() >= 1024) && (fluidPacket.getTargetDirection() != direction || fluidPacket.getProgress() < 1024)) continue;
                iterator.remove();
            }
            this.addQueuedPackets((Level)level, false);
        }
        this.m_6596_();
        level.m_7260_(pos, state, state, 2);
    }

    @Override
    public int getComparatorOutput() {
        if (this.contents.isEmpty()) {
            return 0;
        }
        return Math.max(1, Math.round(15.0f * (float)this.totalAmount() / 1000.0f));
    }

    @Override
    public short getTargetSpeed() {
        FluidState fluidState = this.fluid.m_76145_();
        if (fluidState.m_205070_(ClassicPipes.THIN_FLUIDS)) {
            return 256;
        }
        if (fluidState.m_205070_(ClassicPipes.THICK_FLUIDS) && this.f_58857_ != null && !this.f_58857_.m_6042_().f_63857_()) {
            return 64;
        }
        return 128;
    }

    @Override
    public short getAcceleration() {
        return 1;
    }

    public void m_142466_(CompoundTag valueInput) {
        this.contents.clear();
        this.tickAdded.clear();
        super.m_142466_(valueInput);
        ListTag fluidPacketList = valueInput.m_128437_("fluid_packets", 10);
        fluidPacketList.forEach(tag -> MiscUtil.loadFromTag(tag, FluidInPipe.CODEC, this.contents::add));
        MiscUtil.loadFromTag(valueInput.m_128423_("fluid"), BuiltInRegistries.f_257020_.m_194605_(), this::setFluid);
    }

    protected void m_183515_(CompoundTag valueOutput) {
        super.m_183515_(valueOutput);
        ListTag fluidPacketList = new ListTag();
        for (FluidInPipe fluidPacket : this.contents) {
            if (fluidPacket.getAmount() <= 0) continue;
            MiscUtil.saveToTag(fluidPacket, FluidInPipe.CODEC, arg_0 -> fluidPacketList.add(arg_0));
        }
        valueOutput.m_128365_("fluid_packets", (Tag)fluidPacketList);
        MiscUtil.saveToTag(this.fluid, BuiltInRegistries.f_257020_.m_194605_(), tag -> valueOutput.m_128365_("fluid", tag));
    }

    public void addQueuedPackets(Level level, boolean waitForNextTick) {
        for (FluidInPipe fluidPacket : this.queued) {
            this.contents.add(fluidPacket);
            if (!waitForNextTick) continue;
            this.tickAdded.put(fluidPacket, level.m_46467_());
        }
        this.m_6596_();
        this.queued.clear();
    }

    public boolean emptyOrMatches(Fluid fluid) {
        return this.contents.isEmpty() || this.fluid == fluid;
    }

    public int totalAmount() {
        int total = 0;
        for (FluidInPipe fluidPacket : this.contents) {
            total += fluidPacket.getAmount();
        }
        return total;
    }

    public int remainingCapacity() {
        return 1000 - this.totalAmount();
    }

    public void setFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    public void insertFluidPacket(Level level, FluidInPipe fluidPacket) {
        this.queued.add(fluidPacket);
        this.routePacket(fluidPacket);
        this.addQueuedPackets(level, true);
    }

    protected List<Direction> getValidDirections(BlockState state, FluidInPipe fluidPacket) {
        ArrayList<Direction> validDirections = new ArrayList<Direction>();
        Direction direction = MiscUtil.nextDirection(fluidPacket.getFromDirection());
        for (int i = 0; i < 5; ++i) {
            if (this.isPipeConnected(state, direction)) {
                validDirections.add(direction);
            }
            direction = MiscUtil.nextDirection(direction);
        }
        return validDirections;
    }

    public void routePacket(BlockState state, FluidInPipe fluidPacket) {
        List<Direction> validDirections = this.getValidDirections(state, fluidPacket);
        int numDirections = validDirections.size();
        if (numDirections == 0) {
            fluidPacket.setTargetDirection(fluidPacket.getFromDirection());
        } else if (numDirections == 1) {
            fluidPacket.setTargetDirection(validDirections.get(0));
        } else if (fluidPacket.getAmount() > 20) {
            int splitAmount = fluidPacket.getAmount() / numDirections;
            int leftoverAmount = fluidPacket.getAmount() % numDirections;
            Collections.shuffle(validDirections);
            for (int i = 0; i < numDirections; ++i) {
                if (i == 0) {
                    fluidPacket.setAmount(splitAmount + leftoverAmount);
                    fluidPacket.setTargetDirection(validDirections.get(i));
                    continue;
                }
                FluidInPipe newPacket = fluidPacket.copyWithAmount(splitAmount);
                newPacket.setTargetDirection(validDirections.get(i));
                this.queued.add(newPacket);
            }
        } else if (this.m_58904_() != null) {
            fluidPacket.setTargetDirection(validDirections.get(this.m_58904_().m_213780_().m_188503_(validDirections.size())));
        }
    }

    public void routePacket(FluidInPipe fluidPacket) {
        this.routePacket(this.m_58900_(), fluidPacket);
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public List<FluidInPipe> getContents() {
        return this.contents;
    }
}

