/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.ProviderPipeBlock;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.blockentity.ProviderPipe;
import jagm.classicpipes.inventory.container.SingleItemFilterContainer;
import jagm.classicpipes.inventory.menu.ProviderPipeMenu;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.PipeNetwork;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ProviderPipeEntity
extends NetworkedPipeEntity
implements MenuProvider,
ProviderPipe {
    private final SingleItemFilterContainer filter = new SingleItemFilterContainer(this, 9, false);
    private boolean leaveOne = false;
    private final List<ItemStack> cache = new ArrayList<ItemStack>();
    private boolean cacheInitialised = false;

    public ProviderPipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.PROVIDER_PIPE_ENTITY, pos, state);
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        if (!this.cacheInitialised && !((FacingOrNone)((Object)state.m_61143_((Property)ProviderPipeBlock.FACING))).equals((Object)FacingOrNone.NONE)) {
            this.updateCache(level, pos, ((FacingOrNone)((Object)state.m_61143_((Property)ProviderPipeBlock.FACING))).getDirection());
            this.cacheInitialised = true;
        }
        super.tickServer(level, pos, state);
    }

    @Override
    public void disconnect(ServerLevel level) {
        PipeNetwork network = this.getNetwork();
        super.disconnect(level);
        if (network != null) {
            network.cacheUpdated();
        }
    }

    @Override
    public void m_142466_(CompoundTag valueInput) {
        this.filter.m_6211_();
        this.cacheInitialised = false;
        super.m_142466_(valueInput);
        ListTag filterList = valueInput.m_128437_("filter", 10);
        filterList.forEach(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                int slot = compoundTag.m_128451_("slot");
                MiscUtil.loadFromTag(tag, ItemStack.f_41582_, stack -> this.filter.m_6836_(slot, (ItemStack)stack));
            }
        });
        this.filter.setMatchComponents(valueInput.m_128471_("match_components"));
        this.leaveOne = valueInput.m_128471_("leave_one");
    }

    @Override
    protected void m_183515_(CompoundTag valueOutput) {
        super.m_183515_(valueOutput);
        ListTag filterList = new ListTag();
        for (int slot = 0; slot < this.filter.m_6643_(); ++slot) {
            ItemStack stack = this.filter.m_8020_(slot);
            if (stack.m_41619_()) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("slot", slot);
            MiscUtil.saveToTag((Tag)tag, stack, ItemStack.f_41582_, arg_0 -> filterList.add(arg_0));
        }
        valueOutput.m_128365_("filter", (Tag)filterList);
        valueOutput.m_128379_("match_components", this.filter.shouldMatchComponents());
        valueOutput.m_128379_("leave_one", this.leaveOne);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.classicpipes.provider_pipe");
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new ProviderPipeMenu(id, playerInventory, this.filter, this.leaveOne);
    }

    public boolean shouldMatchComponents() {
        return this.filter.shouldMatchComponents();
    }

    public void setLeaveOne(boolean leaveOne) {
        this.leaveOne = leaveOne;
        Direction facing = ((FacingOrNone)((Object)this.m_58900_().m_61143_((Property)ProviderPipeBlock.FACING))).getDirection();
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (facing != null) {
                this.updateCache(serverLevel, this.m_58899_(), facing);
            }
        }
    }

    public boolean shouldLeaveOne() {
        return this.leaveOne;
    }

    @Override
    public void updateCache(ServerLevel level, BlockPos pos, Direction facing) {
        this.cache.clear();
        List<ItemStack> stacks = Services.LOADER_SERVICE.getContainerItems(level, pos.m_121945_(facing), facing.m_122424_());
        Iterator<ItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = iterator.next();
            if (!this.filter.m_7983_() && !this.filter.matches(stack)) {
                iterator.remove();
                continue;
            }
            if (!this.shouldLeaveOne()) continue;
            stack.m_41774_(1);
            if (!stack.m_41619_()) continue;
            iterator.remove();
        }
        this.cache.addAll(stacks);
        if (this.hasNetwork()) {
            this.getNetwork().cacheUpdated();
        }
    }

    public void updateCache() {
        Direction facing = ((FacingOrNone)((Object)this.m_58900_().m_61143_((Property)ProviderPipeBlock.FACING))).getDirection();
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (facing != null) {
                this.updateCache(serverLevel, this.m_58899_(), facing);
            }
        }
    }

    @Override
    public List<ItemStack> getCache() {
        return this.cache;
    }

    @Override
    public boolean extractItem(ServerLevel level, ItemStack stack) {
        Direction facing = ((FacingOrNone)((Object)this.m_58900_().m_61143_((Property)ProviderPipeBlock.FACING))).getDirection();
        if (facing != null) {
            boolean extracted = Services.LOADER_SERVICE.extractSpecificItem(this, level, this.m_58899_().m_121945_(facing), facing.m_122424_(), stack.m_41777_());
            this.updateCache(level, this.m_58899_(), facing);
            return extracted;
        }
        return false;
    }

    @Override
    public BlockPos getProviderPipePos() {
        return this.m_58899_();
    }

    @Override
    public Direction getFacing() {
        return ((FacingOrNone)((Object)this.m_58900_().m_61143_((Property)ProviderPipeBlock.FACING))).getDirection();
    }
}

