/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.StockingPipeBlock;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.inventory.container.FilterContainer;
import jagm.classicpipes.inventory.menu.StockingPipeMenu;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.RequestedItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StockingPipeEntity
extends NetworkedPipeEntity
implements MenuProvider {
    private final FilterContainer filter = new FilterContainer(this, 9, true);
    private boolean activeStocking = false;
    private final List<ItemStack> missingItemsCache = new ArrayList<ItemStack>();
    private boolean cacheInitialised = false;

    public StockingPipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.STOCKING_PIPE_ENTITY, pos, state);
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        super.tickServer(level, pos, state);
        if (!this.cacheInitialised) {
            this.updateCache(level);
            this.cacheInitialised = true;
        }
    }

    public void updateCache(ServerLevel level) {
        this.missingItemsCache.clear();
        Direction facing = ((FacingOrNone)((Object)this.m_58900_().m_61143_((Property)StockingPipeBlock.FACING))).getDirection();
        if (facing != null) {
            ArrayList<ItemStack> filterItems = new ArrayList<ItemStack>();
            for (int i = 0; i < this.filter.m_6643_(); ++i) {
                ItemStack stack = this.filter.m_8020_(i);
                if (stack.m_41619_()) continue;
                boolean matched = false;
                for (ItemStack filterStack : filterItems) {
                    if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)filterStack)) continue;
                    filterStack.m_41769_(stack.m_41613_());
                    matched = true;
                    break;
                }
                if (matched) continue;
                filterItems.add(stack.m_41777_());
            }
            if (!filterItems.isEmpty()) {
                List<ItemStack> containerItems = Services.LOADER_SERVICE.getContainerItems(level, this.m_58899_().m_121945_(facing), facing.m_122424_());
                for (ItemStack filterStack : filterItems) {
                    boolean matched = false;
                    for (ItemStack containerStack : containerItems) {
                        if (!ItemStack.m_150942_((ItemStack)filterStack, (ItemStack)containerStack)) continue;
                        matched = true;
                        int missing = filterStack.m_41613_() - containerStack.m_41613_();
                        if (missing <= 0) break;
                        this.missingItemsCache.add(containerStack.m_255036_(missing));
                        break;
                    }
                    if (matched) continue;
                    this.missingItemsCache.add(filterStack);
                }
            }
        }
        if (this.activeStocking) {
            this.tryRequests(level);
        }
    }

    public void updateCache() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.updateCache(serverLevel);
        }
    }

    public void tryRequests(ServerLevel level) {
        if (this.hasNetwork()) {
            for (ItemStack stack : this.missingItemsCache) {
                int alreadyRequested = 0;
                for (ItemInPipe item : this.contents) {
                    if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)item.getStack())) continue;
                    alreadyRequested += item.getStack().m_41613_();
                }
                for (RequestedItem requestedItem : this.getNetwork().getRequestedItems()) {
                    if (!requestedItem.matches(stack) || !requestedItem.getDestination().equals((Object)this.m_58899_())) continue;
                    alreadyRequested += requestedItem.getAmountRemaining();
                }
                if (alreadyRequested >= stack.m_41613_()) continue;
                this.getNetwork().request(level, stack.m_255036_(stack.m_41613_() - alreadyRequested), this.m_58899_(), null, true);
            }
        }
    }

    public boolean isActiveStocking() {
        return this.activeStocking;
    }

    public void setActiveStocking(boolean activeStocking) {
        Level level;
        this.activeStocking = activeStocking;
        if (activeStocking && (level = this.m_58904_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.tryRequests(serverLevel);
        }
    }

    public boolean shouldMatchComponents() {
        return this.filter.shouldMatchComponents();
    }

    public List<ItemStack> getMissingItemsCache() {
        return this.missingItemsCache;
    }

    @Override
    public void m_142466_(CompoundTag valueInput) {
        this.filter.m_6211_();
        super.m_142466_(valueInput);
        ListTag filterList = valueInput.m_128437_("filter", 10);
        filterList.forEach(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                int slot = compoundTag.m_128451_("slot");
                MiscUtil.loadFromTag(tag, ItemStack.f_41582_, stack -> this.filter.m_6836_(slot, (ItemStack)stack));
            }
        });
        this.filter.setMatchComponents(valueInput.m_128471_("match_components"));
        this.activeStocking = valueInput.m_128471_("active_stocking");
    }

    @Override
    protected void m_183515_(CompoundTag valueOutput) {
        super.m_183515_(valueOutput);
        ListTag filterList = new ListTag();
        for (int slot = 0; slot < this.filter.m_6643_(); ++slot) {
            ItemStack stack = this.filter.m_8020_(slot);
            if (stack.m_41619_()) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("slot", slot);
            MiscUtil.saveToTag((Tag)tag, stack, ItemStack.f_41582_, arg_0 -> filterList.add(arg_0));
        }
        valueOutput.m_128365_("filter", (Tag)filterList);
        valueOutput.m_128379_("match_components", this.filter.shouldMatchComponents());
        valueOutput.m_128379_("active_stocking", this.activeStocking);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.classicpipes.stocking_pipe");
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new StockingPipeMenu(id, playerInventory, this.filter, this.activeStocking);
    }
}

