/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.MatchingPipeBlock;
import jagm.classicpipes.block.ProviderPipeBlock;
import jagm.classicpipes.blockentity.MatchingPipe;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.blockentity.ProviderPipe;
import jagm.classicpipes.inventory.menu.StoragePipeMenu;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StoragePipeEntity
extends NetworkedPipeEntity
implements MenuProvider,
ProviderPipe,
MatchingPipe {
    private boolean defaultRoute = false;
    private boolean matchComponents = false;
    private boolean leaveOne = false;
    private final List<ItemStack> cache = new ArrayList<ItemStack>();
    private boolean cacheInitialised = false;
    private final List<ItemStack> cannotFit = new ArrayList<ItemStack>();

    public StoragePipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.STORAGE_PIPE_ENTITY, pos, state);
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        if (!this.cacheInitialised && !((FacingOrNone)((Object)state.m_61143_((Property)MatchingPipeBlock.FACING))).equals((Object)FacingOrNone.NONE)) {
            this.updateCache(level, pos, ((FacingOrNone)((Object)state.m_61143_((Property)MatchingPipeBlock.FACING))).getDirection());
            this.cacheInitialised = true;
        }
        super.tickServer(level, pos, state);
    }

    @Override
    public void updateCache(ServerLevel level, BlockPos pos, Direction facing) {
        this.cache.clear();
        this.cannotFit.clear();
        List<ItemStack> stacks = Services.LOADER_SERVICE.getContainerItems(level, pos.m_121945_(facing), facing.m_122424_());
        Iterator<ItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = iterator.next();
            if (!this.shouldLeaveOne()) continue;
            stack.m_41774_(1);
            if (!stack.m_41619_()) continue;
            iterator.remove();
        }
        this.cache.addAll(stacks);
        if (this.hasNetwork()) {
            this.getNetwork().cacheUpdated();
        }
    }

    @Override
    public Direction getFacing() {
        return ((FacingOrNone)((Object)this.m_58900_().m_61143_((Property)ProviderPipeBlock.FACING))).getDirection();
    }

    @Override
    public boolean matches(ItemStack stack) {
        for (ItemStack cannotFitStack : this.cannotFit) {
            if (!ItemStack.m_150942_((ItemStack)cannotFitStack, (ItemStack)stack)) continue;
            return false;
        }
        for (ItemStack containerStack : this.cache) {
            if (!stack.m_150930_(containerStack.m_41720_()) || this.shouldMatchComponents() && !ItemStack.m_150942_((ItemStack)stack, (ItemStack)containerStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NetworkedPipeEntity getAsPipe() {
        return this;
    }

    @Override
    public void markCannotFit(ItemStack stack) {
        this.cannotFit.add(stack);
    }

    @Override
    public boolean isDefaultRoute() {
        return this.defaultRoute;
    }

    public void setDefaultRoute(boolean defaultRoute) {
        this.defaultRoute = defaultRoute;
        if (defaultRoute) {
            this.getNetwork().addPipe(this);
        } else {
            this.getNetwork().getDefaultRoutes().remove(this);
        }
    }

    public boolean shouldMatchComponents() {
        return this.matchComponents;
    }

    public void setMatchComponents(boolean matchComponents) {
        this.matchComponents = matchComponents;
    }

    public void setLeaveOne(boolean leaveOne) {
        this.leaveOne = leaveOne;
        Direction facing = ((FacingOrNone)((Object)this.m_58900_().m_61143_((Property)ProviderPipeBlock.FACING))).getDirection();
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (facing != null) {
                this.updateCache(serverLevel, this.m_58899_(), facing);
            }
        }
    }

    public boolean shouldLeaveOne() {
        return this.leaveOne;
    }

    @Override
    public void m_142466_(CompoundTag valueInput) {
        this.cacheInitialised = false;
        super.m_142466_(valueInput);
        this.defaultRoute = valueInput.m_128471_("default_route");
        this.matchComponents = valueInput.m_128471_("match_components");
        this.leaveOne = valueInput.m_128471_("leave_one");
    }

    @Override
    protected void m_183515_(CompoundTag valueOutput) {
        super.m_183515_(valueOutput);
        valueOutput.m_128379_("default_route", this.isDefaultRoute());
        valueOutput.m_128379_("match_components", this.shouldMatchComponents());
        valueOutput.m_128379_("leave_one", this.shouldLeaveOne());
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.classicpipes.storage_pipe");
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new StoragePipeMenu(id, inventory, this.isDefaultRoute(), this.shouldMatchComponents(), this.shouldLeaveOne(), this);
    }

    @Override
    public List<ItemStack> getCache() {
        return this.cache;
    }

    @Override
    public boolean extractItem(ServerLevel level, ItemStack stack) {
        Direction facing = ((FacingOrNone)((Object)this.m_58900_().m_61143_((Property)ProviderPipeBlock.FACING))).getDirection();
        if (facing != null) {
            boolean extracted = Services.LOADER_SERVICE.extractSpecificItem(this, level, this.m_58899_().m_121945_(facing), facing.m_122424_(), stack.m_41777_());
            this.updateCache(level, this.m_58899_(), facing);
            return extracted;
        }
        return false;
    }

    @Override
    public BlockPos getProviderPipePos() {
        return this.m_58899_();
    }
}

