/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.screen;

import jagm.classicpipes.client.screen.RequestAmountScreen;
import jagm.classicpipes.client.screen.widget.PageButton;
import jagm.classicpipes.inventory.menu.RequestMenu;
import jagm.classicpipes.network.ServerBoundRequestPayload;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.SortingMode;
import java.util.Iterator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class RequestScreen
extends AbstractContainerScreen<RequestMenu> {
    private static final ResourceLocation BACKGROUND = MiscUtil.resourceLocation("textures/gui/container/request.png");
    private static final ResourceLocation X_BUTTON = MiscUtil.resourceLocation("textures/gui/sprites/widget/x.png");
    private EditBox searchBar;
    private PageButton prev_page;
    private PageButton next_page;
    private Button sort_type;
    private Button sort_direction;
    private boolean refocus;

    public RequestScreen(RequestMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97727_ = 222;
        this.refocus = false;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchBar = new EditBox(this.f_96547_, this.f_97735_ + 21, this.f_97736_ + 22, 146, 12, (Component)Component.m_237115_((String)"container.classicpipes.search"));
        this.searchBar.m_94190_(true);
        this.searchBar.m_94199_(32);
        this.searchBar.m_94144_(((RequestMenu)this.f_97732_).getSearch());
        this.searchBar.m_94202_(-1);
        this.searchBar.m_94205_(-1);
        this.searchBar.m_94182_(false);
        this.searchBar.m_94151_(((RequestMenu)this.f_97732_)::setSearch);
        this.searchBar.m_94186_(true);
        this.prev_page = new PageButton(this.f_96543_ / 2 - 32 - 8, this.f_97736_ + 180, true, false, button -> this.changePage(-1));
        this.next_page = new PageButton(this.f_96543_ / 2 + 32, this.f_97736_ + 180, false, ((RequestMenu)this.f_97732_).getMaxPage() > 0, button -> this.changePage(1));
        this.sort_type = Button.m_253074_((Component)((RequestMenu)this.f_97732_).getSortingMode().getType(), this::changeSortType).m_252987_(this.f_96543_ / 2 - 25, this.f_97736_ + 198, 50, 16).m_253136_();
        this.sort_direction = Button.m_253074_((Component)((RequestMenu)this.f_97732_).getSortingMode().getDirection(), this::changeSortDirection).m_252987_(this.f_96543_ / 2 + 27, this.f_97736_ + 198, 50, 16).m_253136_();
        this.m_142416_((GuiEventListener)this.sort_type);
        this.m_142416_((GuiEventListener)this.sort_direction);
        this.m_142416_((GuiEventListener)this.searchBar);
        this.m_142416_((GuiEventListener)this.prev_page);
        this.m_142416_((GuiEventListener)this.next_page);
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + this.f_97726_ - 12, this.f_97736_ + 5, 7, 7, 0, 0, 7, X_BUTTON, 7, 7, button -> this.m_7379_()));
        this.m_264313_((GuiEventListener)this.searchBar);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.updatePageButtons();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)this.f_97735_, (float)this.f_97736_, 0.0f);
        this.f_97734_ = this.getHoveredSlot(mouseX, mouseY);
        this.renderSlots(graphics);
        if (this.f_97734_ != null && this.f_97734_.m_280329_()) {
            RequestScreen.m_280359_((GuiGraphics)graphics, (int)this.f_97734_.f_40220_, (int)this.f_97734_.f_40221_, (int)0);
        }
        graphics.m_280168_().m_85849_();
        this.m_280072_(graphics, mouseX, mouseY);
    }

    private Slot getHoveredSlot(double mouseX, double mouseY) {
        Slot slot;
        Iterator var5 = ((RequestMenu)this.f_97732_).displaySlots.iterator();
        do {
            if (var5.hasNext()) continue;
            return null;
        } while (!(slot = (Slot)var5.next()).m_6659_() || !this.m_6774_(slot.f_40220_, slot.f_40221_, 16, 16, mouseX, mouseY));
        return slot;
    }

    protected void renderSlots(GuiGraphics graphics) {
        for (Slot slot : ((RequestMenu)this.f_97732_).displaySlots) {
            if (!slot.m_6659_()) continue;
            this.m_280092_(graphics, slot);
        }
    }

    protected void m_7286_(GuiGraphics graphics, float f, int x, int y) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280163_(BACKGROUND, i, j, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, -12566464, false);
        MutableComponent pageIndicator = Component.m_237110_((String)"widget.classicpipes.page", (Object[])new Object[]{((RequestMenu)this.f_97732_).getPage() + 1, ((RequestMenu)this.f_97732_).getMaxPage() + 1});
        graphics.m_280614_(this.f_96547_, (Component)pageIndicator, (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)pageIndicator)) / 2, 182, -12566464, false);
        MutableComponent sortBy = Component.m_237115_((String)"widget.classicpipes.sort_by");
        graphics.m_280614_(this.f_96547_, (Component)sortBy, this.f_97726_ / 2 - 29 - this.f_96547_.m_92852_((FormattedText)sortBy), 202, -12566464, false);
    }

    private void m_280092_(GuiGraphics graphics, Slot slot) {
        ItemStack stack = slot.m_7993_();
        int seed = slot.f_40220_ + slot.f_40221_ * this.f_97726_;
        graphics.m_280256_(stack, slot.f_40220_, slot.f_40221_, seed);
        if (!stack.m_41619_()) {
            this.renderItemBar(graphics, stack, slot.f_40220_, slot.f_40221_);
            this.renderItemCount(graphics, this.f_96547_, stack, slot.f_40220_, slot.f_40221_, ((RequestMenu)this.f_97732_).itemCraftable(stack));
        }
    }

    private void renderItemBar(GuiGraphics graphics, ItemStack stack, int x, int y) {
        if (stack.m_150947_()) {
            int i = x + 2;
            int j = y + 13;
            graphics.m_285944_(RenderType.m_286086_(), i, j, i + 13, j + 2, -16777216);
            graphics.m_285944_(RenderType.m_286086_(), i, j, i + stack.m_150948_(), j + 1, stack.m_150949_() | 0xFF000000);
        }
    }

    private void renderItemCount(GuiGraphics graphics, Font font, ItemStack stack, int x, int y, boolean craftable) {
        int count = stack.m_41613_() - (craftable ? 1 : 0);
        String s = RequestScreen.stringForCount(count);
        int colour = RequestScreen.colourForCount(count);
        float countScale = 1.0f;
        if (this.f_96541_ != null) {
            int guiScale;
            int numerator = guiScale = (int)this.f_96541_.m_91268_().m_85449_();
            while ((float)font.m_92895_(s) * countScale > 16.0f && numerator > 1) {
                countScale = (float)(--numerator) / (float)guiScale;
            }
        }
        int slotOffset = countScale == 1.0f ? 17 : 16;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)(x + slotOffset), (float)(y + slotOffset), 200.0f);
        graphics.m_280168_().m_85841_(countScale, countScale, 1.0f);
        graphics.m_280056_(font, s, -font.m_92895_(s), -8, colour, true);
        graphics.m_280168_().m_85849_();
    }

    private static int colourForCount(int count) {
        return count == 0 ? -256 : -1;
    }

    private static String stringForCount(int count) {
        if (count == 0) {
            return "+";
        }
        if (count < 1000) {
            return String.valueOf(count);
        }
        if (count < 10000) {
            return String.format("%.1f", Float.valueOf((float)count / 1000.0f - 0.049f)) + "K";
        }
        if (count < 1000000) {
            return count / 1000 + "K";
        }
        if (count < 10000000) {
            return String.format("%.1f", Float.valueOf((float)count / 1000000.0f - 0.049f)) + "M";
        }
        if (count < 1000000000) {
            return count / 1000000 + "M";
        }
        if (count < Integer.MAX_VALUE) {
            return String.format("%.1f", Float.valueOf((float)count / 1.0E9f - 0.049f)) + "B";
        }
        return "MAX";
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        ItemStack toRequest;
        Slot slot = this.getHoveredSlot(mouseX, mouseY);
        if (slot != null && !(toRequest = slot.m_7993_()).m_41619_()) {
            boolean craftable = ((RequestMenu)this.f_97732_).itemCraftable(toRequest);
            if (RequestScreen.m_96638_() || button == 1) {
                int amount;
                int n = RequestScreen.m_96638_() ? Math.min(toRequest.m_41613_() - (craftable ? 1 : 0), toRequest.m_41741_()) : (amount = 1);
                if (amount > 0) {
                    Services.LOADER_SERVICE.sendToServer(new ServerBoundRequestPayload(toRequest.m_255036_(amount), ((RequestMenu)this.f_97732_).getRequestPos()));
                    toRequest.m_41774_(amount);
                    ((RequestMenu)this.f_97732_).update();
                }
            } else if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new RequestAmountScreen(toRequest, this, craftable));
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_6915_();
        }
        return this.searchBar.m_7933_(keyCode, scanCode, modifiers) || this.searchBar.m_94204_() || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        ((RequestMenu)this.f_97732_).changePage((int)(-delta));
        return true;
    }

    private void changePage(int increment) {
        ((RequestMenu)this.f_97732_).changePage(increment);
        this.refocus = true;
    }

    private void updatePageButtons() {
        this.prev_page.f_93623_ = ((RequestMenu)this.f_97732_).getPage() > 0;
        boolean bl = this.next_page.f_93623_ = ((RequestMenu)this.f_97732_).getPage() < ((RequestMenu)this.f_97732_).getMaxPage();
        if (this.refocus) {
            this.m_7522_((GuiEventListener)this.searchBar);
            this.refocus = false;
        }
    }

    private void changeSortType(Button button) {
        SortingMode nextMode = RequestScreen.m_96638_() ? ((RequestMenu)this.f_97732_).getSortingMode().prevType() : ((RequestMenu)this.f_97732_).getSortingMode().nextType();
        this.sort_type.m_93666_(nextMode.getType());
        this.sort_direction.m_93666_(nextMode.getDirection());
        ((RequestMenu)this.f_97732_).setSortingMode(nextMode);
        this.refocus = true;
    }

    private void changeSortDirection(Button button) {
        SortingMode nextMode = ((RequestMenu)this.f_97732_).getSortingMode().otherDirection();
        this.sort_type.m_93666_(nextMode.getType());
        this.sort_direction.m_93666_(nextMode.getDirection());
        ((RequestMenu)this.f_97732_).setSortingMode(nextMode);
        this.refocus = true;
    }
}

