/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.network;

import jagm.classicpipes.blockentity.RecipePipeEntity;
import jagm.classicpipes.network.PayloadWrapper;
import jagm.classicpipes.network.SelfHandler;
import jagm.classicpipes.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public record ServerBoundSlotDirectionPayload(BlockPos pos, int slot, Direction direction) implements PayloadWrapper<ServerBoundSlotDirectionPayload>
{
    public static final ResourceLocation TYPE = MiscUtil.resourceLocation("slot_direction");
    public static final SelfHandler<ServerBoundSlotDirectionPayload> HANDLER = new Handler();

    @Override
    public SelfHandler<ServerBoundSlotDirectionPayload> getHandler() {
        return HANDLER;
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    private static class Handler
    extends SelfHandler<ServerBoundSlotDirectionPayload> {
        private Handler() {
        }

        @Override
        public FriendlyByteBuf encode(ServerBoundSlotDirectionPayload payload, FriendlyByteBuf buffer) {
            buffer.m_130064_(payload.pos());
            buffer.writeInt(payload.slot());
            buffer.writeByte(payload.direction().m_122411_());
            return buffer;
        }

        @Override
        public ServerBoundSlotDirectionPayload decode(FriendlyByteBuf buffer) {
            BlockPos pos = buffer.m_130135_();
            int slot = buffer.readInt();
            Direction direction = Direction.m_122376_((int)buffer.readByte());
            return new ServerBoundSlotDirectionPayload(pos, slot, direction);
        }

        @Override
        public void handle(ServerBoundSlotDirectionPayload payload, Player player) {
            BlockEntity blockEntity = player.m_9236_().m_7702_(payload.pos());
            if (blockEntity instanceof RecipePipeEntity) {
                RecipePipeEntity craftingPipe = (RecipePipeEntity)blockEntity;
                craftingPipe.setSlotDirection(payload.slot(), payload.direction());
            }
        }
    }
}

