/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.network;

import jagm.classicpipes.inventory.menu.RecipePipeMenu;
import jagm.classicpipes.network.PayloadWrapper;
import jagm.classicpipes.network.SelfHandler;
import jagm.classicpipes.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public record ServerBoundTransferRecipePayload(List<ItemStack> recipe, List<Integer> slots) implements PayloadWrapper<ServerBoundTransferRecipePayload>
{
    public static final ResourceLocation TYPE = MiscUtil.resourceLocation("transfer_recipe");
    public static final SelfHandler<ServerBoundTransferRecipePayload> HANDLER = new Handler();

    @Override
    public SelfHandler<ServerBoundTransferRecipePayload> getHandler() {
        return HANDLER;
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    private static class Handler
    extends SelfHandler<ServerBoundTransferRecipePayload> {
        private Handler() {
        }

        @Override
        public FriendlyByteBuf encode(ServerBoundTransferRecipePayload payload, FriendlyByteBuf buffer) {
            buffer.m_236828_(payload.recipe(), MiscUtil::writeStackToBuffer);
            buffer.m_236828_(payload.slots(), FriendlyByteBuf::writeInt);
            return buffer;
        }

        @Override
        public ServerBoundTransferRecipePayload decode(FriendlyByteBuf buffer) {
            List recipe = (List)buffer.m_236838_(ArrayList::new, MiscUtil::readStackFromBuffer);
            List slots = (List)buffer.m_236838_(ArrayList::new, FriendlyByteBuf::readInt);
            return new ServerBoundTransferRecipePayload(recipe, slots);
        }

        @Override
        public void handle(ServerBoundTransferRecipePayload payload, Player player) {
            AbstractContainerMenu abstractContainerMenu;
            if (player != null && (abstractContainerMenu = player.f_36096_) instanceof RecipePipeMenu) {
                int i;
                RecipePipeMenu menu = (RecipePipeMenu)abstractContainerMenu;
                for (i = 0; i < 10; ++i) {
                    menu.m_38853_(i).m_5852_(ItemStack.f_41583_);
                }
                for (i = 0; i < payload.recipe().size(); ++i) {
                    menu.m_38853_(payload.slots().get(i)).m_5852_(payload.recipe().get(i));
                    menu.m_38853_(payload.slots().get(i)).m_6654_();
                }
            }
        }
    }
}

