/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.MatchingPipe;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.blockentity.ProviderPipe;
import jagm.classicpipes.blockentity.RecipePipeEntity;
import jagm.classicpipes.blockentity.RoutingPipeEntity;
import jagm.classicpipes.blockentity.StockingPipeEntity;
import jagm.classicpipes.inventory.menu.RequestMenu;
import jagm.classicpipes.network.ClientBoundItemListPayload;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.MissingItem;
import jagm.classicpipes.util.RequestedItem;
import jagm.classicpipes.util.SortingMode;
import jagm.classicpipes.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PipeNetwork {
    private static final byte DEFAULT_COOLDOWN = 40;
    private final BlockPos pos;
    private final Set<RoutingPipeEntity> routingPipes = new HashSet<RoutingPipeEntity>();
    private final Set<NetworkedPipeEntity> defaultRoutes = new HashSet<NetworkedPipeEntity>();
    private final Set<ProviderPipe> providerPipes = new LinkedHashSet<ProviderPipe>();
    private final Set<StockingPipeEntity> stockingPipes = new HashSet<StockingPipeEntity>();
    private final Set<MatchingPipe> matchingPipes = new HashSet<MatchingPipe>();
    private final Set<RecipePipeEntity> recipePipes = new HashSet<RecipePipeEntity>();
    private SortingMode sortingMode;
    private boolean cacheChanged;
    private byte cacheCooldown;
    private final List<RequestedItem> requestedItems;
    private final List<Tuple<ProviderPipe, RequestedItem>> queue;
    private final Map<ProviderPipe, List<ItemStack>> takenFromCache;
    private final List<ItemStack> spareItems;
    private final Set<Item> craftedItemsForAdvancement;

    public PipeNetwork(BlockPos pos, SortingMode sortingMode) {
        this.sortingMode = sortingMode;
        this.pos = pos;
        this.cacheChanged = false;
        this.cacheCooldown = 0;
        this.requestedItems = new ArrayList<RequestedItem>();
        this.queue = new ArrayList<Tuple<ProviderPipe, RequestedItem>>();
        this.takenFromCache = new HashMap<ProviderPipe, List<ItemStack>>();
        this.spareItems = new ArrayList<ItemStack>();
        this.craftedItemsForAdvancement = new HashSet<Item>();
    }

    public PipeNetwork(BlockPos pos) {
        this(pos, SortingMode.AMOUNT_DESCENDING);
    }

    private void enqueue(ItemStack stack, int amount, BlockPos requestPos, String playerName, ProviderPipe providerPipe) {
        RequestedItem requestedItem = new RequestedItem(stack.m_255036_(amount), requestPos, playerName);
        boolean matched = false;
        for (Tuple<ProviderPipe, RequestedItem> tuple : this.queue) {
            if (tuple.a() != providerPipe || !requestedItem.matches(tuple.b())) continue;
            matched = true;
            tuple.b().getStack().m_41769_(amount);
            break;
        }
        if (!matched) {
            this.queue.add(new Tuple<ProviderPipe, RequestedItem>(providerPipe, requestedItem));
        }
    }

    private MissingItem queueRequest(ItemStack stack, BlockPos requestPos, Player player, List<ItemStack> visited) {
        MissingItem missingItem = new MissingItem(stack.m_41777_());
        String playerName = player != null ? player.m_7755_().getString() : "";
        ListIterator<ItemStack> iterator = this.spareItems.listIterator();
        while (iterator.hasNext()) {
            ItemStack spareItem = (ItemStack)iterator.next();
            if (!ItemStack.m_150942_((ItemStack)spareItem, (ItemStack)stack)) continue;
            int amount = Math.min(spareItem.m_41613_(), missingItem.getCount());
            spareItem.m_41774_(amount);
            missingItem.shrink(amount);
            if (spareItem.m_41619_()) {
                iterator.remove();
            }
            this.enqueue(stack, amount, requestPos, playerName, null);
            break;
        }
        if (!missingItem.isEmpty()) {
            block1: for (ProviderPipe providerPipe : this.providerPipes) {
                if (missingItem.isEmpty()) break;
                ArrayList<ItemStack> alreadyTaken = this.takenFromCache.containsKey(providerPipe) ? this.takenFromCache.get(providerPipe) : new ArrayList<ItemStack>();
                for (ItemStack cacheStack : providerPipe.getCache()) {
                    int amount;
                    ItemStack takenStack;
                    if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)cacheStack)) continue;
                    int cacheCount = cacheStack.m_41613_();
                    int takenIndex = -1;
                    for (int i = 0; i < alreadyTaken.size(); ++i) {
                        takenStack = (ItemStack)alreadyTaken.get(i);
                        if (!ItemStack.m_150942_((ItemStack)cacheStack, (ItemStack)takenStack)) continue;
                        cacheCount -= takenStack.m_41613_();
                        takenIndex = i;
                        break;
                    }
                    if ((amount = Math.min(missingItem.getCount(), cacheCount)) <= 0) continue block1;
                    this.enqueue(stack, amount, requestPos, playerName, providerPipe);
                    missingItem.shrink(amount);
                    if (takenIndex >= 0) {
                        takenStack = (ItemStack)alreadyTaken.get(takenIndex);
                        alreadyTaken.set(takenIndex, takenStack.m_255036_(takenStack.m_41613_() + amount));
                    } else {
                        alreadyTaken.add(cacheStack.m_255036_(amount));
                    }
                    this.takenFromCache.put(providerPipe, alreadyTaken);
                    continue block1;
                }
            }
        }
        if (!missingItem.isEmpty()) {
            boolean foundCraftingPipe = false;
            for (RecipePipeEntity craftingPipe : this.recipePipes) {
                ItemStack result = craftingPipe.getResult();
                if (!ItemStack.m_150942_((ItemStack)result, (ItemStack)stack)) continue;
                if (foundCraftingPipe) {
                    if (player == null) break;
                    player.m_5661_((Component)Component.m_237110_((String)"chat.classicpipes.multiple_recipes", (Object[])new Object[]{stack.m_41720_().m_41466_()}).m_130940_(ChatFormatting.YELLOW), false);
                    break;
                }
                int requiredCrafts = missingItem.getCount() / result.m_41613_() + (missingItem.getCount() % result.m_41613_() != 0 ? 1 : 0);
                List<ItemStack> ingredients = craftingPipe.getIngredientsCollated();
                boolean canCraft = true;
                for (ItemStack ingredient : ingredients) {
                    boolean alreadyVisited = false;
                    for (ItemStack visitedStack : visited) {
                        if (!ItemStack.m_150942_((ItemStack)visitedStack, (ItemStack)ingredient)) continue;
                        alreadyVisited = true;
                        canCraft = false;
                        break;
                    }
                    if (alreadyVisited) continue;
                    ArrayList<ItemStack> visited2 = new ArrayList<ItemStack>(visited);
                    visited2.add(stack);
                    MissingItem missingForCraft = this.queueRequest(ingredient.m_255036_(ingredient.m_41613_() * requiredCrafts), craftingPipe.m_58899_(), player, visited2);
                    if (missingForCraft.isEmpty()) continue;
                    missingItem.addMissingIngredient(missingForCraft);
                    canCraft = false;
                }
                if (canCraft) {
                    int amount = Math.min(result.m_41613_() * requiredCrafts, missingItem.getCount());
                    missingItem.shrink(amount);
                    this.enqueue(stack, amount, requestPos, playerName, null);
                    if (result.m_41613_() * requiredCrafts > amount) {
                        int remaining = result.m_41613_() * requiredCrafts - amount;
                        boolean matched = false;
                        for (ItemStack spareItem : this.spareItems) {
                            if (!ItemStack.m_150942_((ItemStack)spareItem, (ItemStack)stack)) continue;
                            spareItem.m_41769_(remaining);
                            matched = true;
                            break;
                        }
                        if (!matched) {
                            this.spareItems.add(stack.m_255036_(remaining));
                        }
                    }
                    this.craftedItemsForAdvancement.add(result.m_41720_());
                }
                foundCraftingPipe = true;
            }
        }
        return missingItem;
    }

    public void request(ServerLevel level, ItemStack stack, BlockPos requestPos, Player player, boolean partialRequest) {
        block6: {
            MissingItem missingItem;
            block4: {
                block5: {
                    missingItem = this.queueRequest(stack.m_41777_(), requestPos, player, new ArrayList<ItemStack>());
                    if (!missingItem.isEmpty()) break block4;
                    boolean cancelled = false;
                    for (Tuple<ProviderPipe, RequestedItem> tuple2 : this.queue) {
                        this.addRequestedItem(tuple2.b());
                        if (tuple2.a() == null || tuple2.a().extractItem(level, tuple2.b().getStack())) continue;
                        cancelled = true;
                        if (partialRequest) break;
                        tuple2.b().sendMessage(level, (Component)Component.m_237110_((String)"chat.classicpipes.could_not_extract", (Object[])new Object[]{stack.m_41613_(), stack.m_41720_().m_41466_(), tuple2.a().getProviderPipePos().m_123344_()}).m_130940_(ChatFormatting.RED));
                        break;
                    }
                    if (!cancelled) break block5;
                    this.queue.forEach(tuple -> this.removeRequestedItem((RequestedItem)tuple.b()));
                    break block6;
                }
                if (player == null) break block6;
                ClassicPipes.REQUEST_ITEM_TRIGGER.trigger((ServerPlayer)player, stack, this.craftedItemsForAdvancement.size());
                player.m_5661_((Component)Component.m_237110_((String)"chat.classicpipes.requested", (Object[])new Object[]{stack.m_41613_(), stack.m_41720_().m_41466_()}).m_130940_(ChatFormatting.GREEN), false);
                break block6;
            }
            if (partialRequest && missingItem.getCount() < stack.m_41613_()) {
                this.resetForNewRequest();
                this.request(level, stack.m_255036_(stack.m_41613_() - missingItem.getCount()), requestPos, player, false);
                return;
            }
            if (player != null) {
                player.m_5661_((Component)Component.m_237110_((String)"chat.classicpipes.missing_item.a", (Object[])new Object[]{stack.m_41613_(), stack.m_41720_().m_41466_()}).m_130940_(ChatFormatting.RED), false);
                for (ItemStack missing : missingItem.getBaseItems(new ArrayList<ItemStack>())) {
                    player.m_5661_((Component)Component.m_237110_((String)"chat.classicpipes.missing_item.b", (Object[])new Object[]{missing.m_41613_(), missing.m_41720_().m_41466_()}).m_130940_(ChatFormatting.YELLOW), false);
                }
            }
        }
        this.resetForNewRequest();
    }

    private void resetForNewRequest() {
        this.queue.clear();
        this.takenFromCache.clear();
        this.spareItems.clear();
        this.craftedItemsForAdvancement.clear();
    }

    public void tick(ServerLevel level) {
        int pipeToUpdate = level.m_213780_().m_188503_(Math.max(100, this.providerPipes.size()));
        if (pipeToUpdate < this.providerPipes.size()) {
            int i = 0;
            for (ProviderPipe providerPipe : this.providerPipes) {
                if (i == pipeToUpdate) {
                    Direction facing = providerPipe.getFacing();
                    if (facing == null) break;
                    providerPipe.updateCache(level, providerPipe.getProviderPipePos(), facing);
                    break;
                }
                ++i;
            }
        }
        if (this.cacheChanged && this.cacheCooldown <= 0) {
            List playerList = level.m_8795_(player -> {
                RequestMenu menu;
                AbstractContainerMenu patt12488$temp = player.f_36096_;
                return patt12488$temp instanceof RequestMenu && (menu = (RequestMenu)patt12488$temp).getNetworkPos().equals((Object)this.getPos());
            });
            if (!playerList.isEmpty()) {
                ClientBoundItemListPayload toSend = this.requestItemList(this.pos);
                for (ServerPlayer player2 : playerList) {
                    Services.LOADER_SERVICE.sendToClient(player2, toSend);
                }
            }
            for (StockingPipeEntity stockingPipeEntity : this.stockingPipes) {
                if (!stockingPipeEntity.isActiveStocking()) continue;
                stockingPipeEntity.tryRequests(level);
            }
            this.cacheChanged = false;
            this.cacheCooldown = (byte)40;
        } else if (this.cacheCooldown > 0) {
            this.cacheCooldown = (byte)(this.cacheCooldown - 1);
        }
        this.getRequestedItems().removeIf(requestedItem -> {
            if (requestedItem.timedOut()) {
                requestedItem.sendMessage(level, (Component)Component.m_237110_((String)"chat.classicpipes.timed_out", (Object[])new Object[]{requestedItem.getAmountRemaining(), requestedItem.getStack().m_41720_().m_41466_()}).m_130940_(ChatFormatting.RED));
                for (RecipePipeEntity craftingPipe : this.recipePipes) {
                    if (!requestedItem.matches(craftingPipe.getResult())) continue;
                    craftingPipe.dropHeldItems(level, craftingPipe.m_58899_());
                }
                return true;
            }
            return false;
        });
    }

    public void resetRequests(ServerLevel level) {
        this.requestedItems.clear();
        for (RecipePipeEntity craftingPipe : this.recipePipes) {
            craftingPipe.dropHeldItems(level, craftingPipe.m_58899_());
        }
    }

    public Set<RoutingPipeEntity> getRoutingPipes() {
        return this.routingPipes;
    }

    public Set<NetworkedPipeEntity> getDefaultRoutes() {
        return this.defaultRoutes;
    }

    public Set<StockingPipeEntity> getStockingPipes() {
        return this.stockingPipes;
    }

    public Set<MatchingPipe> getMatchingPipes() {
        return this.matchingPipes;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void addPipe(NetworkedPipeEntity pipe) {
        if (pipe.isDefaultRoute()) {
            this.defaultRoutes.add(pipe);
        }
        if (pipe instanceof RoutingPipeEntity) {
            RoutingPipeEntity routingPipe = (RoutingPipeEntity)pipe;
            this.routingPipes.add(routingPipe);
        }
        if (pipe instanceof ProviderPipe) {
            ProviderPipe providerPipe = (ProviderPipe)((Object)pipe);
            this.providerPipes.add(providerPipe);
        }
        if (pipe instanceof StockingPipeEntity) {
            StockingPipeEntity stockingPipe = (StockingPipeEntity)pipe;
            this.stockingPipes.add(stockingPipe);
        }
        if (pipe instanceof MatchingPipe) {
            MatchingPipe matchingPipe = (MatchingPipe)((Object)pipe);
            this.matchingPipes.add(matchingPipe);
        }
        if (pipe instanceof RecipePipeEntity) {
            RecipePipeEntity recipePipe = (RecipePipeEntity)pipe;
            this.recipePipes.add(recipePipe);
        }
    }

    public void removePipe(ServerLevel level, NetworkedPipeEntity pipe) {
        if (pipe.isDefaultRoute()) {
            this.defaultRoutes.remove((Object)pipe);
        }
        if (pipe instanceof RoutingPipeEntity) {
            RoutingPipeEntity routingPipe = (RoutingPipeEntity)pipe;
            this.routingPipes.remove((Object)routingPipe);
        }
        if (pipe instanceof ProviderPipe) {
            ProviderPipe providerPipe = (ProviderPipe)((Object)pipe);
            this.providerPipes.remove(providerPipe);
        }
        if (pipe instanceof StockingPipeEntity) {
            StockingPipeEntity stockingPipe = (StockingPipeEntity)pipe;
            this.stockingPipes.remove((Object)stockingPipe);
        }
        if (pipe instanceof MatchingPipe) {
            MatchingPipe matchingPipe = (MatchingPipe)((Object)pipe);
            this.matchingPipes.remove(matchingPipe);
        }
        if (pipe instanceof RecipePipeEntity) {
            RecipePipeEntity recipePipe = (RecipePipeEntity)pipe;
            this.recipePipes.remove((Object)recipePipe);
        }
        this.requestedItems.removeIf(requestedItem -> {
            if (requestedItem.getDestination().equals((Object)pipe.m_58899_())) {
                requestedItem.sendMessage(level, (Component)Component.m_237110_((String)"chat.classicpipes.destination_removed", (Object[])new Object[]{requestedItem.getAmountRemaining(), requestedItem.getStack().m_41720_().m_41466_(), pipe.m_58899_().m_123344_()}).m_130940_(ChatFormatting.RED));
                return true;
            }
            return false;
        });
    }

    public ClientBoundItemListPayload requestItemList(BlockPos requestPos) {
        ArrayList<ItemStack> existingItems = new ArrayList<ItemStack>();
        for (ProviderPipe providerPipe : this.providerPipes) {
            for (ItemStack stack : providerPipe.getCache()) {
                boolean alreadyThere = false;
                for (ItemStack inStack : existingItems) {
                    if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)inStack)) continue;
                    inStack.m_41769_(stack.m_41613_());
                    if (inStack.m_41613_() < 0) {
                        inStack.m_41764_(Integer.MAX_VALUE);
                    }
                    alreadyThere = true;
                    break;
                }
                if (alreadyThere) continue;
                existingItems.add(stack.m_41777_());
            }
        }
        ArrayList<ItemStack> craftableItems = new ArrayList<ItemStack>();
        for (RecipePipeEntity recipePipe : this.recipePipes) {
            ItemStack result = recipePipe.getResult();
            if (result.m_41619_()) continue;
            boolean matched = false;
            for (ItemStack alreadyCraftable : craftableItems) {
                if (!ItemStack.m_150942_((ItemStack)alreadyCraftable, (ItemStack)result)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            craftableItems.add(result.m_255036_(1));
        }
        return new ClientBoundItemListPayload(existingItems, craftableItems, this.pos, requestPos, this.sortingMode);
    }

    public void cacheUpdated() {
        this.cacheChanged = true;
    }

    public void setSortingMode(SortingMode sortingMode) {
        this.sortingMode = sortingMode;
    }

    public SortingMode getSortingMode() {
        return this.sortingMode;
    }

    public List<RequestedItem> getRequestedItems() {
        return this.requestedItems;
    }

    public void removeRequestedItem(RequestedItem requestedItem) {
        this.requestedItems.remove(requestedItem);
    }

    public void addRequestedItem(RequestedItem requestedItem) {
        this.requestedItems.add(requestedItem);
    }
}

