/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.block;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.BooleanDirectionsPipeBlock;
import jagm.classicpipes.block.PipeBlock;
import jagm.classicpipes.blockentity.CopperPipeEntity;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import jagm.classicpipes.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;

public class CopperPipeBlock
extends BooleanDirectionsPipeBlock {
    public static final EnumProperty<FacingOrNone> FACING = FacingOrNone.BLOCK_PROPERTY;
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;

    public CopperPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)((Object)FacingOrNone.NONE))).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CopperPipeEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == ClassicPipes.COPPER_PIPE_ENTITY ? PipeEntity::tick : null;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, ENABLED});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState superState = super.getStateForPlacement(context);
        if (superState != null) {
            for (Direction direction : Direction.values()) {
                if (!this.isPipeConnected(superState, direction) || !Services.LOADER_SERVICE.canAccessContainer(context.getLevel(), context.getClickedPos().relative(direction), direction.getOpposite())) continue;
                return (BlockState)superState.trySetValue(FACING, (Comparable)((Object)FacingOrNone.with(direction)));
            }
            return (BlockState)superState.trySetValue(FACING, (Comparable)((Object)FacingOrNone.NONE));
        }
        return this.defaultBlockState();
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pipePos, Direction initialDirection, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        BlockState superState = super.updateShape(state, level, scheduledTickAccess, pipePos, initialDirection, neighborPos, neighborState, random);
        Direction direction = state.getValue(FACING) == FacingOrNone.NONE ? Direction.DOWN : ((FacingOrNone)((Object)state.getValue(FACING))).getDirection();
        for (int i = 0; i < 6; ++i) {
            if (this.isPipeConnected(superState, direction) && Services.LOADER_SERVICE.canAccessContainer((Level)level, pipePos.relative(direction), direction.getOpposite())) {
                return (BlockState)superState.setValue(FACING, (Comparable)((Object)FacingOrNone.with(direction)));
            }
            direction = MiscUtil.nextDirection(direction);
        }
        return (BlockState)superState.setValue(FACING, (Comparable)((Object)FacingOrNone.NONE));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pipePos, Player player, BlockHitResult hitResult) {
        if (player.getAbilities().mayBuild && !MiscUtil.itemIsPipe(player.getMainHandItem()) && state.getValue(FACING) != FacingOrNone.NONE) {
            Direction direction = MiscUtil.nextDirection(((FacingOrNone)((Object)state.getValue(FACING))).getDirection());
            for (int i = 0; i < 5; ++i) {
                if (this.isPipeConnected(state, direction) && Services.LOADER_SERVICE.canAccessContainer(level, pipePos.relative(direction), direction.getOpposite())) {
                    level.setBlock(pipePos, (BlockState)state.setValue(FACING, (Comparable)((Object)FacingOrNone.with(direction))), 3);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.playSound(null, pipePos, ClassicPipes.PIPE_ADJUST_SOUND, SoundSource.BLOCKS);
                    }
                    return InteractionResult.SUCCESS;
                }
                direction = MiscUtil.nextDirection(direction);
            }
        }
        return InteractionResult.PASS;
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock())) {
            this.checkPoweredState(level, pos, state);
        }
    }

    private void checkPoweredState(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)ENABLED)).booleanValue() && !level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false)), 2);
        } else if (!((Boolean)state.getValue((Property)ENABLED)).booleanValue() && level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, Orientation orientation, boolean b) {
        this.checkPoweredState(level, pos, state);
    }

    @Override
    protected boolean canConnectToPipe(PipeBlock pipeBlock) {
        return !(pipeBlock instanceof CopperPipeBlock);
    }
}

