/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.block;

import jagm.classicpipes.block.BooleanDirectionsPipeBlock;
import jagm.classicpipes.block.PipeBlock;
import jagm.classicpipes.services.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public abstract class FluidPipeBlock
extends BooleanDirectionsPipeBlock {
    public FluidPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected boolean canConnect(Level level, BlockPos pipePos, Direction direction) {
        BlockPos neighbourPos = pipePos.relative(direction);
        Block block = level.getBlockState(neighbourPos).getBlock();
        if (block instanceof PipeBlock) {
            PipeBlock pipeBlock = (PipeBlock)block;
            return FluidPipeBlock.canConnectToPipeBothWays(this, pipeBlock);
        }
        return Services.LOADER_SERVICE.canAccessFluidContainer(level, neighbourPos, direction.getOpposite());
    }

    @Override
    protected boolean canConnectToPipe(PipeBlock pipeBlock) {
        return pipeBlock instanceof FluidPipeBlock;
    }
}

