/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.PipeBlock;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.blockentity.RequestPipeEntity;
import jagm.classicpipes.blockentity.RoutingPipeEntity;
import jagm.classicpipes.inventory.menu.RequestMenu;
import jagm.classicpipes.network.ClientBoundItemListPayload;
import jagm.classicpipes.network.ClientBoundTwoBoolsPayload;
import jagm.classicpipes.services.Services;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class NetworkedPipeBlock
extends PipeBlock {
    public static final EnumProperty<ConnectionState> NORTH = EnumProperty.create((String)"north", ConnectionState.class, (Enum[])ConnectionState.values());
    public static final EnumProperty<ConnectionState> EAST = EnumProperty.create((String)"east", ConnectionState.class, (Enum[])ConnectionState.values());
    public static final EnumProperty<ConnectionState> SOUTH = EnumProperty.create((String)"south", ConnectionState.class, (Enum[])ConnectionState.values());
    public static final EnumProperty<ConnectionState> WEST = EnumProperty.create((String)"west", ConnectionState.class, (Enum[])ConnectionState.values());
    public static final EnumProperty<ConnectionState> UP = EnumProperty.create((String)"up", ConnectionState.class, (Enum[])ConnectionState.values());
    public static final EnumProperty<ConnectionState> DOWN = EnumProperty.create((String)"down", ConnectionState.class, (Enum[])ConnectionState.values());
    public static final Map<Direction, EnumProperty<ConnectionState>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(Direction.NORTH, NORTH, Direction.EAST, EAST, Direction.SOUTH, SOUTH, Direction.WEST, WEST, Direction.UP, UP, Direction.DOWN, DOWN)));

    public NetworkedPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH, (Comparable)((Object)ConnectionState.NONE))).setValue(EAST, (Comparable)((Object)ConnectionState.NONE))).setValue(SOUTH, (Comparable)((Object)ConnectionState.NONE))).setValue(WEST, (Comparable)((Object)ConnectionState.NONE))).setValue(UP, (Comparable)((Object)ConnectionState.NONE))).setValue(DOWN, (Comparable)((Object)ConnectionState.NONE)));
    }

    @Override
    public boolean isPipeConnected(BlockState state, Direction direction) {
        return !((ConnectionState)((Object)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction)))).equals((Object)ConnectionState.NONE);
    }

    @Override
    public BlockState setPipeConnected(BlockState state, Direction direction, boolean connected) {
        return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)((Object)(connected ? (this.isLinked(state, direction) ? ConnectionState.LINKED : ConnectionState.UNLINKED) : ConnectionState.NONE)));
    }

    public boolean isLinked(BlockState state, Direction direction) {
        return ((ConnectionState)((Object)state.getValue((Property)PROPERTY_BY_DIRECTION.get(direction)))).equals((Object)ConnectionState.LINKED);
    }

    public BlockState setLinked(BlockState state, Direction direction, boolean linked) {
        return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)((Object)(linked ? ConnectionState.LINKED : ConnectionState.UNLINKED)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RoutingPipeEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == ClassicPipes.ROUTING_PIPE_ENTITY ? PipeEntity::tick : null;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState superState = super.getStateForPlacement(context);
        if (superState != null) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)superState.trySetValue(NORTH, (Comparable)((Object)(this.canConnect(context.getLevel(), context.getClickedPos(), Direction.NORTH) ? ConnectionState.UNLINKED : ConnectionState.NONE)))).trySetValue(EAST, (Comparable)((Object)(this.canConnect(context.getLevel(), context.getClickedPos(), Direction.EAST) ? ConnectionState.UNLINKED : ConnectionState.NONE)))).trySetValue(SOUTH, (Comparable)((Object)(this.canConnect(context.getLevel(), context.getClickedPos(), Direction.SOUTH) ? ConnectionState.UNLINKED : ConnectionState.NONE)))).trySetValue(WEST, (Comparable)((Object)(this.canConnect(context.getLevel(), context.getClickedPos(), Direction.WEST) ? ConnectionState.UNLINKED : ConnectionState.NONE)))).trySetValue(UP, (Comparable)((Object)(this.canConnect(context.getLevel(), context.getClickedPos(), Direction.UP) ? ConnectionState.UNLINKED : ConnectionState.NONE)))).trySetValue(DOWN, (Comparable)((Object)(this.canConnect(context.getLevel(), context.getClickedPos(), Direction.DOWN) ? ConnectionState.UNLINKED : ConnectionState.NONE)));
        }
        return this.defaultBlockState();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (level instanceof ServerLevel && (blockEntity = level.getBlockEntity(pos)) instanceof RoutingPipeEntity) {
            RoutingPipeEntity routingPipe = (RoutingPipeEntity)blockEntity;
            Services.LOADER_SERVICE.openMenu((ServerPlayer)player, routingPipe, new ClientBoundTwoBoolsPayload(routingPipe.shouldMatchComponents(), routingPipe.isDefaultRoute()), ClientBoundTwoBoolsPayload.STREAM_CODEC);
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem().equals(ClassicPipes.PIPE_SLICER) && player instanceof ServerPlayer) {
            NetworkedPipeEntity networkedPipe;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof NetworkedPipeEntity && (networkedPipe = (NetworkedPipeEntity)blockEntity).hasNetwork()) {
                final ClientBoundItemListPayload payload = networkedPipe.getNetwork().requestItemList(pos);
                Services.LOADER_SERVICE.openMenu(serverPlayer, new MenuProvider(){

                    public Component getDisplayName() {
                        return RequestPipeEntity.TITLE;
                    }

                    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                        return new RequestMenu(id, inventory, payload);
                    }
                }, payload, ClientBoundItemListPayload.STREAM_CODEC);
                player.awardStat(Stats.ITEM_USED.get((Object)ClassicPipes.PIPE_SLICER));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    public static enum ConnectionState implements StringRepresentable
    {
        NONE,
        UNLINKED,
        LINKED;


        public String getSerializedName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "none";
                case 1 -> "unlinked";
                case 2 -> "linked";
            };
        }
    }
}

