/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.block;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.NetworkedPipeBlock;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.blockentity.RecipePipeEntity;
import jagm.classicpipes.network.ClientBoundRecipePipePayload;
import jagm.classicpipes.services.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class RecipePipeBlock
extends NetworkedPipeBlock {
    public RecipePipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RecipePipeEntity(pos, state);
    }

    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == ClassicPipes.RECIPE_PIPE_ENTITY ? PipeEntity::tick : null;
    }

    @Override
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        ServerLevel serverLevel;
        BlockEntity blockEntity;
        if (level instanceof ServerLevel && (blockEntity = (serverLevel = (ServerLevel)level).getBlockEntity(pos)) instanceof RecipePipeEntity) {
            RecipePipeEntity craftingPipe = (RecipePipeEntity)blockEntity;
            craftingPipe.dropHeldItems(serverLevel, pos);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (level instanceof ServerLevel && (blockEntity = level.getBlockEntity(pos)) instanceof RecipePipeEntity) {
            RecipePipeEntity craftingPipe = (RecipePipeEntity)blockEntity;
            Services.LOADER_SERVICE.openMenu((ServerPlayer)player, craftingPipe, new ClientBoundRecipePipePayload(craftingPipe.getSlotDirections(), craftingPipe.getDirectionsForButtons(state), pos), ClientBoundRecipePipePayload.STREAM_CODEC);
        }
        return InteractionResult.SUCCESS;
    }
}

