/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.CopperPipeBlock;
import jagm.classicpipes.blockentity.RoundRobinPipeEntity;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class CopperPipeEntity
extends RoundRobinPipeEntity {
    private static final byte DEFAULT_COOLDOWN = 8;
    private byte cooldown = (byte)8;

    public CopperPipeEntity(BlockPos pos, BlockState state) {
        this(ClassicPipes.COPPER_PIPE_ENTITY, pos, state);
    }

    public CopperPipeEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        super.tickServer(level, pos, state);
        if (((Boolean)state.getValue((Property)CopperPipeBlock.ENABLED)).booleanValue() && state.getValue(CopperPipeBlock.FACING) != FacingOrNone.NONE) {
            byte by = this.cooldown;
            this.cooldown = (byte)(by - 1);
            if (by <= 0) {
                Direction direction = ((FacingOrNone)((Object)state.getValue(CopperPipeBlock.FACING))).getDirection();
                if (Services.LOADER_SERVICE.handleItemExtraction(this, state, level, pos.relative(direction), direction.getOpposite(), this.extractAmount(), this.filterPredicate())) {
                    level.sendBlockUpdated(pos, state, state, 2);
                    this.setChanged();
                }
                this.cooldown = (byte)8;
            }
        }
    }

    protected int extractAmount() {
        return 1;
    }

    protected Predicate<ItemStack> filterPredicate() {
        return stack -> true;
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.cooldown = valueInput.getByteOr("cooldown", (byte)8);
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.putByte("cooldown", this.cooldown);
    }
}

