/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.inventory.container.DirectionalFilterContainer;
import jagm.classicpipes.inventory.menu.DiamondFluidPipeMenu;
import jagm.classicpipes.util.FluidInPipe;
import jagm.classicpipes.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class DiamondFluidPipeEntity
extends FluidPipeEntity
implements MenuProvider {
    private final DirectionalFilterContainer filter = new DirectionalFilterContainer(this, false);

    public DiamondFluidPipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.DIAMOND_FLUID_PIPE_ENTITY, pos, state);
    }

    @Override
    protected List<Direction> getValidDirections(BlockState state, FluidInPipe fluidPacket) {
        int i;
        ArrayList<Direction> validDirections = new ArrayList<Direction>();
        Direction direction = MiscUtil.nextDirection(fluidPacket.getFromDirection());
        ItemStack bucket = new ItemStack((ItemLike)this.getFluid().getBucket());
        for (i = 0; i < 5; ++i) {
            if (this.isPipeConnected(state, direction) && this.filter.directionMatches(bucket, direction)) {
                validDirections.add(direction);
            }
            direction = MiscUtil.nextDirection(direction);
        }
        if (validDirections.isEmpty() && this.filter.directionMatches(bucket, direction)) {
            validDirections.add(fluidPacket.getFromDirection());
        }
        if (validDirections.isEmpty()) {
            direction = MiscUtil.nextDirection(fluidPacket.getFromDirection());
            for (i = 0; i < 5; ++i) {
                if (this.isPipeConnected(state, direction) && this.filter.directionEmpty(direction)) {
                    validDirections.add(direction);
                }
                direction = MiscUtil.nextDirection(direction);
            }
        }
        if (validDirections.isEmpty() && this.filter.directionEmpty(fluidPacket.getFromDirection())) {
            validDirections.add(fluidPacket.getFromDirection());
        }
        return validDirections;
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        this.filter.clearContent();
        super.loadAdditional(valueInput);
        ValueInput.TypedInputList filterList = valueInput.listOrEmpty("filter", ItemStackWithSlot.CODEC);
        for (ItemStackWithSlot slotStack : filterList) {
            this.filter.setItem(slotStack.slot(), slotStack.stack());
        }
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ValueOutput.TypedOutputList filterList = valueOutput.list("filter", ItemStackWithSlot.CODEC);
        for (int slot = 0; slot < this.filter.getContainerSize(); ++slot) {
            ItemStack stack = this.filter.getItem(slot);
            if (stack.isEmpty()) continue;
            filterList.add((Object)new ItemStackWithSlot(slot, stack));
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.classicpipes.diamond_fluid_pipe");
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new DiamondFluidPipeMenu(id, playerInventory, this.filter);
    }
}

