/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import com.mojang.serialization.Codec;
import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.NetworkedPipeBlock;
import jagm.classicpipes.block.RecipePipeBlock;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.inventory.container.FilterContainer;
import jagm.classicpipes.inventory.menu.RecipePipeMenu;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.RequestedItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class RecipePipeEntity
extends NetworkedPipeEntity
implements MenuProvider {
    private static final byte DEFAULT_COOLDOWN = 8;
    private final FilterContainer filter = new FilterContainer(this, 10, true);
    private final Direction[] slotDirections = new Direction[10];
    private final NonNullList<ItemStack> heldItems;
    private int waitingForCraft;
    private boolean crafterTicked;
    private byte cooldown;

    public RecipePipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.RECIPE_PIPE_ENTITY, pos, state);
        List<Direction> buttonDirections = this.getDirectionsForButtons(state);
        Arrays.fill(this.slotDirections, buttonDirections.isEmpty() ? Direction.DOWN : buttonDirections.getFirst());
        this.heldItems = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    }

    public Direction[] getSlotDirections() {
        return this.slotDirections;
    }

    public void setSlotDirection(int slot, Direction direction) {
        this.slotDirections[slot] = direction;
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        super.tickServer(level, pos, state);
        BlockPos crafterPos = pos.relative(this.slotDirections[9]);
        if (this.crafterTicked && this.hasNetwork()) {
            for (RequestedItem requestedItem : this.getNetwork().getRequestedItems()) {
                if (!requestedItem.matches(this.getResult())) continue;
                requestedItem.sendMessage(level, (Component)Component.translatable((String)"chat.classicpipes.crafter_jammed", (Object[])new Object[]{crafterPos.toShortString()}).withStyle(ChatFormatting.RED));
            }
            this.getNetwork().resetRequests(level);
            this.crafterTicked = false;
            this.waitingForCraft = 0;
            this.setChanged();
            level.sendBlockUpdated(pos, state, state, 2);
        } else if (this.waitingForCraft > 0) {
            BlockEntity container = level.getBlockEntity(crafterPos);
            if (container instanceof CrafterBlockEntity) {
                CrafterBlockEntity crafter = (CrafterBlockEntity)container;
                if (this.isEmpty()) {
                    level.scheduleTick(crafterPos, crafter.getBlockState().getBlock(), 0);
                    level.playSound(null, crafterPos, SoundEvents.CRAFTER_CRAFT, SoundSource.BLOCKS);
                    this.crafterTicked = true;
                }
            } else {
                byte by = this.cooldown;
                this.cooldown = (byte)(by - 1);
                if (by <= 0) {
                    if (!(container instanceof ItemPipeEntity) && Services.LOADER_SERVICE.extractSpecificItem(this, level, crafterPos, this.slotDirections[9].getOpposite(), this.getResult().copyWithCount(1))) {
                        level.sendBlockUpdated(pos, state, state, 2);
                        this.setChanged();
                    }
                    this.cooldown = (byte)8;
                }
            }
        } else if (!this.queued.isEmpty()) {
            this.addQueuedItems((Level)level, false);
        }
    }

    @Override
    public void update(ServerLevel level, BlockState state, BlockPos pos, Direction direction, boolean wasConnected) {
        super.update(level, state, pos, direction, wasConnected);
        this.checkSlotDirections();
    }

    @Override
    protected void initialiseNetworking(ServerLevel level, BlockState state, BlockPos pos) {
        super.initialiseNetworking(level, state, pos);
        this.checkSlotDirections();
    }

    private void checkSlotDirections() {
        List<Direction> buttonDirections = this.getDirectionsForButtons(this.getBlockState());
        if (!buttonDirections.isEmpty()) {
            for (int i = 0; i < this.slotDirections.length; ++i) {
                if (buttonDirections.contains(this.slotDirections[i])) continue;
                this.slotDirections[i] = buttonDirections.getFirst();
                this.setChanged();
            }
        }
    }

    @Override
    public void eject(ServerLevel level, BlockPos pos, ItemInPipe item) {
        ArrayList<Integer> matchingSlots = new ArrayList<Integer>();
        for (int slot = 0; slot < 9; ++slot) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)this.filter.getItem(slot), (ItemStack)item.getStack())) continue;
            matchingSlots.add(slot);
        }
        if (!matchingSlots.isEmpty()) {
            ItemStack stack = item.getStack().copy();
            while (!stack.isEmpty()) {
                int minSlot = (Integer)matchingSlots.getFirst();
                int minAmount = ((ItemStack)this.heldItems.get(minSlot)).getCount();
                Iterator iterator = matchingSlots.iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    int slotAmount = ((ItemStack)this.heldItems.get(slot)).getCount();
                    if (slotAmount >= minAmount) continue;
                    minSlot = slot;
                    minAmount = slotAmount;
                }
                this.heldItems.set(minSlot, (Object)stack.copyWithCount(((ItemStack)this.heldItems.get(minSlot)).getCount() + 1));
                stack.shrink(1);
            }
        } else {
            super.eject(level, pos, item);
        }
        this.attemptCraft();
        this.setChanged();
    }

    private void attemptCraft() {
        if (this.waitingForCraft == 0) {
            boolean readyToCraft = true;
            for (int slot = 0; slot < 9; ++slot) {
                if (((ItemStack)this.heldItems.get(slot)).getCount() < this.filter.getItem(slot).getCount()) {
                    readyToCraft = false;
                    break;
                }
                BlockState state = this.getBlockState();
                if (this.filter.getItem(slot).isEmpty() || ((NetworkedPipeBlock.ConnectionState)((Object)state.getValue((Property)RecipePipeBlock.PROPERTY_BY_DIRECTION.get(this.slotDirections[slot])))).equals((Object)NetworkedPipeBlock.ConnectionState.UNLINKED)) continue;
                readyToCraft = false;
                Level level = this.getLevel();
                if (!(level instanceof ServerLevel)) break;
                ServerLevel serverLevel = (ServerLevel)level;
                if (!this.hasNetwork()) break;
                for (RequestedItem requestedItem : this.getNetwork().getRequestedItems()) {
                    if (!requestedItem.matches(this.getResult())) continue;
                    requestedItem.sendMessage(serverLevel, (Component)Component.translatable((String)"chat.classicpipes.missing_recipe_pipe_direction", (Object[])new Object[]{this.getBlockPos().toShortString()}).withStyle(ChatFormatting.RED));
                }
                this.crafterTicked = false;
                this.waitingForCraft = 0;
                this.getNetwork().resetRequests(serverLevel);
                this.setChanged();
                serverLevel.sendBlockUpdated(this.getBlockPos(), state, state, 2);
                break;
            }
            if (readyToCraft) {
                HashMap<Direction, CrafterBlockEntity> crafters = new HashMap<Direction, CrafterBlockEntity>();
                for (int slot = 0; slot < 9; ++slot) {
                    BlockEntity blockEntity;
                    ItemStack ingredient = this.filter.getItem(slot);
                    if (crafters.containsKey(this.slotDirections[slot])) {
                        ((CrafterBlockEntity)crafters.get(this.slotDirections[slot])).setSlotState(slot, !ingredient.isEmpty());
                    } else if (this.getLevel() != null && (blockEntity = this.getLevel().getBlockEntity(this.getBlockPos().relative(this.slotDirections[slot]))) instanceof CrafterBlockEntity) {
                        CrafterBlockEntity crafter = (CrafterBlockEntity)blockEntity;
                        crafters.put(this.slotDirections[slot], crafter);
                        crafter.setSlotState(slot, !ingredient.isEmpty());
                    }
                    if (ingredient.isEmpty()) continue;
                    ((ItemStack)this.heldItems.get(slot)).shrink(ingredient.getCount());
                    this.queued.add(new ItemInPipe(ingredient.copy(), 64, 1024, Direction.DOWN, this.slotDirections[slot], false, 0));
                }
                this.waitingForCraft = this.getResult().getCount();
            }
        }
    }

    public ItemStack getResult() {
        return this.filter.getItem(9).copy();
    }

    public List<ItemStack> getIngredients() {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            ItemStack ingredient = this.filter.getItem(i).copy();
            if (ingredient.isEmpty()) continue;
            ingredients.add(ingredient);
        }
        return ingredients;
    }

    public List<ItemStack> getIngredientsCollated() {
        List<ItemStack> ingredients = this.getIngredients();
        ArrayList<ItemStack> collated = new ArrayList<ItemStack>();
        for (ItemStack ingredient : ingredients) {
            boolean matched = false;
            for (ItemStack stack : collated) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)ingredient, (ItemStack)stack)) continue;
                stack.grow(ingredient.getCount());
                matched = true;
                break;
            }
            if (matched) continue;
            collated.add(ingredient);
        }
        return collated;
    }

    public NonNullList<ItemStack> getHeldItems() {
        return this.heldItems;
    }

    public void dropHeldItems(ServerLevel serverLevel, BlockPos pos) {
        for (ItemStack stack : this.heldItems) {
            if (stack.isEmpty()) continue;
            ItemEntity droppedItem = new ItemEntity((Level)serverLevel, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), stack);
            droppedItem.setDefaultPickUpDelay();
            serverLevel.addFreshEntity((Entity)droppedItem);
        }
        this.heldItems.clear();
    }

    @Override
    public void disconnect(ServerLevel level) {
        this.dropHeldItems(level, this.getBlockPos());
        super.disconnect(level);
    }

    @Override
    public void setRemoved() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            super.disconnect(serverLevel);
        }
        this.remove = true;
    }

    @Override
    public void insertPipeItem(Level level, ItemInPipe item) {
        ItemStack stack = item.getStack();
        if (!stack.isEmpty() && this.waitingForCraft > 0 && item.getFromDirection().equals((Object)this.slotDirections[9]) && ItemStack.isSameItemSameComponents((ItemStack)this.getResult(), (ItemStack)stack)) {
            this.waitingForCraft -= stack.getCount();
            if (this.waitingForCraft <= 0) {
                this.waitingForCraft = 0;
                this.crafterTicked = false;
                this.attemptCraft();
            }
        }
        super.insertPipeItem(level, item);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.classicpipes.recipe_pipe");
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new RecipePipeMenu(id, playerInventory, this.filter, this.slotDirections, this.getDirectionsForButtons(this.getBlockState()), this.getBlockPos());
    }

    public List<Direction> getDirectionsForButtons(BlockState state) {
        ArrayList<Direction> availableDirections = new ArrayList<Direction>();
        for (Direction direction : Direction.values()) {
            if (!((NetworkedPipeBlock.ConnectionState)((Object)state.getValue((Property)NetworkedPipeBlock.PROPERTY_BY_DIRECTION.get(direction)))).equals((Object)NetworkedPipeBlock.ConnectionState.UNLINKED)) continue;
            availableDirections.add(direction);
        }
        return availableDirections;
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        this.filter.clearContent();
        this.heldItems.clear();
        super.loadAdditional(valueInput);
        ValueInput.TypedInputList directionsByteList = valueInput.listOrEmpty("slot_directions", (Codec)Codec.BYTE);
        int i = 0;
        Iterator iterator = directionsByteList.iterator();
        while (iterator.hasNext()) {
            byte directionByte = (Byte)iterator.next();
            if (i >= 10) break;
            this.slotDirections[i] = Direction.from3DDataValue((int)directionByte);
            ++i;
        }
        ValueInput.TypedInputList filterList = valueInput.listOrEmpty("filter", ItemStackWithSlot.CODEC);
        for (ItemStackWithSlot slotStack : filterList) {
            this.filter.setItem(slotStack.slot(), slotStack.stack());
        }
        ValueInput.TypedInputList heldItemList = valueInput.listOrEmpty("held_items", ItemStackWithSlot.CODEC);
        for (ItemStackWithSlot slotStack : heldItemList) {
            if (slotStack.slot() < 0 || slotStack.slot() >= 9) continue;
            this.heldItems.set(slotStack.slot(), (Object)slotStack.stack());
        }
        this.waitingForCraft = valueInput.getIntOr("waiting_for_craft", 0);
        this.crafterTicked = valueInput.getBooleanOr("crafter_ticked", false);
        this.cooldown = valueInput.getByteOr("cooldown", (byte)8);
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ValueOutput.TypedOutputList directionsByteList = valueOutput.list("slot_directions", (Codec)Codec.BYTE);
        for (Direction direction : this.slotDirections) {
            directionsByteList.add((Object)(direction == null ? (byte)0 : (byte)direction.get3DDataValue()));
        }
        ValueOutput.TypedOutputList filterList = valueOutput.list("filter", ItemStackWithSlot.CODEC);
        for (int slot = 0; slot < this.filter.getContainerSize(); ++slot) {
            ItemStack stack = this.filter.getItem(slot);
            if (stack.isEmpty()) continue;
            filterList.add((Object)new ItemStackWithSlot(slot, stack));
        }
        ValueOutput.TypedOutputList heldItemList = valueOutput.list("held_items", ItemStackWithSlot.CODEC);
        for (int slot = 0; slot < this.heldItems.size(); ++slot) {
            ItemStack stack = (ItemStack)this.heldItems.get(slot);
            if (stack.isEmpty()) continue;
            heldItemList.add((Object)new ItemStackWithSlot(slot, stack));
        }
        valueOutput.putInt("waiting_for_craft", this.waitingForCraft);
        valueOutput.putBoolean("crafter_ticked", this.crafterTicked);
        valueOutput.putByte("cooldown", this.cooldown);
    }
}

