/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import jagm.classicpipes.block.FluidPipeBlock;
import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.client.renderer.FluidRenderInfo;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FluidInPipe;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class FluidPipeRenderer
implements BlockEntityRenderer<FluidPipeEntity> {
    private final BlockEntityRendererProvider.Context context;
    private final Map<FluidPipeEntity, Float> lastWidths;

    public FluidPipeRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
        this.lastWidths = new HashMap<FluidPipeEntity, Float>();
    }

    public boolean shouldRender(FluidPipeEntity pipe, Vec3 cameraPos) {
        boolean ret = Vec3.atCenterOf((Vec3i)pipe.getBlockPos()).closerThan((Position)cameraPos, (double)this.getViewDistance());
        if (!ret) {
            this.lastWidths.remove((Object)pipe);
        }
        return ret;
    }

    public void render(FluidPipeEntity pipe, float partialTicks, PoseStack poses, MultiBufferSource bufferSource, int light, int overlay, Vec3 cameraPos) {
        if (!this.lastWidths.containsKey((Object)pipe)) {
            this.lastWidths.put(pipe, Float.valueOf(0.0f));
        }
        poses.pushPose();
        Matrix4f matrix = poses.last().pose();
        FluidRenderInfo info = Services.LOADER_SERVICE.getFluidRenderInfo(pipe.getFluid().defaultFluidState(), (BlockAndTintGetter)pipe.getLevel(), pipe.getBlockPos());
        TextureAtlasSprite fluidSprite = info.sprite();
        if (fluidSprite == null) {
            fluidSprite = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getParticleIcon(Blocks.WATER.defaultBlockState());
        }
        VertexConsumer vertexBuffer = bufferSource.getBuffer(RenderType.text((ResourceLocation)fluidSprite.atlasLocation()));
        boolean[] middleSides = new boolean[6];
        Arrays.fill(middleSides, true);
        int totalAmount = 0;
        for (FluidInPipe fluidPacket : pipe.getContents()) {
            totalAmount += fluidPacket.getAmount();
            middleSides[fluidPacket.getFromDirection().get3DDataValue()] = false;
            middleSides[fluidPacket.getTargetDirection().get3DDataValue()] = false;
        }
        float targetWidth = Math.min(7.0f, (float)totalAmount * 7.0f / 1000.0f) / 16.0f;
        float lastWidth = this.lastWidths.get((Object)pipe).floatValue();
        float width = lastWidth + (targetWidth - lastWidth) / 32.0f;
        this.lastWidths.put(pipe, Float.valueOf(width));
        if (width > 0.01f) {
            float start = 0.5f - width / 2.0f;
            float end = 0.5f + width / 2.0f;
            boolean renderMiddle = false;
            block9: for (Direction direction : Direction.values()) {
                if (middleSides[direction.get3DDataValue()] || !((Boolean)pipe.getBlockState().getValue((Property)FluidPipeBlock.PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
                renderMiddle = true;
                boolean[] renderSides = new boolean[6];
                Arrays.fill(renderSides, true);
                renderSides[direction.getOpposite().get3DDataValue()] = false;
                switch (direction) {
                    case UP: {
                        this.renderFluidCuboid(vertexBuffer, matrix, start, end, start, end, 1.0f, end, fluidSprite, info.tint(), light, renderSides);
                        continue block9;
                    }
                    case DOWN: {
                        this.renderFluidCuboid(vertexBuffer, matrix, start, 0.0f, start, end, start, end, fluidSprite, info.tint(), light, renderSides);
                        continue block9;
                    }
                    case EAST: {
                        this.renderFluidCuboid(vertexBuffer, matrix, end, start, start, 1.0f, end, end, fluidSprite, info.tint(), light, renderSides);
                        continue block9;
                    }
                    case WEST: {
                        this.renderFluidCuboid(vertexBuffer, matrix, 0.0f, start, start, start, end, end, fluidSprite, info.tint(), light, renderSides);
                        continue block9;
                    }
                    case SOUTH: {
                        this.renderFluidCuboid(vertexBuffer, matrix, start, start, end, end, end, 1.0f, fluidSprite, info.tint(), light, renderSides);
                        continue block9;
                    }
                    case NORTH: {
                        this.renderFluidCuboid(vertexBuffer, matrix, start, start, 0.0f, end, end, start, fluidSprite, info.tint(), light, renderSides);
                    }
                }
            }
            if (renderMiddle) {
                this.renderFluidCuboid(vertexBuffer, matrix, start, start, start, end, end, end, fluidSprite, info.tint(), light, middleSides);
            }
        }
        poses.popPose();
    }

    public void renderFluidCuboid(VertexConsumer vertexBuffer, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, TextureAtlasSprite fluidSprite, int tint, int light, boolean[] renderSide) {
        float u1 = fluidSprite.getU(x1);
        float u2 = fluidSprite.getU(x2);
        float v1 = fluidSprite.getV(z1);
        float v2 = fluidSprite.getV(z2);
        if (renderSide[Direction.DOWN.get3DDataValue()]) {
            vertexBuffer.addVertex(matrix, x1, y1, z2).setColor(tint).setUv(u1, v2).setLight(light);
            vertexBuffer.addVertex(matrix, x1, y1, z1).setColor(tint).setUv(u1, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y1, z1).setColor(tint).setUv(u2, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y1, z2).setColor(tint).setUv(u2, v2).setLight(light);
        }
        if (renderSide[Direction.UP.get3DDataValue()]) {
            vertexBuffer.addVertex(matrix, x1, y2, z1).setColor(tint).setUv(u1, v2).setLight(light);
            vertexBuffer.addVertex(matrix, x1, y2, z2).setColor(tint).setUv(u1, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y2, z2).setColor(tint).setUv(u2, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y2, z1).setColor(tint).setUv(u2, v2).setLight(light);
        }
        u1 = fluidSprite.getU(y1);
        u2 = fluidSprite.getU(y2);
        v1 = fluidSprite.getV(z1);
        v2 = fluidSprite.getV(z2);
        if (renderSide[Direction.WEST.get3DDataValue()]) {
            vertexBuffer.addVertex(matrix, x1, y2, z2).setColor(tint).setUv(u1, v2).setLight(light);
            vertexBuffer.addVertex(matrix, x1, y2, z1).setColor(tint).setUv(u1, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x1, y1, z1).setColor(tint).setUv(u2, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x1, y1, z2).setColor(tint).setUv(u2, v2).setLight(light);
        }
        if (renderSide[Direction.EAST.get3DDataValue()]) {
            vertexBuffer.addVertex(matrix, x2, y2, z1).setColor(tint).setUv(u1, v2).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y2, z2).setColor(tint).setUv(u1, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y1, z2).setColor(tint).setUv(u2, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y1, z1).setColor(tint).setUv(u2, v2).setLight(light);
        }
        u1 = fluidSprite.getU(y1);
        u2 = fluidSprite.getU(y2);
        v1 = fluidSprite.getV(x1);
        v2 = fluidSprite.getV(x2);
        if (renderSide[Direction.NORTH.get3DDataValue()]) {
            vertexBuffer.addVertex(matrix, x1, y2, z1).setColor(tint).setUv(u1, v2).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y2, z1).setColor(tint).setUv(u1, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y1, z1).setColor(tint).setUv(u2, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x1, y1, z1).setColor(tint).setUv(u2, v2).setLight(light);
        }
        if (renderSide[Direction.SOUTH.get3DDataValue()]) {
            vertexBuffer.addVertex(matrix, x2, y2, z2).setColor(tint).setUv(u1, v2).setLight(light);
            vertexBuffer.addVertex(matrix, x1, y2, z2).setColor(tint).setUv(u1, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x1, y1, z2).setColor(tint).setUv(u2, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y1, z2).setColor(tint).setUv(u2, v2).setLight(light);
        }
    }
}

