/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.screen;

import jagm.classicpipes.client.screen.FilterScreen;
import jagm.classicpipes.inventory.menu.RecipePipeMenu;
import jagm.classicpipes.network.ServerBoundSlotDirectionPayload;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class RecipePipeScreen
extends FilterScreen<RecipePipeMenu> {
    private static final ResourceLocation BACKGROUND = MiscUtil.resourceLocation("textures/gui/container/recipe_pipe.png");
    private static final ChatFormatting[] DIRECTION_COLOURS = new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.GREEN, ChatFormatting.YELLOW, ChatFormatting.BLUE, ChatFormatting.GRAY, ChatFormatting.RED};
    private final Button[] slotDirectionButtons = new Button[10];
    private boolean buttonsNeedUpdate;

    public RecipePipeScreen(RecipePipeMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.imageHeight = 171;
        this.inventoryLabelY = this.imageHeight - 94;
        this.buttonsNeedUpdate = true;
    }

    protected void init() {
        super.init();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int slot = j + i * 3;
                Direction slotDirection = ((RecipePipeMenu)this.menu).getSlotDirection(slot);
                this.slotDirectionButtons[slot] = Button.builder((Component)Component.translatable((String)("direction.classicpipes.short." + slotDirection.name().toLowerCase())).withStyle(DIRECTION_COLOURS[slotDirection.get3DDataValue()]), button -> this.cycleSlotDirection(slot)).bounds(this.leftPos + 9 + j * 12, this.topPos + 25 + i * 12, 12, 12).build();
            }
        }
        Direction slotDirection = ((RecipePipeMenu)this.menu).getSlotDirection(9);
        this.slotDirectionButtons[9] = Button.builder((Component)Component.translatable((String)("direction.classicpipes.short." + slotDirection.name().toLowerCase())).withStyle(DIRECTION_COLOURS[slotDirection.get3DDataValue()]), button -> this.cycleSlotDirection(9)).bounds(this.leftPos + 149, this.topPos + 37, 12, 12).build();
        for (Button button2 : this.slotDirectionButtons) {
            this.addRenderableWidget((GuiEventListener)button2);
        }
        this.buttonsNeedUpdate = true;
    }

    private void cycleSlotDirection(int slot) {
        Direction newDirection = RecipePipeScreen.hasShiftDown() ? ((RecipePipeMenu)this.menu).prevDirection(((RecipePipeMenu)this.menu).getSlotDirection(slot)) : ((RecipePipeMenu)this.menu).nextDirection(((RecipePipeMenu)this.menu).getSlotDirection(slot));
        ((RecipePipeMenu)this.menu).setSlotDirection(slot, newDirection);
        this.buttonsNeedUpdate = true;
        Services.LOADER_SERVICE.sendToServer(new ServerBoundSlotDirectionPayload(((RecipePipeMenu)this.menu).getPos(), slot, newDirection));
    }

    private Tooltip createDirectionTooltip(Direction direction, boolean result) {
        return Tooltip.create((Component)Component.translatable((String)("tooltip.classicpipes" + (result ? ".recipe_pipe_result" : ".recipe_pipe_grid")), (Object[])new Object[]{Component.translatable((String)("direction.classicpipes." + direction.name().toLowerCase())).withStyle(DIRECTION_COLOURS[direction.get3DDataValue()])}));
    }

    private void updateButtons() {
        for (int slot = 0; slot < 10; ++slot) {
            boolean active = ((RecipePipeMenu)this.menu).slotHasItem(slot) && ((RecipePipeMenu)this.menu).hasAvailableDirections();
            Direction direction = ((RecipePipeMenu)this.menu).getSlotDirection(slot);
            this.slotDirectionButtons[slot].active = active;
            this.slotDirectionButtons[slot].setMessage((Component)(active ? Component.translatable((String)("direction.classicpipes.short." + direction.name().toLowerCase())).withStyle(DIRECTION_COLOURS[direction.get3DDataValue()]) : Component.empty()));
            this.slotDirectionButtons[slot].setTooltip(active ? this.createDirectionTooltip(direction, slot == 9) : null);
        }
        this.setFocused(null);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.buttonsNeedUpdate) {
            this.updateButtons();
            this.buttonsNeedUpdate = false;
        }
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void containerTick() {
        this.buttonsNeedUpdate = true;
        super.containerTick();
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, (this.imageWidth - this.font.width((FormattedText)this.title)) / 2 - 9, this.titleLabelY, -12566464, false);
        graphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, -12566464, false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        graphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.buttonsNeedUpdate = true;
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.buttonsNeedUpdate = true;
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

