/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.inventory.menu;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.StoragePipeEntity;
import jagm.classicpipes.network.ClientBoundThreeBoolsPayload;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class StoragePipeMenu
extends AbstractContainerMenu {
    private boolean defaultRoute;
    private boolean matchComponents;
    private boolean leaveOne;
    private final StoragePipeEntity pipe;

    public StoragePipeMenu(int id, Inventory playerInventory, ClientBoundThreeBoolsPayload payload) {
        this(id, playerInventory, payload.first(), payload.second(), payload.third(), null);
    }

    public StoragePipeMenu(int id, Inventory playerInventory, boolean defaultRoute, boolean matchComponents, boolean leaveOne, StoragePipeEntity pipe) {
        super(ClassicPipes.STORAGE_PIPE_MENU, id);
        this.addStandardInventorySlots((Container)playerInventory, 8, 84);
        this.defaultRoute = defaultRoute;
        this.matchComponents = matchComponents;
        this.leaveOne = leaveOne;
        this.pipe = pipe;
    }

    public ItemStack quickMoveStack(Player player, int id) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        if (this.pipe != null) {
            return this.pipe.stillValid(player);
        }
        return true;
    }

    public boolean shouldMatchComponents() {
        return this.matchComponents;
    }

    public void setMatchComponents(boolean matchComponents) {
        this.matchComponents = matchComponents;
        if (this.pipe != null) {
            this.pipe.setMatchComponents(matchComponents);
        }
    }

    public boolean shouldLeaveOne() {
        return this.leaveOne;
    }

    public void setLeaveOne(boolean leaveOne) {
        this.leaveOne = leaveOne;
        if (this.pipe != null) {
            this.pipe.setLeaveOne(leaveOne);
        }
    }

    public boolean isDefaultRoute() {
        return this.defaultRoute;
    }

    public void setDefaultRoute(boolean defaultRoute) {
        this.defaultRoute = defaultRoute;
        if (this.pipe != null) {
            this.pipe.setDefaultRoute(defaultRoute);
        }
    }
}

