/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.CopperFluidPipeBlock;
import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;

public class CopperFluidPipeEntity
extends FluidPipeEntity {
    private static final byte DEFAULT_COOLDOWN = 4;
    private byte cooldown = (byte)4;

    public CopperFluidPipeEntity(BlockPos pos, BlockState state) {
        this(ClassicPipes.COPPER_FLUID_PIPE_ENTITY, pos, state);
    }

    public CopperFluidPipeEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        super.tickServer(level, pos, state);
        if (((Boolean)state.getValue((Property)CopperFluidPipeBlock.ENABLED)).booleanValue() && state.getValue(CopperFluidPipeBlock.FACING) != FacingOrNone.NONE) {
            byte by = this.cooldown;
            this.cooldown = (byte)(by - 1);
            if (by <= 0) {
                Direction direction = ((FacingOrNone)((Object)state.getValue(CopperFluidPipeBlock.FACING))).getDirection();
                if (Services.LOADER_SERVICE.handleFluidExtraction(this, state, level, pos.relative(direction), direction.getOpposite(), this.extractAmount(), this.filterPredicate())) {
                    level.sendBlockUpdated(pos, state, state, 2);
                    this.setChanged();
                }
                this.cooldown = (byte)4;
            }
        }
    }

    protected int extractAmount() {
        return 125;
    }

    protected Predicate<Fluid> filterPredicate() {
        return fluid -> true;
    }

    @Override
    protected void loadAdditional(CompoundTag valueInput, HolderLookup.Provider registries) {
        super.loadAdditional(valueInput, registries);
        this.cooldown = valueInput.getByte("cooldown");
    }

    @Override
    protected void saveAdditional(CompoundTag valueOutput, HolderLookup.Provider registries) {
        super.saveAdditional(valueOutput, registries);
        valueOutput.putByte("cooldown", this.cooldown);
    }
}

