/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.screen;

import jagm.classicpipes.client.screen.widget.SmallerCheckbox;
import jagm.classicpipes.inventory.menu.StoragePipeMenu;
import jagm.classicpipes.network.ServerBoundDefaultRoutePayload;
import jagm.classicpipes.network.ServerBoundLeaveOnePayload;
import jagm.classicpipes.network.ServerBoundMatchComponentsPayload;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.MiscUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class StoragePipeScreen
extends AbstractContainerScreen<StoragePipeMenu> {
    private static final ResourceLocation BACKGROUND = MiscUtil.resourceLocation("textures/gui/container/storage_pipe.png");

    public StoragePipeScreen(StoragePipeMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 166;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)SmallerCheckbox.builder().pos(this.leftPos + 8, this.topPos + 20).onValueChange(this::defaultRouteCheckboxChanged).tooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.classicpipes.default_route"))).selected(((StoragePipeMenu)this.getMenu()).isDefaultRoute()).label((Component)Component.translatable((String)"widget.classicpipes.default_route"), this.font).build());
        this.addRenderableWidget((GuiEventListener)SmallerCheckbox.builder().pos(this.leftPos + 8, this.topPos + 38).onValueChange(this::matchComponentsCheckboxChanged).tooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.classicpipes.match_components_alt"))).selected(((StoragePipeMenu)this.getMenu()).shouldMatchComponents()).label((Component)Component.translatable((String)"widget.classicpipes.match_components"), this.font).build());
        this.addRenderableWidget((GuiEventListener)SmallerCheckbox.builder().pos(this.leftPos + 8, this.topPos + 56).onValueChange(this::leaveOneCheckboxChanged).tooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.classicpipes.leave_one"))).selected(((StoragePipeMenu)this.getMenu()).shouldLeaveOne()).label((Component)Component.translatable((String)"widget.classicpipes.leave_one"), this.font).build());
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        graphics.blit(BACKGROUND, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    private void matchComponentsCheckboxChanged(SmallerCheckbox checkbox, boolean checked) {
        Services.LOADER_SERVICE.sendToServer(new ServerBoundMatchComponentsPayload(checked));
    }

    private void defaultRouteCheckboxChanged(SmallerCheckbox checkbox, boolean checked) {
        Services.LOADER_SERVICE.sendToServer(new ServerBoundDefaultRoutePayload(checked));
    }

    private void leaveOneCheckboxChanged(SmallerCheckbox checkbox, boolean checked) {
        Services.LOADER_SERVICE.sendToServer(new ServerBoundLeaveOnePayload(checked));
    }
}

