/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.inventory.menu;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.blockentity.StockingPipeEntity;
import jagm.classicpipes.inventory.container.Filter;
import jagm.classicpipes.inventory.container.FilterContainer;
import jagm.classicpipes.inventory.menu.FilterMenu;
import jagm.classicpipes.inventory.menu.FilterSlot;
import jagm.classicpipes.network.ClientBoundTwoBoolsPayload;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class StockingPipeMenu
extends FilterMenu {
    private boolean activeStocking;

    public StockingPipeMenu(int id, Inventory playerInventory, ClientBoundTwoBoolsPayload payload) {
        this(id, playerInventory, new FilterContainer(null, 9, payload.first()), payload.second());
    }

    public StockingPipeMenu(int id, Inventory playerInventory, Filter filter, boolean activeStocking) {
        super(ClassicPipes.STOCKING_PIPE_MENU, id, filter);
        int i;
        this.activeStocking = activeStocking;
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new FilterSlot(filter, j, 8 + j * 18, 18));
        }
        int x = 8;
        int y = 84;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, x + i * 18, y + 58));
        }
    }

    @Override
    public void clicked(int index, int button, ClickType clickType, Player player) {
        if (index >= this.getFilter().getContainerSize() || index < 0 || clickType.equals((Object)ClickType.CLONE)) {
            super.clicked(index, button, clickType, player);
        } else {
            Slot slot = (Slot)this.slots.get(index);
            ItemStack stack = slot.getItem();
            if (clickType == ClickType.QUICK_MOVE) {
                slot.set(ItemStack.EMPTY);
            } else if (clickType == ClickType.PICKUP) {
                if (stack.isEmpty()) {
                    slot.set(this.getCarried().copyWithCount(button == 0 ? this.getCarried().getCount() : 1));
                } else {
                    if (this.getCarried().isEmpty()) {
                        stack.grow(button == 0 ? -1 : 1);
                        if (stack.isEmpty()) {
                            slot.set(ItemStack.EMPTY);
                        }
                    } else if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.getCarried())) {
                        stack.grow(1);
                    } else {
                        slot.set(this.getCarried().copyWithCount(1));
                    }
                    if (stack.getCount() > 999) {
                        stack.setCount(999);
                    }
                }
            }
            slot.setChanged();
        }
    }

    public boolean isActiveStocking() {
        return this.activeStocking;
    }

    public void setActiveStocking(boolean activeStocking) {
        this.activeStocking = activeStocking;
        PipeEntity pipeEntity = this.getFilter().getPipe();
        if (pipeEntity instanceof StockingPipeEntity) {
            StockingPipeEntity stockingPipe = (StockingPipeEntity)pipeEntity;
            stockingPipe.setActiveStocking(activeStocking);
        }
    }
}

