/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.block;

import jagm.classicpipes.block.FluidPipeBlock;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.services.Services;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5151;
import net.minecraft.class_8923;

public abstract class PipeBlock
extends class_8923
implements class_3737,
class_2343,
class_5151 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected final class_265[] shapeByIndex;

    public PipeBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapeByIndex = this.makeShapes();
    }

    private class_265[] makeShapes() {
        float a = 0.25f;
        float f = 0.5f - a;
        float f1 = 0.5f + a;
        class_265 voxelshape = class_2248.method_9541((double)(f * 16.0f), (double)(f * 16.0f), (double)(f * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f));
        class_265[] avoxelshape = new class_265[6];
        for (int i = 0; i < 6; ++i) {
            class_2350 direction = class_2350.method_10143((int)i);
            avoxelshape[i] = class_259.method_1081((double)(0.5 + Math.min((double)(-a), (double)direction.method_10148() * 0.5)), (double)(0.5 + Math.min((double)(-a), (double)direction.method_10164() * 0.5)), (double)(0.5 + Math.min((double)(-a), (double)direction.method_10165() * 0.5)), (double)(0.5 + Math.max((double)a, (double)direction.method_10148() * 0.5)), (double)(0.5 + Math.max((double)a, (double)direction.method_10164() * 0.5)), (double)(0.5 + Math.max((double)a, (double)direction.method_10165() * 0.5)));
        }
        class_265[] avoxelshape1 = new class_265[64];
        for (int k = 0; k < 64; ++k) {
            class_265 voxelshape1 = voxelshape;
            for (int j = 0; j < 6; ++j) {
                if ((k & 1 << j) == 0) continue;
                voxelshape1 = class_259.method_1084((class_265)voxelshape1, (class_265)avoxelshape[j]);
            }
            avoxelshape1[k] = voxelshape1;
        }
        return avoxelshape1;
    }

    public abstract boolean isPipeConnected(class_2680 var1, class_2350 var2);

    public abstract class_2680 setPipeConnected(class_2680 var1, class_2350 var2, boolean var3);

    protected boolean canConnect(class_1937 level, class_2338 pipePos, class_2350 direction) {
        class_2338 neighbourPos = pipePos.method_10093(direction);
        class_2248 class_22482 = level.method_8320(neighbourPos).method_26204();
        if (class_22482 instanceof PipeBlock) {
            PipeBlock pipeBlock = (PipeBlock)class_22482;
            return PipeBlock.canConnectToPipeBothWays(this, pipeBlock);
        }
        return Services.LOADER_SERVICE.canAccessContainer(level, neighbourPos, direction.method_10153());
    }

    protected static boolean canConnectToPipeBothWays(PipeBlock pipe1, PipeBlock pipe2) {
        return pipe1.canConnectToPipe(pipe2) && pipe2.canConnectToPipe(pipe1);
    }

    protected boolean canConnectToPipe(PipeBlock pipeBlock) {
        return true;
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_47968((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(context.method_8045().method_8316(context.method_8037()).method_39360((class_3611)class_3612.field_15910)));
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pipePos, class_2338 neighborPos) {
        class_2586 class_25862;
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(pipePos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        boolean wasConnected = this.isPipeConnected(state, direction);
        boolean willConnect = this.canConnect((class_1937)level, pipePos, direction);
        class_2680 newState = this.setPipeConnected(state, direction, willConnect);
        if (wasConnected != willConnect && (class_25862 = level.method_8321(pipePos)) instanceof PipeEntity) {
            PipeEntity pipe = (PipeEntity)class_25862;
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                pipe.update(serverLevel, newState, pipePos, direction, wasConnected);
            }
        }
        return newState;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    protected class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected boolean method_9579(class_2680 state, class_1922 level, class_2338 pos) {
        return false;
    }

    protected class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.shapeByIndex[this.getAABBIndex(state)];
    }

    protected int getAABBIndex(class_2680 state) {
        int i = 0;
        for (int j = 0; j < 6; ++j) {
            if (!this.isPipeConnected(state, class_2350.method_10143((int)j))) continue;
            i |= 1 << j;
        }
        return i;
    }

    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_3218 serverLevel;
        class_2586 blockEntity;
        if (!(this instanceof FluidPipeBlock) && level instanceof class_3218 && (blockEntity = (serverLevel = (class_3218)level).method_8321(pos)) instanceof ItemPipeEntity) {
            ItemPipeEntity pipe = (ItemPipeEntity)blockEntity;
            pipe.dropItems(serverLevel, pos);
        }
        return super.method_9576(level, pos, state, player);
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof PipeEntity) {
            PipeEntity pipe = (PipeEntity)blockEntity;
            return pipe.getComparatorOutput();
        }
        return 0;
    }

    public class_1304 method_7685() {
        return class_1304.field_6169;
    }

    public class_1271<class_1799> method_48576(class_1792 item, class_1937 level, class_1657 player, class_1268 hand) {
        return class_1271.method_22431((Object)player.method_5998(hand));
    }
}

