/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.MatchingPipeBlock;
import jagm.classicpipes.blockentity.MatchingPipe;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.inventory.menu.MatchingPipeMenu;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3908;
import net.minecraft.class_7225;

public class MatchingPipeEntity
extends NetworkedPipeEntity
implements class_3908,
MatchingPipe {
    private boolean matchComponents = false;
    private final List<class_1799> cache = new ArrayList<class_1799>();
    private boolean cacheInitialised = false;
    private final List<class_1799> cannotFit = new ArrayList<class_1799>();

    public MatchingPipeEntity(class_2338 pos, class_2680 state) {
        super(ClassicPipes.MATCHING_PIPE_ENTITY, pos, state);
    }

    @Override
    public void tickServer(class_3218 level, class_2338 pos, class_2680 state) {
        if (!this.cacheInitialised && !((FacingOrNone)((Object)state.method_11654((class_2769)MatchingPipeBlock.FACING))).equals((Object)FacingOrNone.NONE)) {
            this.updateCache(level, pos, ((FacingOrNone)((Object)state.method_11654((class_2769)MatchingPipeBlock.FACING))).getDirection());
            this.cacheInitialised = true;
        }
        super.tickServer(level, pos, state);
    }

    public void updateCache(class_3218 level, class_2338 pos, class_2350 facing) {
        this.cache.clear();
        this.cannotFit.clear();
        this.cache.addAll(Services.LOADER_SERVICE.getContainerItems(level, pos.method_10093(facing), facing.method_10153()));
    }

    @Override
    public boolean matches(class_1799 stack) {
        for (class_1799 cannotFitStack : this.cannotFit) {
            if (!class_1799.method_31577((class_1799)cannotFitStack, (class_1799)stack)) continue;
            return false;
        }
        for (class_1799 containerStack : this.cache) {
            if (!stack.method_31574(containerStack.method_7909()) || this.shouldMatchComponents() && !class_1799.method_31577((class_1799)stack, (class_1799)containerStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NetworkedPipeEntity getAsPipe() {
        return this;
    }

    @Override
    public void markCannotFit(class_1799 stack) {
        this.cannotFit.add(stack);
    }

    @Override
    protected void method_11014(class_2487 valueInput, class_7225.class_7874 registries) {
        this.cacheInitialised = false;
        super.method_11014(valueInput, registries);
        this.matchComponents = valueInput.method_10577("match_components");
    }

    @Override
    protected void method_11007(class_2487 valueOutput, class_7225.class_7874 registries) {
        super.method_11007(valueOutput, registries);
        valueOutput.method_10556("match_components", this.shouldMatchComponents());
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.classicpipes.matching_pipe");
    }

    public class_1703 createMenu(int id, class_1661 playerInventory, class_1657 player) {
        return new MatchingPipeMenu(id, playerInventory, this.shouldMatchComponents(), this);
    }

    public boolean shouldMatchComponents() {
        return this.matchComponents;
    }

    public void setMatchComponents(boolean matchComponents) {
        this.matchComponents = matchComponents;
    }
}

