/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.ProviderPipeBlock;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.blockentity.ProviderPipe;
import jagm.classicpipes.inventory.container.SingleItemFilterContainer;
import jagm.classicpipes.inventory.menu.ProviderPipeMenu;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.PipeNetwork;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3908;
import net.minecraft.class_7225;

public class ProviderPipeEntity
extends NetworkedPipeEntity
implements class_3908,
ProviderPipe {
    private final SingleItemFilterContainer filter = new SingleItemFilterContainer(this, 9, false);
    private boolean leaveOne = false;
    private final List<class_1799> cache = new ArrayList<class_1799>();
    private boolean cacheInitialised = false;

    public ProviderPipeEntity(class_2338 pos, class_2680 state) {
        super(ClassicPipes.PROVIDER_PIPE_ENTITY, pos, state);
    }

    @Override
    public void tickServer(class_3218 level, class_2338 pos, class_2680 state) {
        if (!this.cacheInitialised && !((FacingOrNone)((Object)state.method_11654((class_2769)ProviderPipeBlock.FACING))).equals((Object)FacingOrNone.NONE)) {
            this.updateCache(level, pos, ((FacingOrNone)((Object)state.method_11654((class_2769)ProviderPipeBlock.FACING))).getDirection());
            this.cacheInitialised = true;
        }
        super.tickServer(level, pos, state);
    }

    @Override
    public void disconnect(class_3218 level) {
        PipeNetwork network = this.getNetwork();
        super.disconnect(level);
        if (network != null) {
            network.cacheUpdated();
        }
    }

    @Override
    protected void method_11014(class_2487 valueInput, class_7225.class_7874 registries) {
        this.filter.method_5448();
        this.cacheInitialised = false;
        super.method_11014(valueInput, registries);
        class_2499 filterList = valueInput.method_10554("filter", 10);
        filterList.forEach(tag -> {
            if (tag instanceof class_2487) {
                class_2487 compoundTag = (class_2487)tag;
                int slot = compoundTag.method_10550("slot");
                MiscUtil.loadFromTag(tag, class_1799.field_24671, registries, stack -> this.filter.method_5447(slot, (class_1799)stack));
            }
        });
        this.filter.setMatchComponents(valueInput.method_10577("match_components"));
        this.leaveOne = valueInput.method_10577("leave_one");
    }

    @Override
    protected void method_11007(class_2487 valueOutput, class_7225.class_7874 registries) {
        super.method_11007(valueOutput, registries);
        class_2499 filterList = new class_2499();
        for (int slot = 0; slot < this.filter.method_5439(); ++slot) {
            class_1799 stack = this.filter.method_5438(slot);
            if (stack.method_7960()) continue;
            class_2487 tag = new class_2487();
            tag.method_10569("slot", slot);
            MiscUtil.saveToTag((class_2520)tag, stack, class_1799.field_24671, registries, arg_0 -> filterList.add(arg_0));
        }
        valueOutput.method_10566("filter", (class_2520)filterList);
        valueOutput.method_10556("match_components", this.filter.shouldMatchComponents());
        valueOutput.method_10556("leave_one", this.leaveOne);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.classicpipes.provider_pipe");
    }

    public class_1703 createMenu(int id, class_1661 playerInventory, class_1657 player) {
        return new ProviderPipeMenu(id, playerInventory, this.filter, this.leaveOne);
    }

    public boolean shouldMatchComponents() {
        return this.filter.shouldMatchComponents();
    }

    public void setLeaveOne(boolean leaveOne) {
        this.leaveOne = leaveOne;
        class_2350 facing = ((FacingOrNone)((Object)this.method_11010().method_11654((class_2769)ProviderPipeBlock.FACING))).getDirection();
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (facing != null) {
                this.updateCache(serverLevel, this.method_11016(), facing);
            }
        }
    }

    public boolean shouldLeaveOne() {
        return this.leaveOne;
    }

    @Override
    public void updateCache(class_3218 level, class_2338 pos, class_2350 facing) {
        this.cache.clear();
        List<class_1799> stacks = Services.LOADER_SERVICE.getContainerItems(level, pos.method_10093(facing), facing.method_10153());
        Iterator<class_1799> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            class_1799 stack = iterator.next();
            if (!this.filter.method_5442() && !this.filter.matches(stack)) {
                iterator.remove();
                continue;
            }
            if (!this.shouldLeaveOne()) continue;
            stack.method_7934(1);
            if (!stack.method_7960()) continue;
            iterator.remove();
        }
        this.cache.addAll(stacks);
        if (this.hasNetwork()) {
            this.getNetwork().cacheUpdated();
        }
    }

    public void updateCache() {
        class_2350 facing = ((FacingOrNone)((Object)this.method_11010().method_11654((class_2769)ProviderPipeBlock.FACING))).getDirection();
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (facing != null) {
                this.updateCache(serverLevel, this.method_11016(), facing);
            }
        }
    }

    @Override
    public List<class_1799> getCache() {
        return this.cache;
    }

    @Override
    public boolean extractItem(class_3218 level, class_1799 stack) {
        class_2350 facing = ((FacingOrNone)((Object)this.method_11010().method_11654((class_2769)ProviderPipeBlock.FACING))).getDirection();
        if (facing != null) {
            boolean extracted = Services.LOADER_SERVICE.extractSpecificItem(this, level, this.method_11016().method_10093(facing), facing.method_10153(), stack.method_7972());
            this.updateCache(level, this.method_11016(), facing);
            return extracted;
        }
        return false;
    }

    @Override
    public class_2338 getProviderPipePos() {
        return this.method_11016();
    }

    @Override
    public class_2350 getFacing() {
        return ((FacingOrNone)((Object)this.method_11010().method_11654((class_2769)ProviderPipeBlock.FACING))).getDirection();
    }
}

