/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.StockingPipeBlock;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.inventory.container.FilterContainer;
import jagm.classicpipes.inventory.menu.StockingPipeMenu;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.RequestedItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3908;
import net.minecraft.class_7225;

public class StockingPipeEntity
extends NetworkedPipeEntity
implements class_3908 {
    private final FilterContainer filter = new FilterContainer(this, 9, true);
    private boolean activeStocking = false;
    private final List<class_1799> missingItemsCache = new ArrayList<class_1799>();
    private boolean cacheInitialised = false;

    public StockingPipeEntity(class_2338 pos, class_2680 state) {
        super(ClassicPipes.STOCKING_PIPE_ENTITY, pos, state);
    }

    @Override
    public void tickServer(class_3218 level, class_2338 pos, class_2680 state) {
        super.tickServer(level, pos, state);
        if (!this.cacheInitialised) {
            this.updateCache(level);
            this.cacheInitialised = true;
        }
    }

    public void updateCache(class_3218 level) {
        this.missingItemsCache.clear();
        class_2350 facing = ((FacingOrNone)((Object)this.method_11010().method_11654((class_2769)StockingPipeBlock.FACING))).getDirection();
        if (facing != null) {
            ArrayList<class_1799> filterItems = new ArrayList<class_1799>();
            for (int i = 0; i < this.filter.method_5439(); ++i) {
                class_1799 stack = this.filter.method_5438(i);
                if (stack.method_7960()) continue;
                boolean matched = false;
                for (class_1799 filterStack : filterItems) {
                    if (!class_1799.method_31577((class_1799)stack, (class_1799)filterStack)) continue;
                    filterStack.method_7933(stack.method_7947());
                    matched = true;
                    break;
                }
                if (matched) continue;
                filterItems.add(stack.method_7972());
            }
            if (!filterItems.isEmpty()) {
                List<class_1799> containerItems = Services.LOADER_SERVICE.getContainerItems(level, this.method_11016().method_10093(facing), facing.method_10153());
                for (class_1799 filterStack : filterItems) {
                    boolean matched = false;
                    for (class_1799 containerStack : containerItems) {
                        if (!class_1799.method_31577((class_1799)filterStack, (class_1799)containerStack)) continue;
                        matched = true;
                        int missing = filterStack.method_7947() - containerStack.method_7947();
                        if (missing <= 0) break;
                        this.missingItemsCache.add(containerStack.method_46651(missing));
                        break;
                    }
                    if (matched) continue;
                    this.missingItemsCache.add(filterStack);
                }
            }
        }
        if (this.activeStocking) {
            this.tryRequests(level);
        }
    }

    public void updateCache() {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.updateCache(serverLevel);
        }
    }

    public void tryRequests(class_3218 level) {
        if (this.hasNetwork()) {
            for (class_1799 stack : this.missingItemsCache) {
                int alreadyRequested = 0;
                for (ItemInPipe item : this.contents) {
                    if (!class_1799.method_31577((class_1799)stack, (class_1799)item.getStack())) continue;
                    alreadyRequested += item.getStack().method_7947();
                }
                for (RequestedItem requestedItem : this.getNetwork().getRequestedItems()) {
                    if (!requestedItem.matches(stack) || !requestedItem.getDestination().equals((Object)this.method_11016())) continue;
                    alreadyRequested += requestedItem.getAmountRemaining();
                }
                if (alreadyRequested >= stack.method_7947()) continue;
                this.getNetwork().request(level, stack.method_46651(stack.method_7947() - alreadyRequested), this.method_11016(), null, true);
            }
        }
    }

    public boolean isActiveStocking() {
        return this.activeStocking;
    }

    public void setActiveStocking(boolean activeStocking) {
        class_1937 class_19372;
        this.activeStocking = activeStocking;
        if (activeStocking && (class_19372 = this.method_10997()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.tryRequests(serverLevel);
        }
    }

    public boolean shouldMatchComponents() {
        return this.filter.shouldMatchComponents();
    }

    public List<class_1799> getMissingItemsCache() {
        return this.missingItemsCache;
    }

    @Override
    protected void method_11014(class_2487 valueInput, class_7225.class_7874 registries) {
        this.filter.method_5448();
        super.method_11014(valueInput, registries);
        class_2499 filterList = valueInput.method_10554("filter", 10);
        filterList.forEach(tag -> {
            if (tag instanceof class_2487) {
                class_2487 compoundTag = (class_2487)tag;
                int slot = compoundTag.method_10550("slot");
                MiscUtil.loadFromTag(tag, class_1799.field_24671, registries, stack -> this.filter.method_5447(slot, (class_1799)stack));
            }
        });
        this.filter.setMatchComponents(valueInput.method_10577("match_components"));
        this.activeStocking = valueInput.method_10577("active_stocking");
    }

    @Override
    protected void method_11007(class_2487 valueOutput, class_7225.class_7874 registries) {
        super.method_11007(valueOutput, registries);
        class_2499 filterList = new class_2499();
        for (int slot = 0; slot < this.filter.method_5439(); ++slot) {
            class_1799 stack = this.filter.method_5438(slot);
            if (stack.method_7960()) continue;
            class_2487 tag = new class_2487();
            tag.method_10569("slot", slot);
            MiscUtil.saveToTag((class_2520)tag, stack, class_1799.field_24671, registries, arg_0 -> filterList.add(arg_0));
        }
        valueOutput.method_10566("filter", (class_2520)filterList);
        valueOutput.method_10556("match_components", this.filter.shouldMatchComponents());
        valueOutput.method_10556("active_stocking", this.activeStocking);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.classicpipes.stocking_pipe");
    }

    public class_1703 createMenu(int id, class_1661 playerInventory, class_1657 player) {
        return new StockingPipeMenu(id, playerInventory, this.filter, this.activeStocking);
    }
}

