/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.MatchingPipeBlock;
import jagm.classicpipes.block.ProviderPipeBlock;
import jagm.classicpipes.blockentity.MatchingPipe;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.blockentity.ProviderPipe;
import jagm.classicpipes.inventory.menu.StoragePipeMenu;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3908;
import net.minecraft.class_7225;

public class StoragePipeEntity
extends NetworkedPipeEntity
implements class_3908,
ProviderPipe,
MatchingPipe {
    private boolean defaultRoute = false;
    private boolean matchComponents = false;
    private boolean leaveOne = false;
    private final List<class_1799> cache = new ArrayList<class_1799>();
    private boolean cacheInitialised = false;
    private final List<class_1799> cannotFit = new ArrayList<class_1799>();

    public StoragePipeEntity(class_2338 pos, class_2680 state) {
        super(ClassicPipes.STORAGE_PIPE_ENTITY, pos, state);
    }

    @Override
    public void tickServer(class_3218 level, class_2338 pos, class_2680 state) {
        if (!this.cacheInitialised && !((FacingOrNone)((Object)state.method_11654((class_2769)MatchingPipeBlock.FACING))).equals((Object)FacingOrNone.NONE)) {
            this.updateCache(level, pos, ((FacingOrNone)((Object)state.method_11654((class_2769)MatchingPipeBlock.FACING))).getDirection());
            this.cacheInitialised = true;
        }
        super.tickServer(level, pos, state);
    }

    @Override
    public void updateCache(class_3218 level, class_2338 pos, class_2350 facing) {
        this.cache.clear();
        this.cannotFit.clear();
        List<class_1799> stacks = Services.LOADER_SERVICE.getContainerItems(level, pos.method_10093(facing), facing.method_10153());
        Iterator<class_1799> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            class_1799 stack = iterator.next();
            if (!this.shouldLeaveOne()) continue;
            stack.method_7934(1);
            if (!stack.method_7960()) continue;
            iterator.remove();
        }
        this.cache.addAll(stacks);
        if (this.hasNetwork()) {
            this.getNetwork().cacheUpdated();
        }
    }

    @Override
    public class_2350 getFacing() {
        return ((FacingOrNone)((Object)this.method_11010().method_11654((class_2769)ProviderPipeBlock.FACING))).getDirection();
    }

    @Override
    public boolean matches(class_1799 stack) {
        for (class_1799 cannotFitStack : this.cannotFit) {
            if (!class_1799.method_31577((class_1799)cannotFitStack, (class_1799)stack)) continue;
            return false;
        }
        for (class_1799 containerStack : this.cache) {
            if (!stack.method_31574(containerStack.method_7909()) || this.shouldMatchComponents() && !class_1799.method_31577((class_1799)stack, (class_1799)containerStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NetworkedPipeEntity getAsPipe() {
        return this;
    }

    @Override
    public void markCannotFit(class_1799 stack) {
        this.cannotFit.add(stack);
    }

    @Override
    public boolean isDefaultRoute() {
        return this.defaultRoute;
    }

    public void setDefaultRoute(boolean defaultRoute) {
        this.defaultRoute = defaultRoute;
        if (defaultRoute) {
            this.getNetwork().addPipe(this);
        } else {
            this.getNetwork().getDefaultRoutes().remove(this);
        }
    }

    public boolean shouldMatchComponents() {
        return this.matchComponents;
    }

    public void setMatchComponents(boolean matchComponents) {
        this.matchComponents = matchComponents;
    }

    public void setLeaveOne(boolean leaveOne) {
        this.leaveOne = leaveOne;
        class_2350 facing = ((FacingOrNone)((Object)this.method_11010().method_11654((class_2769)ProviderPipeBlock.FACING))).getDirection();
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (facing != null) {
                this.updateCache(serverLevel, this.method_11016(), facing);
            }
        }
    }

    public boolean shouldLeaveOne() {
        return this.leaveOne;
    }

    @Override
    protected void method_11014(class_2487 valueInput, class_7225.class_7874 registries) {
        this.cacheInitialised = false;
        super.method_11014(valueInput, registries);
        this.defaultRoute = valueInput.method_10577("default_route");
        this.matchComponents = valueInput.method_10577("match_components");
        this.leaveOne = valueInput.method_10577("leave_one");
    }

    @Override
    protected void method_11007(class_2487 valueOutput, class_7225.class_7874 registries) {
        super.method_11007(valueOutput, registries);
        valueOutput.method_10556("default_route", this.isDefaultRoute());
        valueOutput.method_10556("match_components", this.shouldMatchComponents());
        valueOutput.method_10556("leave_one", this.shouldLeaveOne());
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.classicpipes.storage_pipe");
    }

    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new StoragePipeMenu(id, inventory, this.isDefaultRoute(), this.shouldMatchComponents(), this.shouldLeaveOne(), this);
    }

    @Override
    public List<class_1799> getCache() {
        return this.cache;
    }

    @Override
    public boolean extractItem(class_3218 level, class_1799 stack) {
        class_2350 facing = ((FacingOrNone)((Object)this.method_11010().method_11654((class_2769)ProviderPipeBlock.FACING))).getDirection();
        if (facing != null) {
            boolean extracted = Services.LOADER_SERVICE.extractSpecificItem(this, level, this.method_11016().method_10093(facing), facing.method_10153(), stack.method_7972());
            this.updateCache(level, this.method_11016(), facing);
            return extracted;
        }
        return false;
    }

    @Override
    public class_2338 getProviderPipePos() {
        return this.method_11016();
    }
}

