/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import com.mojang.serialization.DynamicOps;
import jagm.classicpipes.block.ContainerAdjacentNetworkedPipeBlock;
import jagm.classicpipes.block.NetworkedPipeBlock;
import jagm.classicpipes.blockentity.MatchingPipe;
import jagm.classicpipes.blockentity.RecipePipeEntity;
import jagm.classicpipes.blockentity.RoundRobinPipeEntity;
import jagm.classicpipes.blockentity.RoutingPipeEntity;
import jagm.classicpipes.blockentity.StockingPipeEntity;
import jagm.classicpipes.util.FacingOrNone;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.PipeNetwork;
import jagm.classicpipes.util.RequestedItem;
import jagm.classicpipes.util.ScheduledRoute;
import jagm.classicpipes.util.SortingMode;
import jagm.classicpipes.util.Tuple;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public abstract class NetworkedPipeEntity
extends RoundRobinPipeEntity {
    private final Map<class_1799, ScheduledRoute> routingSchedule = new HashMap<class_1799, ScheduledRoute>();
    private PipeNetwork network = null;
    private boolean controller = false;
    public class_2338 syncedNetworkPos = this.method_11016();

    public NetworkedPipeEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
    }

    @Override
    public void tickServer(class_3218 level, class_2338 pos, class_2680 state) {
        super.tickServer(level, pos, state);
        if (!this.routingSchedule.isEmpty()) {
            Iterator<class_1799> iterator = this.routingSchedule.keySet().iterator();
            while (iterator.hasNext()) {
                ScheduledRoute route = this.routingSchedule.get(iterator.next());
                route.tick();
                if (!route.timedOut()) continue;
                iterator.remove();
                this.method_5431();
            }
        }
        if (this.isController()) {
            this.getNetwork().tick(level);
        }
    }

    @Override
    protected void initialiseNetworking(class_3218 level, class_2680 state, class_2338 pos) {
        if (this.isController() && this.hasNetwork()) {
            this.distributeNetwork(level, this.method_11016(), new HashSet<NetworkedPipeEntity>(), this.getNetwork());
        }
        super.initialiseNetworking(level, state, pos);
    }

    protected Set<NetworkedPipeEntity> distributeNetwork(class_3218 level, class_2338 pos, Set<NetworkedPipeEntity> visited, PipeNetwork network) {
        if (visited.contains((Object)this)) {
            return visited;
        }
        visited.add(this);
        for (class_2350 direction : this.networkDistances.keySet()) {
            class_2338 nextPos = (class_2338)((Tuple)this.networkDistances.get(direction)).a();
            class_2586 class_25862 = level.method_8321(nextPos);
            if (!(class_25862 instanceof NetworkedPipeEntity)) continue;
            NetworkedPipeEntity nextPipe = (NetworkedPipeEntity)class_25862;
            visited = nextPipe.distributeNetwork(level, nextPos, visited, network);
        }
        this.setController(pos.equals((Object)network.getPos()));
        this.setNetwork(network, level);
        return visited;
    }

    @Override
    protected List<class_2350> getValidDirections(class_2680 state, ItemInPipe item) {
        ArrayList<class_2350> validDirections = new ArrayList<class_2350>();
        class_2350 direction = MiscUtil.nextDirection(item.getFromDirection());
        for (int i = 0; i < 5; ++i) {
            if (((NetworkedPipeBlock.ConnectionState)((Object)state.method_11654((class_2769)NetworkedPipeBlock.PROPERTY_BY_DIRECTION.get(direction)))).equals((Object)NetworkedPipeBlock.ConnectionState.LINKED)) {
                validDirections.add(direction);
            }
            direction = MiscUtil.nextDirection(direction);
        }
        if (validDirections.isEmpty()) {
            return super.getValidDirections(state, item);
        }
        return validDirections;
    }

    @Override
    public void routeItem(class_2680 state, ItemInPipe item) {
        class_1937 class_19372;
        if (!this.hasNetwork()) {
            super.routeItem(state, item);
            return;
        }
        if (!this.checkRoutingSchedule(item) && (class_19372 = this.method_10997()) instanceof class_3218) {
            class_2248 class_22482;
            class_3218 serverLevel = (class_3218)class_19372;
            ArrayList<Object> validTargets = new ArrayList<Object>();
            RequestedItem thisRequestedItem = null;
            ArrayList<ItemInPipe> spareItems = new ArrayList<ItemInPipe>();
            for (RequestedItem requestedItem : this.getNetwork().getRequestedItems()) {
                Object target;
                if (!requestedItem.matches(item) || this.method_10997() == null || (target = requestedItem.getTarget(this.method_10997())) == null) continue;
                if (item.getStack().method_7947() > requestedItem.getAmountRemaining()) {
                    spareItems.add(item.copyWithCount(item.getStack().method_7947() - requestedItem.getAmountRemaining()));
                    item.getStack().method_7939(requestedItem.getAmountRemaining());
                }
                thisRequestedItem = requestedItem;
                validTargets.add(target);
                break;
            }
            if (validTargets.isEmpty()) {
                block1: for (StockingPipeEntity stockingPipeEntity : this.network.getStockingPipes()) {
                    for (class_1799 stack : stockingPipeEntity.getMissingItemsCache()) {
                        if (!stack.method_31574(item.getStack().method_7909()) || stockingPipeEntity.shouldMatchComponents() && !class_1799.method_31577((class_1799)stack, (class_1799)item.getStack())) continue;
                        int surplus = item.getStack().method_7947() - stack.method_7947();
                        if (surplus > 0) {
                            spareItems.add(item.copyWithCount(surplus));
                            item.getStack().method_7939(stack.method_7947());
                        }
                        validTargets.add((Object)stockingPipeEntity);
                        continue block1;
                    }
                }
            }
            if (validTargets.isEmpty()) {
                for (MatchingPipe matchingPipe : this.network.getMatchingPipes()) {
                    if (!matchingPipe.matches(item.getStack())) continue;
                    validTargets.add((Object)matchingPipe.getAsPipe());
                }
            }
            if (validTargets.isEmpty()) {
                for (RoutingPipeEntity routingPipeEntity : this.network.getRoutingPipes()) {
                    if (!routingPipeEntity.canRouteItemHere(item.getStack())) continue;
                    validTargets.add((Object)routingPipeEntity);
                }
            }
            if (validTargets.isEmpty()) {
                validTargets.addAll(this.network.getDefaultRoutes());
            }
            if (validTargets.contains((Object)this) && (class_22482 = state.method_26204()) instanceof NetworkedPipeBlock) {
                NetworkedPipeBlock networkedBlock = (NetworkedPipeBlock)class_22482;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (networkedBlock instanceof ContainerAdjacentNetworkedPipeBlock && state.method_11654(ContainerAdjacentNetworkedPipeBlock.FACING) != FacingOrNone.NONE) {
                    arrayList.add(((FacingOrNone)((Object)state.method_11654(ContainerAdjacentNetworkedPipeBlock.FACING))).getDirection());
                } else {
                    for (class_2350 direction : class_2350.values()) {
                        if (!this.isPipeConnected(state, direction) || networkedBlock.isLinked(state, direction)) continue;
                        arrayList.add(direction);
                    }
                }
                if (arrayList.isEmpty() || this instanceof RecipePipeEntity) {
                    item.setEjecting(true);
                    item.setTargetDirection(item.getFromDirection().method_10153());
                } else {
                    item.setEjecting(false);
                    item.setTargetDirection((class_2350)arrayList.get(serverLevel.method_8409().method_43048(arrayList.size())));
                }
                if (thisRequestedItem != null) {
                    int remaining = thisRequestedItem.getAmountRemaining();
                    int leftover = item.getStack().method_7947() - remaining;
                    thisRequestedItem.arrived(item.getStack().method_7947());
                    if (thisRequestedItem.isDelivered()) {
                        this.getNetwork().removeRequestedItem(thisRequestedItem);
                    }
                    if (leftover > 0) {
                        item.setStack(item.getStack().method_46651(remaining));
                        spareItems.add(item.copyWithCount(leftover));
                    }
                }
            } else if (!validTargets.isEmpty()) {
                this.schedulePath(serverLevel, item, (NetworkedPipeEntity)((Object)validTargets.get(serverLevel.method_8409().method_43048(validTargets.size()))));
                this.checkRoutingSchedule(item);
            } else {
                super.routeItem(state, item);
            }
            for (ItemInPipe itemInPipe : spareItems) {
                this.queued.add(itemInPipe);
                this.routeItem(state, itemInPipe);
            }
        }
    }

    private boolean checkRoutingSchedule(ItemInPipe item) {
        Iterator<class_1799> iterator = this.routingSchedule.keySet().iterator();
        while (iterator.hasNext()) {
            class_1799 stack = iterator.next();
            if (!class_1799.method_31577((class_1799)stack, (class_1799)item.getStack()) || stack.method_7947() != item.getStack().method_7947()) continue;
            item.setEjecting(false);
            item.setTargetDirection(this.routingSchedule.get(stack).getDirection());
            iterator.remove();
            return true;
        }
        return false;
    }

    public void schedule(class_1799 stack, class_2350 direction) {
        this.routingSchedule.put(stack, new ScheduledRoute(direction));
    }

    public void schedulePath(class_3218 level, ItemInPipe item, NetworkedPipeEntity target) {
        HashMap<NetworkedPipeEntity, Tuple<NetworkedPipeEntity, class_2350>> cameFrom = new HashMap<NetworkedPipeEntity, Tuple<NetworkedPipeEntity, class_2350>>();
        HashMap<NetworkedPipeEntity, Integer> gScore = new HashMap<NetworkedPipeEntity, Integer>();
        gScore.put(this, 0);
        HashMap<NetworkedPipeEntity, Integer> fScore = new HashMap<NetworkedPipeEntity, Integer>();
        fScore.put(this, 0);
        PriorityQueue<NetworkedPipeEntity> openSet = new PriorityQueue<NetworkedPipeEntity>(Comparator.comparingInt(fScore::get));
        openSet.add(this);
        while (!openSet.isEmpty()) {
            NetworkedPipeEntity current = openSet.poll();
            if (current == target) {
                while (cameFrom.containsKey((Object)current)) {
                    Tuple tuple = (Tuple)cameFrom.get((Object)current);
                    current = (NetworkedPipeEntity)((Object)tuple.a());
                    current.schedule(item.getStack(), (class_2350)tuple.b());
                    current.method_5431();
                    level.method_8413(current.method_11016(), current.method_11010(), current.method_11010(), 2);
                }
            }
            for (class_2350 side : current.networkDistances.keySet()) {
                Tuple tuple = (Tuple)current.networkDistances.get(side);
                class_2586 class_25862 = level.method_8321((class_2338)tuple.a());
                if (!(class_25862 instanceof NetworkedPipeEntity)) continue;
                NetworkedPipeEntity neighbour = (NetworkedPipeEntity)class_25862;
                int newScore = (Integer)gScore.get((Object)current) + (Integer)tuple.b();
                if (gScore.containsKey((Object)neighbour) && newScore >= (Integer)gScore.get((Object)neighbour)) continue;
                cameFrom.put(neighbour, new Tuple<NetworkedPipeEntity, class_2350>(current, side));
                gScore.put(neighbour, newScore);
                fScore.put(neighbour, newScore + this.field_11867.method_19455((class_2382)neighbour.field_11867));
                if (openSet.contains((Object)neighbour)) continue;
                openSet.add(neighbour);
            }
        }
    }

    public void setNetwork(PipeNetwork network, class_3218 level) {
        if (network != null) {
            network.addPipe(this);
        }
        this.network = network;
        this.method_5431();
        if (level != null) {
            level.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
    }

    public PipeNetwork getNetwork() {
        return this.network;
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public void setController(boolean controller) {
        this.controller = controller;
    }

    public boolean isController() {
        return this.controller;
    }

    public void disconnect(class_3218 level) {
        this.setController(false);
        this.routingSchedule.clear();
        if (this.hasNetwork()) {
            this.getNetwork().removePipe(level, this);
        }
        this.setNetwork(null, level);
    }

    public Tuple<Boolean, Set<NetworkedPipeEntity>> stillLinkedToNetwork(PipeNetwork network, class_3218 level, class_2338 thisPos, Set<NetworkedPipeEntity> visited) {
        if (visited.contains((Object)this)) {
            return new Tuple<Boolean, Set<NetworkedPipeEntity>>(false, visited);
        }
        visited.add(this);
        if (network.getPos().equals((Object)thisPos)) {
            return new Tuple<Boolean, Set<NetworkedPipeEntity>>(true, visited);
        }
        for (class_2350 direction : this.networkDistances.keySet()) {
            class_2338 nextPos = (class_2338)((Tuple)this.networkDistances.get(direction)).a();
            class_2586 class_25862 = level.method_8321(nextPos);
            if (!(class_25862 instanceof NetworkedPipeEntity)) continue;
            NetworkedPipeEntity nextPipe = (NetworkedPipeEntity)class_25862;
            Tuple<Boolean, Set<NetworkedPipeEntity>> tuple = nextPipe.stillLinkedToNetwork(network, level, nextPos, visited);
            visited = tuple.b();
            if (!tuple.a().booleanValue()) continue;
            return tuple;
        }
        return new Tuple<Boolean, Set<NetworkedPipeEntity>>(false, visited);
    }

    public Tuple<PipeNetwork, Set<NetworkedPipeEntity>> findLinkedNetwork(class_3218 level, class_2338 thisPos, Set<NetworkedPipeEntity> visited) {
        if (visited.contains((Object)this)) {
            return new Tuple<Object, Set<NetworkedPipeEntity>>(null, visited);
        }
        visited.add(this);
        if (this.hasNetwork() && this.getNetwork().getPos().equals((Object)thisPos)) {
            return new Tuple<PipeNetwork, Set<NetworkedPipeEntity>>(this.getNetwork(), visited);
        }
        for (class_2350 direction : this.networkDistances.keySet()) {
            class_2338 nextPos = (class_2338)((Tuple)this.networkDistances.get(direction)).a();
            class_2586 class_25862 = level.method_8321(nextPos);
            if (!(class_25862 instanceof NetworkedPipeEntity)) continue;
            NetworkedPipeEntity nextPipe = (NetworkedPipeEntity)class_25862;
            Tuple<PipeNetwork, Set<NetworkedPipeEntity>> tuple = nextPipe.findLinkedNetwork(level, nextPos, visited);
            visited = tuple.b();
            if (tuple.a() == null) continue;
            return tuple;
        }
        return new Tuple<Object, Set<NetworkedPipeEntity>>(null, visited);
    }

    public Set<NetworkedPipeEntity> disconnectAllLinked(class_3218 level, Set<NetworkedPipeEntity> visited) {
        if (visited.contains((Object)this)) {
            return visited;
        }
        visited.add(this);
        this.disconnect(level);
        for (class_2350 direction : this.networkDistances.keySet()) {
            class_2338 nextPos = (class_2338)((Tuple)this.networkDistances.get(direction)).a();
            class_2586 class_25862 = level.method_8321(nextPos);
            if (!(class_25862 instanceof NetworkedPipeEntity)) continue;
            NetworkedPipeEntity nextPipe = (NetworkedPipeEntity)class_25862;
            visited = nextPipe.disconnectAllLinked(level, visited);
        }
        return visited;
    }

    public void networkChanged(class_3218 level, class_2338 pos, boolean isLinked) {
        if (this.hasNetwork()) {
            if (!isLinked) {
                if (!this.stillLinkedToNetwork(this.getNetwork(), level, pos, new HashSet<NetworkedPipeEntity>()).a().booleanValue()) {
                    this.disconnectAllLinked(level, new HashSet<NetworkedPipeEntity>());
                    this.distributeNetwork(level, pos, new HashSet<NetworkedPipeEntity>(), new PipeNetwork(pos));
                }
            } else {
                this.distributeNetwork(level, pos, new HashSet<NetworkedPipeEntity>(), this.getNetwork());
            }
        } else {
            PipeNetwork network = this.findLinkedNetwork(level, pos, new HashSet<NetworkedPipeEntity>()).a();
            if (network != null) {
                this.setNetwork(network, level);
                this.setController(network.getPos().equals((Object)pos));
            } else {
                this.distributeNetwork(level, pos, new HashSet<NetworkedPipeEntity>(), new PipeNetwork(pos));
            }
        }
    }

    public void method_11012() {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.disconnect(serverLevel);
        }
        super.method_11012();
    }

    @Override
    public short getTargetSpeed() {
        return 1024;
    }

    @Override
    public short getAcceleration() {
        return 64;
    }

    public boolean isDefaultRoute() {
        return false;
    }

    @Override
    protected void method_11014(class_2487 valueInput, class_7225.class_7874 registries) {
        super.method_11014(valueInput, registries);
        this.routingSchedule.clear();
        this.setController(valueInput.method_10577("controller"));
        this.syncedNetworkPos = this.method_11016();
        if (this.isController()) {
            this.network = new PipeNetwork(this.method_11016(), SortingMode.fromByte(valueInput.method_10571("sorting_mode")));
            class_2499 requestedItems = valueInput.method_10554("requested_items", 10);
            requestedItems.forEach(tag -> MiscUtil.loadFromTag(tag, RequestedItem.CODEC, registries, this.network::addRequestedItem));
            this.syncedNetworkPos = this.method_11016();
        } else {
            MiscUtil.loadFromTag(valueInput.method_10580("synced_network_pos"), class_2338.field_25064, registries, pos -> {
                this.syncedNetworkPos = pos;
            });
        }
        class_2499 routingList = valueInput.method_10554("routing_schedule", 10);
        routingList.forEach(tag -> {
            if (tag instanceof class_2487) {
                class_2487 compoundTag = (class_2487)tag;
                int slot = compoundTag.method_10550("slot");
                MiscUtil.loadFromTag(tag, class_1799.field_24671, registries, stack -> this.routingSchedule.put((class_1799)stack, new ScheduledRoute(class_2350.method_10143((int)slot))));
            }
        });
    }

    @Override
    protected void method_11007(class_2487 valueOutput, class_7225.class_7874 registries) {
        super.method_11007(valueOutput, registries);
        valueOutput.method_10556("controller", this.isController());
        if (this.hasNetwork() && this.isController()) {
            valueOutput.method_10567("sorting_mode", this.getNetwork().getSortingMode().getValue());
            class_2499 requestedItems = new class_2499();
            for (RequestedItem requestedItem : this.getNetwork().getRequestedItems()) {
                if (requestedItem.isDelivered()) continue;
                MiscUtil.saveToTag((class_2520)new class_2487(), requestedItem, RequestedItem.CODEC, registries, arg_0 -> requestedItems.add(arg_0));
            }
            valueOutput.method_10566("requested_items", (class_2520)requestedItems);
        }
        valueOutput.method_10566("synced_network_pos", (class_2520)class_2338.field_25064.encodeStart((DynamicOps)class_2509.field_11560, (Object)(this.hasNetwork() ? this.network.getPos() : this.method_11016())).getOrThrow());
        class_2499 routingList = new class_2499();
        for (class_1799 stack : this.routingSchedule.keySet()) {
            class_2487 tag = new class_2487();
            tag.method_10569("slot", this.routingSchedule.get(stack).getDirection().method_10146());
            MiscUtil.saveToTag((class_2520)tag, stack, class_1799.field_24671, registries, arg_0 -> routingList.add(arg_0));
        }
        valueOutput.method_10566("routing_schedule", (class_2520)routingList);
    }
}

