/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.MatchingPipe;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.blockentity.ProviderPipe;
import jagm.classicpipes.blockentity.RecipePipeEntity;
import jagm.classicpipes.blockentity.RoutingPipeEntity;
import jagm.classicpipes.blockentity.StockingPipeEntity;
import jagm.classicpipes.inventory.menu.RequestMenu;
import jagm.classicpipes.network.ClientBoundItemListPayload;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.MissingItem;
import jagm.classicpipes.util.RequestedItem;
import jagm.classicpipes.util.SortingMode;
import jagm.classicpipes.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class PipeNetwork {
    private static final byte DEFAULT_COOLDOWN = 40;
    private final class_2338 pos;
    private final Set<RoutingPipeEntity> routingPipes = new HashSet<RoutingPipeEntity>();
    private final Set<NetworkedPipeEntity> defaultRoutes = new HashSet<NetworkedPipeEntity>();
    private final Set<ProviderPipe> providerPipes = new LinkedHashSet<ProviderPipe>();
    private final Set<StockingPipeEntity> stockingPipes = new HashSet<StockingPipeEntity>();
    private final Set<MatchingPipe> matchingPipes = new HashSet<MatchingPipe>();
    private final Set<RecipePipeEntity> recipePipes = new HashSet<RecipePipeEntity>();
    private SortingMode sortingMode;
    private boolean cacheChanged;
    private byte cacheCooldown;
    private final List<RequestedItem> requestedItems;
    private final List<Tuple<ProviderPipe, RequestedItem>> queue;
    private final Map<ProviderPipe, List<class_1799>> takenFromCache;
    private final List<class_1799> spareItems;
    private final Set<class_1792> craftedItemsForAdvancement;

    public PipeNetwork(class_2338 pos, SortingMode sortingMode) {
        this.sortingMode = sortingMode;
        this.pos = pos;
        this.cacheChanged = false;
        this.cacheCooldown = 0;
        this.requestedItems = new ArrayList<RequestedItem>();
        this.queue = new ArrayList<Tuple<ProviderPipe, RequestedItem>>();
        this.takenFromCache = new HashMap<ProviderPipe, List<class_1799>>();
        this.spareItems = new ArrayList<class_1799>();
        this.craftedItemsForAdvancement = new HashSet<class_1792>();
    }

    public PipeNetwork(class_2338 pos) {
        this(pos, SortingMode.AMOUNT_DESCENDING);
    }

    private void enqueue(class_1799 stack, int amount, class_2338 requestPos, String playerName, ProviderPipe providerPipe) {
        RequestedItem requestedItem = new RequestedItem(stack.method_46651(amount), requestPos, playerName);
        boolean matched = false;
        for (Tuple<ProviderPipe, RequestedItem> tuple : this.queue) {
            if (tuple.a() != providerPipe || !requestedItem.matches(tuple.b())) continue;
            matched = true;
            tuple.b().getStack().method_7933(amount);
            break;
        }
        if (!matched) {
            this.queue.add(new Tuple<ProviderPipe, RequestedItem>(providerPipe, requestedItem));
        }
    }

    private MissingItem queueRequest(class_1799 stack, class_2338 requestPos, class_1657 player, List<class_1799> visited) {
        MissingItem missingItem = new MissingItem(stack.method_7972());
        String playerName = player != null ? player.method_5477().getString() : "";
        ListIterator<class_1799> iterator = this.spareItems.listIterator();
        while (iterator.hasNext()) {
            class_1799 spareItem = (class_1799)iterator.next();
            if (!class_1799.method_31577((class_1799)spareItem, (class_1799)stack)) continue;
            int amount = Math.min(spareItem.method_7947(), missingItem.getCount());
            spareItem.method_7934(amount);
            missingItem.shrink(amount);
            if (spareItem.method_7960()) {
                iterator.remove();
            }
            this.enqueue(stack, amount, requestPos, playerName, null);
            break;
        }
        if (!missingItem.isEmpty()) {
            block1: for (ProviderPipe providerPipe : this.providerPipes) {
                if (missingItem.isEmpty()) break;
                ArrayList<class_1799> alreadyTaken = this.takenFromCache.containsKey(providerPipe) ? this.takenFromCache.get(providerPipe) : new ArrayList<class_1799>();
                for (class_1799 cacheStack : providerPipe.getCache()) {
                    int amount;
                    class_1799 takenStack;
                    if (!class_1799.method_31577((class_1799)stack, (class_1799)cacheStack)) continue;
                    int cacheCount = cacheStack.method_7947();
                    int takenIndex = -1;
                    for (int i = 0; i < alreadyTaken.size(); ++i) {
                        takenStack = (class_1799)alreadyTaken.get(i);
                        if (!class_1799.method_31577((class_1799)cacheStack, (class_1799)takenStack)) continue;
                        cacheCount -= takenStack.method_7947();
                        takenIndex = i;
                        break;
                    }
                    if ((amount = Math.min(missingItem.getCount(), cacheCount)) <= 0) continue block1;
                    this.enqueue(stack, amount, requestPos, playerName, providerPipe);
                    missingItem.shrink(amount);
                    if (takenIndex >= 0) {
                        takenStack = (class_1799)alreadyTaken.get(takenIndex);
                        alreadyTaken.set(takenIndex, takenStack.method_46651(takenStack.method_7947() + amount));
                    } else {
                        alreadyTaken.add(cacheStack.method_46651(amount));
                    }
                    this.takenFromCache.put(providerPipe, alreadyTaken);
                    continue block1;
                }
            }
        }
        if (!missingItem.isEmpty()) {
            boolean foundCraftingPipe = false;
            for (RecipePipeEntity craftingPipe : this.recipePipes) {
                class_1799 result = craftingPipe.getResult();
                if (!class_1799.method_31577((class_1799)result, (class_1799)stack)) continue;
                if (foundCraftingPipe) {
                    if (player == null) break;
                    player.method_7353((class_2561)class_2561.method_43469((String)"chat.classicpipes.multiple_recipes", (Object[])new Object[]{stack.method_7909().method_7848()}).method_27692(class_124.field_1054), false);
                    break;
                }
                int requiredCrafts = Math.ceilDiv(missingItem.getCount(), result.method_7947());
                List<class_1799> ingredients = craftingPipe.getIngredientsCollated();
                boolean canCraft = true;
                for (class_1799 ingredient : ingredients) {
                    boolean alreadyVisited = false;
                    for (class_1799 visitedStack : visited) {
                        if (!class_1799.method_31577((class_1799)visitedStack, (class_1799)ingredient)) continue;
                        alreadyVisited = true;
                        canCraft = false;
                        break;
                    }
                    if (alreadyVisited) continue;
                    ArrayList<class_1799> visited2 = new ArrayList<class_1799>(visited);
                    visited2.add(stack);
                    MissingItem missingForCraft = this.queueRequest(ingredient.method_46651(ingredient.method_7947() * requiredCrafts), craftingPipe.method_11016(), player, visited2);
                    if (missingForCraft.isEmpty()) continue;
                    missingItem.addMissingIngredient(missingForCraft);
                    canCraft = false;
                }
                if (canCraft) {
                    int amount = Math.min(result.method_7947() * requiredCrafts, missingItem.getCount());
                    missingItem.shrink(amount);
                    this.enqueue(stack, amount, requestPos, playerName, null);
                    if (result.method_7947() * requiredCrafts > amount) {
                        int remaining = result.method_7947() * requiredCrafts - amount;
                        boolean matched = false;
                        for (class_1799 spareItem : this.spareItems) {
                            if (!class_1799.method_31577((class_1799)spareItem, (class_1799)stack)) continue;
                            spareItem.method_7933(remaining);
                            matched = true;
                            break;
                        }
                        if (!matched) {
                            this.spareItems.add(stack.method_46651(remaining));
                        }
                    }
                    this.craftedItemsForAdvancement.add(result.method_7909());
                }
                foundCraftingPipe = true;
            }
        }
        return missingItem;
    }

    public void request(class_3218 level, class_1799 stack, class_2338 requestPos, class_1657 player, boolean partialRequest) {
        block6: {
            MissingItem missingItem;
            block4: {
                block5: {
                    missingItem = this.queueRequest(stack.method_7972(), requestPos, player, new ArrayList<class_1799>());
                    if (!missingItem.isEmpty()) break block4;
                    boolean cancelled = false;
                    for (Tuple<ProviderPipe, RequestedItem> tuple2 : this.queue) {
                        this.addRequestedItem(tuple2.b());
                        if (tuple2.a() == null || tuple2.a().extractItem(level, tuple2.b().getStack())) continue;
                        cancelled = true;
                        if (partialRequest) break;
                        tuple2.b().sendMessage(level, (class_2561)class_2561.method_43469((String)"chat.classicpipes.could_not_extract", (Object[])new Object[]{stack.method_7947(), stack.method_7909().method_7848(), tuple2.a().getProviderPipePos().method_23854()}).method_27692(class_124.field_1061));
                        break;
                    }
                    if (!cancelled) break block5;
                    this.queue.forEach(tuple -> this.removeRequestedItem((RequestedItem)tuple.b()));
                    break block6;
                }
                if (player == null) break block6;
                player.method_7339(ClassicPipes.ITEMS_REQUESTED_STAT, stack.method_7947());
                ClassicPipes.REQUEST_ITEM_TRIGGER.trigger((class_3222)player, stack, this.craftedItemsForAdvancement.size());
                player.method_7353((class_2561)class_2561.method_43469((String)"chat.classicpipes.requested", (Object[])new Object[]{stack.method_7947(), stack.method_7909().method_7848()}).method_27692(class_124.field_1060), false);
                break block6;
            }
            if (partialRequest && missingItem.getCount() < stack.method_7947()) {
                this.resetForNewRequest();
                this.request(level, stack.method_46651(stack.method_7947() - missingItem.getCount()), requestPos, player, false);
                return;
            }
            if (player != null) {
                player.method_7353((class_2561)class_2561.method_43469((String)"chat.classicpipes.missing_item.a", (Object[])new Object[]{stack.method_7947(), stack.method_7909().method_7848()}).method_27692(class_124.field_1061), false);
                for (class_1799 missing : missingItem.getBaseItems(new ArrayList<class_1799>())) {
                    player.method_7353((class_2561)class_2561.method_43469((String)"chat.classicpipes.missing_item.b", (Object[])new Object[]{missing.method_7947(), missing.method_7909().method_7848()}).method_27692(class_124.field_1054), false);
                }
            }
        }
        this.resetForNewRequest();
    }

    private void resetForNewRequest() {
        this.queue.clear();
        this.takenFromCache.clear();
        this.spareItems.clear();
        this.craftedItemsForAdvancement.clear();
    }

    public void tick(class_3218 level) {
        int updatablePipesCount = this.providerPipes.size() + this.matchingPipes.size() + this.stockingPipes.size();
        int pipeToUpdate = level.method_8409().method_43048(Math.max(100, updatablePipesCount));
        if (pipeToUpdate < this.providerPipes.size()) {
            i = 0;
            for (ProviderPipe providerPipe : this.providerPipes) {
                if (i == pipeToUpdate) {
                    class_2350 facing = providerPipe.getFacing();
                    if (facing == null) break;
                    providerPipe.updateCache();
                    break;
                }
                ++i;
            }
        } else if (pipeToUpdate < this.providerPipes.size() + this.matchingPipes.size()) {
            i = 0;
            for (MatchingPipe matchingPipe : this.matchingPipes) {
                if (i == pipeToUpdate) {
                    matchingPipe.updateCache();
                    break;
                }
                ++i;
            }
        } else if (pipeToUpdate < updatablePipesCount) {
            i = 0;
            for (Object stockingPipe : this.stockingPipes) {
                if (i == pipeToUpdate) {
                    stockingPipe.updateCache();
                    break;
                }
                ++i;
            }
        }
        if (this.cacheChanged && this.cacheCooldown <= 0) {
            List playerList = level.method_18766(player -> {
                RequestMenu menu;
                class_1703 patt0$temp = player.field_7512;
                return patt0$temp instanceof RequestMenu && (menu = (RequestMenu)patt0$temp).getNetworkPos().equals((Object)this.getPos());
            });
            if (!playerList.isEmpty()) {
                ClientBoundItemListPayload toSend = this.requestItemList(this.pos);
                for (class_3222 player2 : playerList) {
                    Services.LOADER_SERVICE.sendToClient(player2, toSend);
                }
            }
            for (Object stockingPipe : this.stockingPipes) {
                if (!stockingPipe.isActiveStocking()) continue;
                stockingPipe.tryRequests(level);
            }
            this.cacheChanged = false;
            this.cacheCooldown = (byte)40;
        } else if (this.cacheCooldown > 0) {
            this.cacheCooldown = (byte)(this.cacheCooldown - 1);
        }
        this.getRequestedItems().removeIf(requestedItem -> {
            if (requestedItem.timedOut()) {
                requestedItem.sendMessage(level, (class_2561)class_2561.method_43469((String)"chat.classicpipes.timed_out", (Object[])new Object[]{requestedItem.getAmountRemaining(), requestedItem.getStack().method_7909().method_7848()}).method_27692(class_124.field_1061));
                for (RecipePipeEntity craftingPipe : this.recipePipes) {
                    if (!requestedItem.matches(craftingPipe.getResult())) continue;
                    craftingPipe.dropHeldItems(level, craftingPipe.method_11016());
                }
                return true;
            }
            return false;
        });
    }

    public void resetRequests(class_3218 level) {
        this.requestedItems.clear();
        for (RecipePipeEntity craftingPipe : this.recipePipes) {
            craftingPipe.dropHeldItems(level, craftingPipe.method_11016());
        }
    }

    public Set<RoutingPipeEntity> getRoutingPipes() {
        return this.routingPipes;
    }

    public Set<NetworkedPipeEntity> getDefaultRoutes() {
        return this.defaultRoutes;
    }

    public Set<StockingPipeEntity> getStockingPipes() {
        return this.stockingPipes;
    }

    public Set<MatchingPipe> getMatchingPipes() {
        return this.matchingPipes;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public void addPipe(NetworkedPipeEntity pipe) {
        if (pipe.isDefaultRoute()) {
            this.defaultRoutes.add(pipe);
        }
        if (pipe instanceof RoutingPipeEntity) {
            RoutingPipeEntity routingPipe = (RoutingPipeEntity)pipe;
            this.routingPipes.add(routingPipe);
        }
        if (pipe instanceof ProviderPipe) {
            ProviderPipe providerPipe = (ProviderPipe)((Object)pipe);
            this.providerPipes.add(providerPipe);
        }
        if (pipe instanceof StockingPipeEntity) {
            StockingPipeEntity stockingPipe = (StockingPipeEntity)pipe;
            this.stockingPipes.add(stockingPipe);
        }
        if (pipe instanceof MatchingPipe) {
            MatchingPipe matchingPipe = (MatchingPipe)((Object)pipe);
            this.matchingPipes.add(matchingPipe);
        }
        if (pipe instanceof RecipePipeEntity) {
            RecipePipeEntity recipePipe = (RecipePipeEntity)pipe;
            this.recipePipes.add(recipePipe);
        }
    }

    public void removePipe(class_3218 level, NetworkedPipeEntity pipe) {
        if (pipe.isDefaultRoute()) {
            this.defaultRoutes.remove((Object)pipe);
        }
        if (pipe instanceof RoutingPipeEntity) {
            RoutingPipeEntity routingPipe = (RoutingPipeEntity)pipe;
            this.routingPipes.remove((Object)routingPipe);
        }
        if (pipe instanceof ProviderPipe) {
            ProviderPipe providerPipe = (ProviderPipe)((Object)pipe);
            this.providerPipes.remove(providerPipe);
        }
        if (pipe instanceof StockingPipeEntity) {
            StockingPipeEntity stockingPipe = (StockingPipeEntity)pipe;
            this.stockingPipes.remove((Object)stockingPipe);
        }
        if (pipe instanceof MatchingPipe) {
            MatchingPipe matchingPipe = (MatchingPipe)((Object)pipe);
            this.matchingPipes.remove(matchingPipe);
        }
        if (pipe instanceof RecipePipeEntity) {
            RecipePipeEntity recipePipe = (RecipePipeEntity)pipe;
            this.recipePipes.remove((Object)recipePipe);
        }
        this.requestedItems.removeIf(requestedItem -> {
            if (requestedItem.getDestination().equals((Object)pipe.method_11016())) {
                requestedItem.sendMessage(level, (class_2561)class_2561.method_43469((String)"chat.classicpipes.destination_removed", (Object[])new Object[]{requestedItem.getAmountRemaining(), requestedItem.getStack().method_7909().method_7848(), pipe.method_11016().method_23854()}).method_27692(class_124.field_1061));
                return true;
            }
            return false;
        });
    }

    public ClientBoundItemListPayload requestItemList(class_2338 requestPos) {
        ArrayList<class_1799> existingItems = new ArrayList<class_1799>();
        for (ProviderPipe providerPipe : this.providerPipes) {
            for (class_1799 stack : providerPipe.getCache()) {
                boolean alreadyThere = false;
                for (class_1799 inStack : existingItems) {
                    if (!class_1799.method_31577((class_1799)stack, (class_1799)inStack)) continue;
                    inStack.method_7933(stack.method_7947());
                    if (inStack.method_7947() < 0) {
                        inStack.method_7939(Integer.MAX_VALUE);
                    }
                    alreadyThere = true;
                    break;
                }
                if (alreadyThere) continue;
                existingItems.add(stack.method_7972());
            }
        }
        ArrayList<class_1799> craftableItems = new ArrayList<class_1799>();
        for (RecipePipeEntity recipePipe : this.recipePipes) {
            class_1799 result = recipePipe.getResult();
            if (result.method_7960()) continue;
            boolean matched = false;
            for (class_1799 alreadyCraftable : craftableItems) {
                if (!class_1799.method_31577((class_1799)alreadyCraftable, (class_1799)result)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            craftableItems.add(result.method_46651(1));
        }
        return new ClientBoundItemListPayload(existingItems, craftableItems, this.sortingMode, this.pos, requestPos);
    }

    public void cacheUpdated() {
        this.cacheChanged = true;
    }

    public void setSortingMode(SortingMode sortingMode) {
        this.sortingMode = sortingMode;
    }

    public SortingMode getSortingMode() {
        return this.sortingMode;
    }

    public List<RequestedItem> getRequestedItems() {
        return this.requestedItems;
    }

    public void removeRequestedItem(RequestedItem requestedItem) {
        this.requestedItems.remove(requestedItem);
    }

    public void addRequestedItem(RequestedItem requestedItem) {
        this.requestedItems.add(requestedItem);
    }
}

