/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.NetworkedPipeBlock;
import jagm.classicpipes.block.RecipePipeBlock;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.inventory.container.FilterContainer;
import jagm.classicpipes.inventory.menu.RecipePipeMenu;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.RequestedItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_7225;
import net.minecraft.class_8887;

public class RecipePipeEntity
extends NetworkedPipeEntity
implements class_3908 {
    private static final byte DEFAULT_COOLDOWN = 8;
    private final FilterContainer filter = new FilterContainer(this, 10, true);
    private final class_2350[] slotDirections = new class_2350[10];
    private final class_2371<class_1799> heldItems;
    private int waitingForCraft;
    private boolean crafterTicked;
    private byte cooldown;

    public RecipePipeEntity(class_2338 pos, class_2680 state) {
        super(ClassicPipes.RECIPE_PIPE_ENTITY, pos, state);
        List<class_2350> buttonDirections = this.getDirectionsForButtons(state);
        Arrays.fill(this.slotDirections, buttonDirections.isEmpty() ? class_2350.field_11033 : buttonDirections.getFirst());
        this.heldItems = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    }

    public class_2350[] getSlotDirections() {
        return this.slotDirections;
    }

    public void setSlotDirection(int slot, class_2350 direction) {
        this.slotDirections[slot] = direction;
    }

    @Override
    public void tickServer(class_3218 level, class_2338 pos, class_2680 state) {
        super.tickServer(level, pos, state);
        class_2338 crafterPos = pos.method_10093(this.slotDirections[9]);
        if (this.crafterTicked && this.hasNetwork()) {
            for (RequestedItem requestedItem : this.getNetwork().getRequestedItems()) {
                if (!requestedItem.matches(this.getResult())) continue;
                requestedItem.sendMessage(level, (class_2561)class_2561.method_43469((String)"chat.classicpipes.crafter_jammed", (Object[])new Object[]{crafterPos.method_23854()}).method_27692(class_124.field_1061));
            }
            this.getNetwork().resetRequests(level);
            this.crafterTicked = false;
            this.waitingForCraft = 0;
            this.method_5431();
            level.method_8413(pos, state, state, 2);
        } else if (this.waitingForCraft > 0) {
            class_2586 container = level.method_8321(crafterPos);
            if (container instanceof class_8887) {
                class_8887 crafter = (class_8887)container;
                if (this.isEmpty()) {
                    level.method_39279(crafterPos, crafter.method_11010().method_26204(), 0);
                    level.method_45447(null, crafterPos, class_3417.field_46765, class_3419.field_15245);
                    this.crafterTicked = true;
                }
            } else {
                byte by = this.cooldown;
                this.cooldown = (byte)(by - 1);
                if (by <= 0) {
                    if (!(container instanceof ItemPipeEntity) && Services.LOADER_SERVICE.extractSpecificItem(this, level, crafterPos, this.slotDirections[9].method_10153(), this.getResult().method_46651(1))) {
                        level.method_8413(pos, state, state, 2);
                        this.method_5431();
                    }
                    this.cooldown = (byte)8;
                }
            }
        } else if (!this.queued.isEmpty()) {
            this.addQueuedItems((class_1937)level, false);
        }
    }

    @Override
    public void update(class_3218 level, class_2680 state, class_2338 pos, class_2350 direction, boolean wasConnected) {
        super.update(level, state, pos, direction, wasConnected);
        this.checkSlotDirections();
    }

    @Override
    protected void initialiseNetworking(class_3218 level, class_2680 state, class_2338 pos) {
        super.initialiseNetworking(level, state, pos);
        this.checkSlotDirections();
    }

    private void checkSlotDirections() {
        List<class_2350> buttonDirections = this.getDirectionsForButtons(this.method_11010());
        if (!buttonDirections.isEmpty()) {
            for (int i = 0; i < this.slotDirections.length; ++i) {
                if (buttonDirections.contains(this.slotDirections[i])) continue;
                this.slotDirections[i] = buttonDirections.getFirst();
                this.method_5431();
            }
        }
    }

    @Override
    public void eject(class_3218 level, class_2338 pos, ItemInPipe item) {
        ArrayList<Integer> matchingSlots = new ArrayList<Integer>();
        for (int slot = 0; slot < 9; ++slot) {
            if (!class_1799.method_31577((class_1799)this.filter.method_5438(slot), (class_1799)item.getStack())) continue;
            matchingSlots.add(slot);
        }
        if (!matchingSlots.isEmpty()) {
            class_1799 stack = item.getStack().method_7972();
            while (!stack.method_7960()) {
                int minSlot = (Integer)matchingSlots.getFirst();
                int minAmount = ((class_1799)this.heldItems.get(minSlot)).method_7947();
                Iterator iterator = matchingSlots.iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    int slotAmount = ((class_1799)this.heldItems.get(slot)).method_7947();
                    if (slotAmount >= minAmount) continue;
                    minSlot = slot;
                    minAmount = slotAmount;
                }
                this.heldItems.set(minSlot, (Object)stack.method_46651(((class_1799)this.heldItems.get(minSlot)).method_7947() + 1));
                stack.method_7934(1);
            }
        } else {
            super.eject(level, pos, item);
        }
        this.attemptCraft();
        this.method_5431();
    }

    private void attemptCraft() {
        if (this.waitingForCraft == 0) {
            boolean readyToCraft = true;
            for (int slot = 0; slot < 9; ++slot) {
                if (((class_1799)this.heldItems.get(slot)).method_7947() < this.filter.method_5438(slot).method_7947()) {
                    readyToCraft = false;
                    break;
                }
                class_2680 state = this.method_11010();
                if (this.filter.method_5438(slot).method_7960() || ((NetworkedPipeBlock.ConnectionState)((Object)state.method_11654((class_2769)RecipePipeBlock.PROPERTY_BY_DIRECTION.get(this.slotDirections[slot])))).equals((Object)NetworkedPipeBlock.ConnectionState.UNLINKED)) continue;
                readyToCraft = false;
                class_1937 class_19372 = this.method_10997();
                if (!(class_19372 instanceof class_3218)) break;
                class_3218 serverLevel = (class_3218)class_19372;
                if (!this.hasNetwork()) break;
                for (RequestedItem requestedItem : this.getNetwork().getRequestedItems()) {
                    if (!requestedItem.matches(this.getResult())) continue;
                    requestedItem.sendMessage(serverLevel, (class_2561)class_2561.method_43469((String)"chat.classicpipes.missing_recipe_pipe_direction", (Object[])new Object[]{this.method_11016().method_23854()}).method_27692(class_124.field_1061));
                }
                this.crafterTicked = false;
                this.waitingForCraft = 0;
                this.getNetwork().resetRequests(serverLevel);
                this.method_5431();
                serverLevel.method_8413(this.method_11016(), state, state, 2);
                break;
            }
            if (readyToCraft) {
                HashMap<class_2350, class_8887> crafters = new HashMap<class_2350, class_8887>();
                for (int slot = 0; slot < 9; ++slot) {
                    class_2586 class_25862;
                    class_1799 ingredient = this.filter.method_5438(slot);
                    if (crafters.containsKey(this.slotDirections[slot])) {
                        ((class_8887)crafters.get(this.slotDirections[slot])).method_54480(slot, !ingredient.method_7960());
                    } else if (this.method_10997() != null && (class_25862 = this.method_10997().method_8321(this.method_11016().method_10093(this.slotDirections[slot]))) instanceof class_8887) {
                        class_8887 crafter = (class_8887)class_25862;
                        crafters.put(this.slotDirections[slot], crafter);
                        crafter.method_54480(slot, !ingredient.method_7960());
                    }
                    if (ingredient.method_7960()) continue;
                    ((class_1799)this.heldItems.get(slot)).method_7934(ingredient.method_7947());
                    this.queued.add(new ItemInPipe(ingredient.method_7972(), 64, 1024, class_2350.field_11033, this.slotDirections[slot], false, 0));
                }
                this.waitingForCraft = this.getResult().method_7947();
            }
        }
    }

    public class_1799 getResult() {
        return this.filter.method_5438(9).method_7972();
    }

    public List<class_1799> getIngredients() {
        ArrayList<class_1799> ingredients = new ArrayList<class_1799>();
        for (int i = 0; i < 9; ++i) {
            class_1799 ingredient = this.filter.method_5438(i).method_7972();
            if (ingredient.method_7960()) continue;
            ingredients.add(ingredient);
        }
        return ingredients;
    }

    public List<class_1799> getIngredientsCollated() {
        List<class_1799> ingredients = this.getIngredients();
        ArrayList<class_1799> collated = new ArrayList<class_1799>();
        for (class_1799 ingredient : ingredients) {
            boolean matched = false;
            for (class_1799 stack : collated) {
                if (!class_1799.method_31577((class_1799)ingredient, (class_1799)stack)) continue;
                stack.method_7933(ingredient.method_7947());
                matched = true;
                break;
            }
            if (matched) continue;
            collated.add(ingredient);
        }
        return collated;
    }

    public class_2371<class_1799> getHeldItems() {
        return this.heldItems;
    }

    public void dropHeldItems(class_3218 serverLevel, class_2338 pos) {
        for (class_1799 stack : this.heldItems) {
            if (stack.method_7960()) continue;
            class_1542 droppedItem = new class_1542((class_1937)serverLevel, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f), stack);
            droppedItem.method_6988();
            serverLevel.method_8649((class_1297)droppedItem);
        }
        this.heldItems.clear();
    }

    @Override
    public void disconnect(class_3218 level) {
        this.dropHeldItems(level, this.method_11016());
        super.disconnect(level);
    }

    @Override
    public void method_11012() {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            super.disconnect(serverLevel);
        }
        this.field_11865 = true;
    }

    @Override
    public void insertPipeItem(class_1937 level, ItemInPipe item) {
        class_1799 stack = item.getStack();
        if (!stack.method_7960() && this.waitingForCraft > 0 && item.getFromDirection().equals((Object)this.slotDirections[9]) && class_1799.method_31577((class_1799)this.getResult(), (class_1799)stack)) {
            this.waitingForCraft -= stack.method_7947();
            if (this.waitingForCraft <= 0) {
                this.waitingForCraft = 0;
                this.crafterTicked = false;
                this.attemptCraft();
            }
        }
        super.insertPipeItem(level, item);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.classicpipes.recipe_pipe");
    }

    public class_1703 createMenu(int id, class_1661 playerInventory, class_1657 player) {
        return new RecipePipeMenu(id, playerInventory, this.filter, this.slotDirections, this.getDirectionsForButtons(this.method_11010()), this.method_11016());
    }

    public List<class_2350> getDirectionsForButtons(class_2680 state) {
        ArrayList<class_2350> availableDirections = new ArrayList<class_2350>();
        for (class_2350 direction : class_2350.values()) {
            if (!((NetworkedPipeBlock.ConnectionState)((Object)state.method_11654((class_2769)NetworkedPipeBlock.PROPERTY_BY_DIRECTION.get(direction)))).equals((Object)NetworkedPipeBlock.ConnectionState.UNLINKED)) continue;
            availableDirections.add(direction);
        }
        return availableDirections;
    }

    @Override
    protected void method_11014(class_2487 valueInput, class_7225.class_7874 registries) {
        this.filter.method_5448();
        this.heldItems.clear();
        super.method_11014(valueInput, registries);
        byte[] directionsByteList = valueInput.method_10547("slot_directions");
        int i = 0;
        for (byte directionByte : directionsByteList) {
            if (i >= 10) break;
            this.slotDirections[i] = class_2350.method_10143((int)directionByte);
            ++i;
        }
        class_2499 filterList = valueInput.method_10554("filter", 10);
        filterList.forEach(tag -> {
            if (tag instanceof class_2487) {
                class_2487 compoundTag = (class_2487)tag;
                int slot = compoundTag.method_10550("slot");
                MiscUtil.loadFromTag(tag, class_1799.field_24671, registries, stack -> this.filter.method_5447(slot, (class_1799)stack));
            }
        });
        class_2499 heldItemList = valueInput.method_10554("held_items", 10);
        heldItemList.forEach(tag -> {
            class_2487 compoundTag;
            int slot;
            if (tag instanceof class_2487 && (slot = (compoundTag = (class_2487)tag).method_10550("slot")) >= 0 && slot < 9) {
                MiscUtil.loadFromTag(tag, class_1799.field_24671, registries, stack -> this.heldItems.set(slot, stack));
            }
        });
        this.waitingForCraft = valueInput.method_10550("waiting_for_craft");
        this.crafterTicked = valueInput.method_10577("crafter_ticked");
        this.cooldown = valueInput.method_10571("cooldown");
    }

    @Override
    protected void method_11007(class_2487 valueOutput, class_7225.class_7874 registries) {
        super.method_11007(valueOutput, registries);
        byte[] directionsByteArray = new byte[10];
        for (int i = 0; i < this.slotDirections.length; ++i) {
            directionsByteArray[i] = this.slotDirections[i] == null ? (byte)0 : (byte)this.slotDirections[i].method_10146();
        }
        valueOutput.method_10570("slot_directions", directionsByteArray);
        class_2499 filterList = new class_2499();
        for (int slot = 0; slot < this.filter.method_5439(); ++slot) {
            class_1799 stack = this.filter.method_5438(slot);
            if (stack.method_7960()) continue;
            class_2487 tag = new class_2487();
            tag.method_10569("slot", slot);
            MiscUtil.saveToTag((class_2520)tag, stack, class_1799.field_24671, registries, arg_0 -> filterList.add(arg_0));
        }
        valueOutput.method_10566("filter", (class_2520)filterList);
        class_2499 heldItemList = new class_2499();
        for (int slot = 0; slot < this.heldItems.size(); ++slot) {
            class_1799 stack = (class_1799)this.heldItems.get(slot);
            if (stack.method_7960()) continue;
            class_2487 tag = new class_2487();
            tag.method_10569("slot", slot);
            MiscUtil.saveToTag((class_2520)tag, stack, class_1799.field_24671, registries, arg_0 -> heldItemList.add(arg_0));
        }
        valueOutput.method_10566("held_items", (class_2520)heldItemList);
        valueOutput.method_10569("waiting_for_craft", this.waitingForCraft);
        valueOutput.method_10556("crafter_ticked", this.crafterTicked);
        valueOutput.method_10567("cooldown", this.cooldown);
    }
}

