/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.StockingPipeBlock;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.inventory.container.FilterContainer;
import jagm.classicpipes.inventory.menu.StockingPipeMenu;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.RequestedItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StockingPipeEntity
extends NetworkedPipeEntity
implements MenuProvider {
    private final FilterContainer filter = new FilterContainer(this, 9, true);
    private boolean activeStocking = false;
    private final List<ItemStack> missingItemsCache = new ArrayList<ItemStack>();
    private boolean cacheInitialised = false;

    public StockingPipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.STOCKING_PIPE_ENTITY, pos, state);
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        super.tickServer(level, pos, state);
        if (!this.cacheInitialised && !((FacingOrNone)((Object)state.getValue((Property)StockingPipeBlock.FACING))).equals((Object)FacingOrNone.NONE)) {
            this.updateCache(level);
            this.cacheInitialised = true;
        }
    }

    public void updateCache(ServerLevel level) {
        this.missingItemsCache.clear();
        Direction facing = ((FacingOrNone)((Object)this.getBlockState().getValue((Property)StockingPipeBlock.FACING))).getDirection();
        if (facing != null) {
            ArrayList<ItemStack> filterItems = new ArrayList<ItemStack>();
            for (int i = 0; i < this.filter.getContainerSize(); ++i) {
                ItemStack stack = this.filter.getItem(i);
                if (stack.isEmpty()) continue;
                MiscUtil.mergeStackIntoList(filterItems, stack.copy());
            }
            if (!filterItems.isEmpty()) {
                List<ItemStack> containerItems = Services.LOADER_SERVICE.getContainerItems(level, this.getBlockPos().relative(facing), facing.getOpposite());
                for (ItemStack filterStack : filterItems) {
                    boolean matched = false;
                    for (ItemStack containerStack : containerItems) {
                        if (!ItemStack.isSameItemSameComponents((ItemStack)filterStack, (ItemStack)containerStack)) continue;
                        matched = true;
                        int missing = filterStack.getCount() - containerStack.getCount();
                        if (missing <= 0) break;
                        this.missingItemsCache.add(containerStack.copyWithCount(missing));
                        break;
                    }
                    if (matched) continue;
                    this.missingItemsCache.add(filterStack);
                }
            }
        }
        if (this.activeStocking) {
            this.tryRequests(level);
        }
    }

    public void updateCache() {
        this.cacheInitialised = false;
    }

    public void tryRequests(ServerLevel level) {
        if (this.hasNetwork()) {
            for (ItemStack stack : this.missingItemsCache) {
                int alreadyRequested = this.getAlreadyRequested(stack);
                if (alreadyRequested >= stack.getCount()) continue;
                this.getNetwork().request(level, stack.copyWithCount(stack.getCount() - alreadyRequested), this.getBlockPos(), null, true);
            }
        }
    }

    public int getAlreadyRequested(ItemStack stack) {
        int alreadyRequested = 0;
        for (ItemInPipe item : this.contents) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)item.getStack())) continue;
            alreadyRequested += item.getStack().getCount();
        }
        for (RequestedItem requestedItem : this.getNetwork().getRequestedItems()) {
            if (!requestedItem.matches(stack) || !requestedItem.getDestination().equals((Object)this.getBlockPos())) continue;
            alreadyRequested += requestedItem.getAmountRemaining();
        }
        return alreadyRequested;
    }

    public boolean isActiveStocking() {
        return this.activeStocking;
    }

    public void setActiveStocking(boolean activeStocking) {
        Level level;
        this.activeStocking = activeStocking;
        if (activeStocking && (level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.tryRequests(serverLevel);
        }
    }

    public boolean shouldMatchComponents() {
        return this.filter.shouldMatchComponents();
    }

    public List<ItemStack> getMissingItemsCache() {
        return this.missingItemsCache;
    }

    @Override
    protected void loadAdditional(CompoundTag valueInput, HolderLookup.Provider registries) {
        this.filter.clearContent();
        super.loadAdditional(valueInput, registries);
        ListTag filterList = valueInput.getList("filter", 10);
        filterList.forEach(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                int slot = compoundTag.getInt("slot");
                MiscUtil.loadFromTag(tag, ItemStack.CODEC, registries, stack -> this.filter.setItem(slot, (ItemStack)stack));
            }
        });
        this.filter.setMatchComponents(valueInput.getBoolean("match_components"));
        this.activeStocking = valueInput.getBoolean("active_stocking");
    }

    @Override
    protected void saveAdditional(CompoundTag valueOutput, HolderLookup.Provider registries) {
        super.saveAdditional(valueOutput, registries);
        ListTag filterList = new ListTag();
        for (int slot = 0; slot < this.filter.getContainerSize(); ++slot) {
            ItemStack stack = this.filter.getItem(slot);
            if (stack.isEmpty()) continue;
            CompoundTag tag = new CompoundTag();
            tag.putInt("slot", slot);
            MiscUtil.saveToTag((Tag)tag, stack, ItemStack.CODEC, registries, arg_0 -> filterList.add(arg_0));
        }
        valueOutput.put("filter", (Tag)filterList);
        valueOutput.putBoolean("match_components", this.filter.shouldMatchComponents());
        valueOutput.putBoolean("active_stocking", this.activeStocking);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.classicpipes.stocking_pipe");
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new StockingPipeMenu(id, playerInventory, this.filter, this.activeStocking);
    }
}

