/*
 * Decompiled with CFR 0.152.
 */
package com.automapupdater;

import com.automapupdater.AutoMapUpdater;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public static int updateInterval = 100;
    public static int maxMapsPerUpdate = 10;
    public static boolean debugMode = false;
    public static boolean enabled = true;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "automapupdater.json");

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                ConfigData data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                if (data != null) {
                    updateInterval = Config.clamp(data.updateInterval, 20, 1200);
                    maxMapsPerUpdate = Config.clamp(data.maxMapsPerUpdate, 1, 100);
                    debugMode = data.debugMode;
                    enabled = data.enabled;
                }
                AutoMapUpdater.LOGGER.info("Configuration loaded from {}", (Object)CONFIG_FILE);
            }
            catch (IOException e) {
                AutoMapUpdater.LOGGER.error("Failed to load config, using defaults", (Throwable)e);
                Config.save();
            }
        } else {
            Config.save();
        }
    }

    public static void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                ConfigData data = new ConfigData();
                data.updateInterval = updateInterval;
                data.maxMapsPerUpdate = maxMapsPerUpdate;
                data.debugMode = debugMode;
                data.enabled = enabled;
                GSON.toJson((Object)data, (Appendable)writer);
            }
            AutoMapUpdater.LOGGER.info("Configuration saved to {}", (Object)CONFIG_FILE);
        }
        catch (IOException e) {
            AutoMapUpdater.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    private static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    private static class ConfigData {
        public int updateInterval = 100;
        public int maxMapsPerUpdate = 10;
        public boolean debugMode = false;
        public boolean enabled = true;

        private ConfigData() {
        }
    }
}

