/*
 * Decompiled with CFR 0.152.
 */
package com.automapupdater;

import com.automapupdater.AutoMapUpdater;
import com.automapupdater.Config;
import net.minecraft.component.DataComponentTypes;
import net.minecraft.component.type.MapIdComponent;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.map.MapState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.server.world.ServerWorld;

public class MapUpdateHandler {
    private static int tickCounter = 0;
    private static int mapsUpdatedThisCycle = 0;

    public static void onServerTick(MinecraftServer server) {
        if (!Config.enabled) {
            return;
        }
        if (++tickCounter < Config.updateInterval) {
            return;
        }
        tickCounter = 0;
        mapsUpdatedThisCycle = 0;
        try {
            for (ServerPlayerEntity player : server.getPlayerManager().getPlayerList()) {
                if (player == null || player.getWorld() == null || player.isRemoved()) continue;
                MapUpdateHandler.updatePlayerMaps(player);
            }
        }
        catch (Exception e) {
            AutoMapUpdater.LOGGER.error("Error updating maps", (Throwable)e);
        }
    }

    private static void updatePlayerMaps(ServerPlayerEntity player) {
        ServerWorld world = player.getServerWorld();
        if (world == null || player.getInventory() == null) {
            return;
        }
        for (ItemStack stack : player.getInventory().main) {
            if (mapsUpdatedThisCycle >= Config.maxMapsPerUpdate) break;
            MapUpdateHandler.updateMapIfNeeded(stack, player, world);
        }
        for (ItemStack stack : player.getInventory().offHand) {
            if (mapsUpdatedThisCycle >= Config.maxMapsPerUpdate) break;
            MapUpdateHandler.updateMapIfNeeded(stack, player, world);
        }
    }

    private static void updateMapIfNeeded(ItemStack stack, ServerPlayerEntity player, ServerWorld world) {
        block8: {
            if (stack.isEmpty()) {
                return;
            }
            if (!stack.isOf(Items.FILLED_MAP)) {
                return;
            }
            try {
                MapIdComponent mapIdComponent = (MapIdComponent)stack.get(DataComponentTypes.MAP_ID);
                if (mapIdComponent == null) {
                    return;
                }
                MapState mapData = world.getMapState(mapIdComponent);
                if (mapData == null) {
                    return;
                }
                if (mapData.locked) {
                    return;
                }
                mapData.update((PlayerEntity)player, stack);
                ++mapsUpdatedThisCycle;
                if (Config.debugMode) {
                    AutoMapUpdater.LOGGER.debug("Updated map {} for player {}", (Object)mapIdComponent.id(), (Object)player.getName().getString());
                }
            }
            catch (Exception e) {
                if (!Config.debugMode) break block8;
                AutoMapUpdater.LOGGER.warn("Failed to update map item", (Throwable)e);
            }
        }
    }
}

