/*
 * Decompiled with CFR 0.152.
 */
package com.automapupdater;

import com.automapupdater.Config;
import com.automapupdater.MapUpdateHandler;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="automapupdater")
public class AutoMapUpdater {
    public static final String MOD_ID = "automapupdater";
    public static final Logger LOGGER = LoggerFactory.getLogger(AutoMapUpdater.class);

    public AutoMapUpdater(IEventBus modBus, ModContainer modContainer) {
        modBus.addListener(this::setup);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        LOGGER.info("AutoMapUpdater initializing...");
    }

    private void setup(FMLCommonSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new MapUpdateHandler());
        LOGGER.info("AutoMapUpdater registered - Maps will auto-update with config: interval={}, maxMaps={}", Config.UPDATE_INTERVAL.get(), Config.MAX_MAPS_PER_UPDATE.get());
    }
}

