/*
 * Decompiled with CFR 0.152.
 */
package com.automapupdater;

import com.automapupdater.AutoMapUpdater;
import com.automapupdater.Config;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class MapUpdateHandler {
    private int tickCounter = 0;
    private int mapsUpdatedThisCycle = 0;

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerLevel level = serverPlayer.serverLevel();
        if (level == null) {
            return;
        }
        if (!((Boolean)Config.ENABLED.get()).booleanValue()) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter < (Integer)Config.UPDATE_INTERVAL.get()) {
            return;
        }
        this.tickCounter = 0;
        this.mapsUpdatedThisCycle = 0;
        try {
            this.updatePlayerMaps(serverPlayer, level);
        }
        catch (Exception e) {
            AutoMapUpdater.LOGGER.error("Error updating maps for player {}", (Object)serverPlayer.getName().getString(), (Object)e);
        }
    }

    private void updatePlayerMaps(ServerPlayer player, ServerLevel level) {
        Inventory inventory = player.getInventory();
        for (int i = 0; i < 36 && this.mapsUpdatedThisCycle < (Integer)Config.MAX_MAPS_PER_UPDATE.get(); ++i) {
            this.updateMapIfNeeded(inventory.getItem(i), player, level);
        }
        this.updateMapIfNeeded(inventory.getItem(40), player, level);
    }

    private void updateMapIfNeeded(ItemStack stack, ServerPlayer player, ServerLevel level) {
        block6: {
            if (stack.isEmpty() || !stack.is(Items.FILLED_MAP)) {
                return;
            }
            try {
                MapId mapId = (MapId)stack.get(DataComponents.MAP_ID);
                if (mapId == null) {
                    return;
                }
                MapItemSavedData mapData = level.getMapData(mapId);
                if (mapData == null || mapData.locked || mapData.dimension != level.dimension()) {
                    return;
                }
                mapData.tickCarriedBy((Player)player, stack);
                ++this.mapsUpdatedThisCycle;
                if (((Boolean)Config.DEBUG_MODE.get()).booleanValue()) {
                    AutoMapUpdater.LOGGER.debug("Updated map {} for player {}", (Object)mapId.id(), (Object)player.getName().getString());
                }
            }
            catch (Exception e) {
                if (!((Boolean)Config.DEBUG_MODE.get()).booleanValue()) break block6;
                AutoMapUpdater.LOGGER.warn("Failed to update map item", (Throwable)e);
            }
        }
    }
}

