/*
 * Decompiled with CFR 0.152.
 */
package com.automapupdater;

import com.automapupdater.Config;
import com.automapupdater.MapUpdateHandler;
import com.mojang.logging.LogUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="automapupdater")
public class AutoMapUpdater {
    public static final String MOD_ID = "automapupdater";
    public static final Logger LOGGER = LogUtils.getLogger();

    public AutoMapUpdater(FMLJavaModLoadingContext context) {
        LOGGER.info("AutoMapUpdater initializing...");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        context.getModEventBus().addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("AutoMapUpdater registered - Maps will auto-update with config: interval={}, maxMaps={}", Config.updateInterval.get(), Config.maxMapsPerUpdate.get());
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            MapUpdateHandler.onServerTick(event.getServer());
        }
    }
}

