/*
 * Decompiled with CFR 0.152.
 */
package com.automapupdater;

import com.automapupdater.AutoMapUpdater;
import com.automapupdater.Config;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class MapUpdateHandler {
    private static int tickCounter = 0;
    private static int mapsUpdatedThisCycle = 0;

    public static void onServerTick(MinecraftServer server) {
        if (!((Boolean)Config.enabled.get()).booleanValue()) {
            return;
        }
        if (server == null || server.getPlayerList() == null) {
            return;
        }
        if (++tickCounter < (Integer)Config.updateInterval.get()) {
            return;
        }
        tickCounter = 0;
        mapsUpdatedThisCycle = 0;
        try {
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                if (player == null || player.level() == null || player.isRemoved()) continue;
                MapUpdateHandler.updatePlayerMaps(player);
            }
        }
        catch (Exception e) {
            AutoMapUpdater.LOGGER.error("Error updating maps", (Throwable)e);
        }
    }

    private static void updatePlayerMaps(ServerPlayer player) {
        if (player == null || player.level() == null || player.getInventory() == null) {
            return;
        }
        if (!(player.level() instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)player.level();
        for (ItemStack stack : player.getInventory().items) {
            if (mapsUpdatedThisCycle >= (Integer)Config.maxMapsPerUpdate.get()) break;
            MapUpdateHandler.updateMapIfNeeded(stack, player, world);
        }
        for (ItemStack stack : player.getInventory().offhand) {
            if (mapsUpdatedThisCycle >= (Integer)Config.maxMapsPerUpdate.get()) break;
            MapUpdateHandler.updateMapIfNeeded(stack, player, world);
        }
    }

    private static void updateMapIfNeeded(ItemStack stack, ServerPlayer player, ServerLevel world) {
        block6: {
            if (stack == null || stack.isEmpty() || !stack.is(Items.FILLED_MAP)) {
                return;
            }
            try {
                MapId mapId = (MapId)stack.get(DataComponents.MAP_ID);
                if (mapId == null) {
                    return;
                }
                MapItemSavedData mapData = world.getMapData(mapId);
                if (mapData == null || mapData.locked) {
                    return;
                }
                mapData.tickCarriedBy((Player)player, stack);
                ++mapsUpdatedThisCycle;
                if (((Boolean)Config.debugMode.get()).booleanValue()) {
                    AutoMapUpdater.LOGGER.debug("Updated map {} for player {}", (Object)mapId, (Object)player.getName().getString());
                }
            }
            catch (Exception e) {
                if (!((Boolean)Config.debugMode.get()).booleanValue()) break block6;
                AutoMapUpdater.LOGGER.warn("Failed to update map item", (Throwable)e);
            }
        }
    }
}

